/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.util.ArrayList;
import java.util.Locale;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBaseTest;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import junit.framework.AssertionFailedError;
import junitx.framework.StringAssert;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockFacesEvent;
import org.seasar.teeda.core.mock.MockUIComponentBase;
import org.seasar.teeda.core.mock.MockValueBinding;
import org.seasar.teeda.core.mock.MockViewHandlerImpl;
import org.seasar.teeda.core.mock.NullFacesEvent;
import org.seasar.teeda.core.mock.NullUIComponent;
import org.seasar.teeda.core.unit.ExceptionAssert;

public class UIViewRootTest
extends UIComponentBaseTest {
    public void testSetGetRenderKitId() {
        UIViewRoot viewRoot = this.createUIViewRoot();
        UIViewRootTest.assertEquals(null, (String)viewRoot.getRenderKitId());
        viewRoot.setRenderKitId("RENDER");
        UIViewRootTest.assertEquals((String)"RENDER", (String)viewRoot.getRenderKitId());
    }

    public void testSetGetRenderKitId_ValueBinding() {
        UIViewRoot viewRoot = this.createUIViewRoot();
        UIViewRootTest.assertEquals(null, (Object)viewRoot.getValueBinding("renderKitId"));
        MockValueBinding vb = new MockValueBinding();
        MockFacesContext context = this.getFacesContext();
        vb.setValue((FacesContext)context, (Object)"aaa");
        viewRoot.setValueBinding("renderKitId", (ValueBinding)vb);
        UIViewRootTest.assertEquals((String)"aaa", (String)viewRoot.getRenderKitId());
        UIViewRootTest.assertEquals((Object)"aaa", (Object)viewRoot.getValueBinding("renderKitId").getValue((FacesContext)context));
    }

    public void testGetRenderKitId_withNoValueBinding() throws Exception {
        UIViewRoot viewRoot = this.createUIViewRoot();
        viewRoot.setValueBinding("renderKitId", null);
        UIViewRootTest.assertEquals(null, (String)viewRoot.getRenderKitId());
    }

    public void testSetGetViewId() {
        UIViewRoot viewRoot = this.createUIViewRoot();
        UIViewRootTest.assertEquals(null, (String)viewRoot.getViewId());
        viewRoot.setViewId("bbb");
        UIViewRootTest.assertEquals((String)"bbb", (String)viewRoot.getViewId());
    }

    public void testSetGetViewId_ValueBindingNotWork() {
        UIViewRoot viewRoot = this.createUIViewRoot();
        UIViewRootTest.assertEquals(null, (Object)viewRoot.getValueBinding("viewId"));
        MockValueBinding vb = new MockValueBinding();
        MockFacesContext context = this.getFacesContext();
        vb.setValue((FacesContext)context, (Object)"aaa");
        viewRoot.setValueBinding("viewId", (ValueBinding)vb);
        UIViewRootTest.assertEquals(null, (String)viewRoot.getRenderKitId());
        UIViewRootTest.assertEquals((Object)"aaa", (Object)viewRoot.getValueBinding("viewId").getValue((FacesContext)context));
    }

    public void testQueueEvent() throws Exception {
        UIViewRoot viewRoot = this.createUIViewRoot();
        UIViewRootTest.assertEquals((int)0, (int)viewRoot.getEventSize());
        viewRoot.queueEvent((FacesEvent)new NullFacesEvent());
        UIViewRootTest.assertEquals((int)1, (int)viewRoot.getEventSize());
    }

    public void testQueueEvent_WithParent() throws Exception {
    }

    public void testProcessDecodes_Broadcast() throws Exception {
        final boolean[] calls = new boolean[]{false};
        UIViewRoot viewRoot = this.createUIViewRoot();
        NullUIComponent eventSource = new NullUIComponent(){

            public void broadcast(FacesEvent event) throws AbortProcessingException {
                calls[0] = true;
            }
        };
        MockFacesEvent event = new MockFacesEvent((UIComponent)eventSource);
        event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        viewRoot.queueEvent((FacesEvent)event);
        eventSource = new NullUIComponent(){

            public void broadcast(FacesEvent event) throws AbortProcessingException {
                throw new AssertionFailedError("should not be called");
            }
        };
        event = new MockFacesEvent((UIComponent)eventSource);
        event.setPhaseId(PhaseId.INVOKE_APPLICATION);
        viewRoot.queueEvent((FacesEvent)event);
        MockFacesContext context = this.getFacesContext();
        UIViewRootTest.assertEquals((int)2, (int)viewRoot.getEventSize());
        viewRoot.processDecodes((FacesContext)context);
        UIViewRootTest.assertEquals((boolean)true, (boolean)calls[0]);
        UIViewRootTest.assertEquals((int)1, (int)viewRoot.getEventSize());
    }

    public void testProcessDecodes_NotBroadcast() throws Exception {
        final boolean[] calls = new boolean[]{false};
        UIViewRoot viewRoot = this.createUIViewRoot();
        NullUIComponent eventSource = new NullUIComponent(){

            public void broadcast(FacesEvent event) throws AbortProcessingException {
                calls[0] = true;
            }
        };
        MockFacesEvent event = new MockFacesEvent((UIComponent)eventSource);
        event.setPhaseId(PhaseId.INVOKE_APPLICATION);
        viewRoot.queueEvent((FacesEvent)event);
        MockFacesContext context = this.getFacesContext();
        UIViewRootTest.assertEquals((int)1, (int)viewRoot.getEventSize());
        viewRoot.processDecodes((FacesContext)context);
        UIViewRootTest.assertEquals((boolean)false, (boolean)calls[0]);
        UIViewRootTest.assertEquals((int)1, (int)viewRoot.getEventSize());
    }

    public void testProcessDecodes_BroadcastRenderResponseCalled() throws Exception {
        UIViewRoot viewRoot = this.createUIViewRoot();
        Object eventSource = new MockUIComponentBase(){

            public void broadcast(FacesEvent event) throws AbortProcessingException {
                event.getComponent().getFacesContext().renderResponse();
            }
        };
        MockFacesEvent event = new MockFacesEvent((UIComponent)eventSource);
        event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        viewRoot.queueEvent((FacesEvent)event);
        eventSource = new NullUIComponent(){

            public void broadcast(FacesEvent event) throws AbortProcessingException {
                throw new AssertionFailedError("should not be called");
            }
        };
        event = new MockFacesEvent((UIComponent)eventSource);
        event.setPhaseId(PhaseId.INVOKE_APPLICATION);
        viewRoot.queueEvent((FacesEvent)event);
        MockFacesContext context = this.getFacesContext();
        UIViewRootTest.assertEquals((int)2, (int)viewRoot.getEventSize());
        viewRoot.processDecodes((FacesContext)context);
        UIViewRootTest.assertEquals((int)0, (int)viewRoot.getEventSize());
    }

    public void testEncodeBegin() throws Exception {
        UIViewRoot viewRoot = this.createUIViewRoot();
        String id = viewRoot.createUniqueId();
        viewRoot.encodeBegin((FacesContext)this.getFacesContext());
        UIViewRootTest.assertEquals((String)"unique counter should be reset by encodeBegin", (String)id, (String)viewRoot.createUniqueId());
    }

    public void testProcessValidators_Broadcast() throws Exception {
        final boolean[] calls = new boolean[]{false};
        UIViewRoot viewRoot = this.createUIViewRoot();
        NullUIComponent eventSource = new NullUIComponent(){

            public void broadcast(FacesEvent event) throws AbortProcessingException {
                calls[0] = true;
            }
        };
        MockFacesEvent event = new MockFacesEvent((UIComponent)eventSource);
        event.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
        viewRoot.queueEvent((FacesEvent)event);
        eventSource = new NullUIComponent(){

            public void broadcast(FacesEvent event) throws AbortProcessingException {
                throw new AssertionFailedError("should not be called");
            }
        };
        event = new MockFacesEvent((UIComponent)eventSource);
        event.setPhaseId(PhaseId.INVOKE_APPLICATION);
        viewRoot.queueEvent((FacesEvent)event);
        MockFacesContext context = this.getFacesContext();
        UIViewRootTest.assertEquals((int)2, (int)viewRoot.getEventSize());
        viewRoot.processValidators((FacesContext)context);
        UIViewRootTest.assertEquals((boolean)true, (boolean)calls[0]);
        UIViewRootTest.assertEquals((int)1, (int)viewRoot.getEventSize());
    }

    public void testProcessValidators_NotBroadcast() throws Exception {
        final boolean[] calls = new boolean[]{false};
        UIViewRoot viewRoot = this.createUIViewRoot();
        NullUIComponent eventSource = new NullUIComponent(){

            public void broadcast(FacesEvent event) throws AbortProcessingException {
                calls[0] = true;
            }
        };
        MockFacesEvent event = new MockFacesEvent((UIComponent)eventSource);
        event.setPhaseId(PhaseId.INVOKE_APPLICATION);
        viewRoot.queueEvent((FacesEvent)event);
        MockFacesContext context = this.getFacesContext();
        UIViewRootTest.assertEquals((int)1, (int)viewRoot.getEventSize());
        viewRoot.processValidators((FacesContext)context);
        UIViewRootTest.assertEquals((boolean)false, (boolean)calls[0]);
        UIViewRootTest.assertEquals((int)1, (int)viewRoot.getEventSize());
    }

    public void testProcessValidators_BroadcastRenderResponseCalled() throws Exception {
        UIViewRoot viewRoot = this.createUIViewRoot();
        Object eventSource = new MockUIComponentBase(){

            public void broadcast(FacesEvent event) throws AbortProcessingException {
                event.getComponent().getFacesContext().renderResponse();
            }
        };
        MockFacesEvent event = new MockFacesEvent((UIComponent)eventSource);
        event.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
        viewRoot.queueEvent((FacesEvent)event);
        eventSource = new NullUIComponent(){

            public void broadcast(FacesEvent event) throws AbortProcessingException {
                throw new AssertionFailedError("should not be called");
            }
        };
        event = new MockFacesEvent((UIComponent)eventSource);
        event.setPhaseId(PhaseId.INVOKE_APPLICATION);
        viewRoot.queueEvent((FacesEvent)event);
        MockFacesContext context = this.getFacesContext();
        UIViewRootTest.assertEquals((int)2, (int)viewRoot.getEventSize());
        viewRoot.processValidators((FacesContext)context);
        UIViewRootTest.assertEquals((int)0, (int)viewRoot.getEventSize());
    }

    public void testProcessUpdates_Broadcast() throws Exception {
        final boolean[] calls = new boolean[]{false};
        UIViewRoot viewRoot = this.createUIViewRoot();
        NullUIComponent eventSource = new NullUIComponent(){

            public void broadcast(FacesEvent event) throws AbortProcessingException {
                calls[0] = true;
            }
        };
        MockFacesEvent event = new MockFacesEvent((UIComponent)eventSource);
        event.setPhaseId(PhaseId.UPDATE_MODEL_VALUES);
        viewRoot.queueEvent((FacesEvent)event);
        eventSource = new NullUIComponent(){

            public void broadcast(FacesEvent event) throws AbortProcessingException {
                throw new AssertionFailedError("should not be called");
            }
        };
        event = new MockFacesEvent((UIComponent)eventSource);
        event.setPhaseId(PhaseId.INVOKE_APPLICATION);
        viewRoot.queueEvent((FacesEvent)event);
        MockFacesContext context = this.getFacesContext();
        UIViewRootTest.assertEquals((int)2, (int)viewRoot.getEventSize());
        viewRoot.processUpdates((FacesContext)context);
        UIViewRootTest.assertEquals((boolean)true, (boolean)calls[0]);
        UIViewRootTest.assertEquals((int)1, (int)viewRoot.getEventSize());
    }

    public void testProcessUpdates_NotBroadcast() throws Exception {
        final boolean[] calls = new boolean[]{false};
        UIViewRoot viewRoot = this.createUIViewRoot();
        NullUIComponent eventSource = new NullUIComponent(){

            public void broadcast(FacesEvent event) throws AbortProcessingException {
                calls[0] = true;
            }
        };
        MockFacesEvent event = new MockFacesEvent((UIComponent)eventSource);
        event.setPhaseId(PhaseId.INVOKE_APPLICATION);
        viewRoot.queueEvent((FacesEvent)event);
        MockFacesContext context = this.getFacesContext();
        UIViewRootTest.assertEquals((int)1, (int)viewRoot.getEventSize());
        viewRoot.processUpdates((FacesContext)context);
        UIViewRootTest.assertEquals((boolean)false, (boolean)calls[0]);
        UIViewRootTest.assertEquals((int)1, (int)viewRoot.getEventSize());
    }

    public void testProcessUpdates_BroadcastRenderResponseCalled() throws Exception {
        UIViewRoot viewRoot = this.createUIViewRoot();
        Object eventSource = new MockUIComponentBase(){

            public void broadcast(FacesEvent event) throws AbortProcessingException {
                event.getComponent().getFacesContext().renderResponse();
            }
        };
        MockFacesEvent event = new MockFacesEvent((UIComponent)eventSource);
        event.setPhaseId(PhaseId.UPDATE_MODEL_VALUES);
        viewRoot.queueEvent((FacesEvent)event);
        eventSource = new NullUIComponent(){

            public void broadcast(FacesEvent event) throws AbortProcessingException {
                throw new AssertionFailedError("should not be called");
            }
        };
        event = new MockFacesEvent((UIComponent)eventSource);
        event.setPhaseId(PhaseId.INVOKE_APPLICATION);
        viewRoot.queueEvent((FacesEvent)event);
        MockFacesContext context = this.getFacesContext();
        UIViewRootTest.assertEquals((int)2, (int)viewRoot.getEventSize());
        viewRoot.processUpdates((FacesContext)context);
        UIViewRootTest.assertEquals((int)0, (int)viewRoot.getEventSize());
    }

    public void testProcessApplication_NullArg() throws Exception {
        UIViewRoot viewRoot = this.createUIViewRoot();
        try {
            viewRoot.processApplication(null);
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public void testProcessApplication_Broadcast() throws Exception {
        final boolean[] calls = new boolean[]{false};
        UIViewRoot viewRoot = this.createUIViewRoot();
        NullUIComponent eventSource = new NullUIComponent(){

            public void broadcast(FacesEvent event) throws AbortProcessingException {
                calls[0] = true;
            }
        };
        MockFacesEvent event = new MockFacesEvent((UIComponent)eventSource);
        event.setPhaseId(PhaseId.INVOKE_APPLICATION);
        viewRoot.queueEvent((FacesEvent)event);
        eventSource = new NullUIComponent(){

            public void broadcast(FacesEvent event) throws AbortProcessingException {
                throw new AssertionFailedError("should not be called");
            }
        };
        event = new MockFacesEvent((UIComponent)eventSource);
        event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        viewRoot.queueEvent((FacesEvent)event);
        MockFacesContext context = this.getFacesContext();
        UIViewRootTest.assertEquals((int)2, (int)viewRoot.getEventSize());
        viewRoot.processApplication((FacesContext)context);
        UIViewRootTest.assertEquals((boolean)true, (boolean)calls[0]);
        UIViewRootTest.assertEquals((int)1, (int)viewRoot.getEventSize());
    }

    public void testProcessApplication_NotBroadcast() throws Exception {
        final boolean[] calls = new boolean[]{false};
        UIViewRoot viewRoot = this.createUIViewRoot();
        NullUIComponent eventSource = new NullUIComponent(){

            public void broadcast(FacesEvent event) throws AbortProcessingException {
                calls[0] = true;
            }
        };
        MockFacesEvent event = new MockFacesEvent((UIComponent)eventSource);
        event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        viewRoot.queueEvent((FacesEvent)event);
        MockFacesContext context = this.getFacesContext();
        UIViewRootTest.assertEquals((int)1, (int)viewRoot.getEventSize());
        viewRoot.processApplication((FacesContext)context);
        UIViewRootTest.assertEquals((boolean)false, (boolean)calls[0]);
        UIViewRootTest.assertEquals((int)1, (int)viewRoot.getEventSize());
    }

    public void testProcessApplication_BroadcastRenderResponseCalled() throws Exception {
        UIViewRoot viewRoot = this.createUIViewRoot();
        Object eventSource = new MockUIComponentBase(){

            public void broadcast(FacesEvent event) throws AbortProcessingException {
                event.getComponent().getFacesContext().renderResponse();
            }
        };
        MockFacesEvent event = new MockFacesEvent((UIComponent)eventSource);
        event.setPhaseId(PhaseId.INVOKE_APPLICATION);
        viewRoot.queueEvent((FacesEvent)event);
        eventSource = new NullUIComponent(){

            public void broadcast(FacesEvent event) throws AbortProcessingException {
                throw new AssertionFailedError("should not be called");
            }
        };
        event = new MockFacesEvent((UIComponent)eventSource);
        event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        viewRoot.queueEvent((FacesEvent)event);
        MockFacesContext context = this.getFacesContext();
        UIViewRootTest.assertEquals((int)2, (int)viewRoot.getEventSize());
        viewRoot.processApplication((FacesContext)context);
        UIViewRootTest.assertEquals((int)0, (int)viewRoot.getEventSize());
    }

    public void testCreateUniqueId() {
        UIViewRoot viewRoot = this.createUIViewRoot();
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            String id = viewRoot.createUniqueId();
            StringAssert.assertStartsWith((String)"_id", (String)id);
            UIViewRootTest.assertEquals((String)("should be unique:" + id), (boolean)false, (boolean)l.contains(id));
            l.add(id);
        }
    }

    public void testSetGetLocale() throws Exception {
        UIViewRoot viewRoot = this.createUIViewRoot();
        viewRoot.setLocale(Locale.GERMAN);
        UIViewRootTest.assertEquals((Object)Locale.GERMAN, (Object)viewRoot.getLocale());
    }

    public void testGetLocale_ValueBinding() throws Exception {
        UIViewRoot viewRoot = this.createUIViewRoot();
        MockFacesContext context = this.getFacesContext();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)context, (Object)Locale.ITALIAN);
        viewRoot.setValueBinding("locale", (ValueBinding)vb);
        UIViewRootTest.assertEquals((Object)Locale.ITALIAN, (Object)viewRoot.getLocale());
        UIViewRootTest.assertEquals((Object)Locale.ITALIAN, (Object)viewRoot.getValueBinding("locale").getValue((FacesContext)context));
    }

    public void testGetLocale_ValueBindingString() throws Exception {
        UIViewRoot viewRoot = this.createUIViewRoot();
        MockFacesContext context = this.getFacesContext();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)context, (Object)"ja");
        viewRoot.setValueBinding("locale", (ValueBinding)vb);
        UIViewRootTest.assertEquals((Object)Locale.JAPANESE, (Object)viewRoot.getLocale());
        UIViewRootTest.assertEquals((Object)"ja", (Object)viewRoot.getValueBinding("locale").getValue((FacesContext)context));
    }

    public void testGetLocale_ViewHandler() throws Exception {
        UIViewRoot viewRoot = this.createUIViewRoot();
        MockFacesContext context = this.getFacesContext();
        MockViewHandlerImpl handler = new MockViewHandlerImpl();
        handler.setLocale(Locale.FRENCH);
        context.getApplication().setViewHandler((ViewHandler)handler);
        UIViewRootTest.assertEquals((Object)Locale.FRENCH, (Object)viewRoot.getLocale());
    }

    private UIViewRoot createUIViewRoot() {
        return (UIViewRoot)this.createUIComponent();
    }

    protected UIComponent createUIComponent() {
        return new UIViewRoot();
    }
}

