/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.assembler.impl;

import java.util.Map;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.application.ConfigurationSupport;
import org.seasar.teeda.core.application.ConverterConfiguration;
import org.seasar.teeda.core.config.faces.assembler.ConverterAssembler;
import org.seasar.teeda.core.config.faces.assembler.ConverterChildAssembler;
import org.seasar.teeda.core.config.faces.element.ConverterElement;

public class DefaultConverterAssembler
extends ConverterAssembler {
    private ConverterChildAssembler converterIdAssembler_;
    private ConverterChildAssembler conveterClassAssembler_;

    public DefaultConverterAssembler(Map convertersByClass, Map convertersById) {
        super(convertersByClass, convertersById);
    }

    protected void setupBeforeAssemble() {
        this.converterIdAssembler_ = new ConverterChildAssemblerById(this.getConvertersById());
        this.conveterClassAssembler_ = new ConverterChildAssemblerByTargetClass(this.getConvertersByClass());
    }

    public void assemble() {
        this.converterIdAssembler_.assemble();
        this.conveterClassAssembler_.assemble();
    }

    private static class ConverterChildAssemblerByTargetClass
    extends ConverterChildAssembler {
        public ConverterChildAssemblerByTargetClass(Map targetConverters) {
            super(targetConverters);
        }

        protected void doAssemble(String converterForClass, ConverterElement converterElement) {
            String converterClass = converterElement.getConverterClass();
            if (!StringUtil.isEmpty((String)converterClass)) {
                Class targetClazz = ClassUtil.forName((String)converterForClass);
                this.getApplication().addConverter(targetClazz, converterClass);
            }
        }

        protected void doAddConverterConfiguration(ConfigurationSupport support, String converterForClass, ConverterConfiguration configuration) {
            Class targetClazz = ClassUtil.forName((String)converterForClass);
            support.addConverterConfiguration(targetClazz, configuration);
        }
    }

    private static class ConverterChildAssemblerById
    extends ConverterChildAssembler {
        public ConverterChildAssemblerById(Map targetConverters) {
            super(targetConverters);
        }

        protected void doAssemble(String converterId, ConverterElement converterElement) {
            String converterClass = converterElement.getConverterClass();
            if (!StringUtil.isEmpty((String)converterClass)) {
                this.getApplication().addConverter(converterId, converterClass);
            }
        }

        protected void doAddConverterConfiguration(ConfigurationSupport support, String converterKey, ConverterConfiguration configuration) {
            support.addConverterConfiguration(converterKey, configuration);
        }
    }
}

