/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.internal.ConvertUtil;
import javax.faces.internal.FacesMessageUtil;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.NumberConversionUtil;

public class IntegerConverter
implements Converter {
    public static final String CONVERTER_ID = "javax.faces.Integer";
    public static final String CONVERSION_OBJECT_ID = IntegerConverter.class.getName() + ".CONVERSION";
    public static final String CONVERSION_STRING_ID = IntegerConverter.class.getName() + ".CONVERSION_STRING";

    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        AssertionUtil.assertNotNull((String)"FacesContext", (Object)context);
        AssertionUtil.assertNotNull((String)"UIComponent", (Object)component);
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() < 1) {
            return null;
        }
        Locale locale = context.getViewRoot().getLocale();
        value = NumberConversionUtil.removeDelimeter((String)value, (Locale)locale);
        try {
            return Integer.valueOf(value);
        }
        catch (Exception e) {
            Object[] args = ConvertUtil.createExceptionMessageArgs(component, value);
            throw new ConverterException(FacesMessageUtil.getMessage(context, this.getObjectMessageId(), args), (Throwable)e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        AssertionUtil.assertNotNull((String)"FacesContext", (Object)context);
        AssertionUtil.assertNotNull((String)"UIComponent", (Object)component);
        if (value == null) {
            return "";
        }
        try {
            return value instanceof String ? (String)value : Integer.toString((Integer)value);
        }
        catch (Exception e) {
            Object[] args = ConvertUtil.createExceptionMessageArgs(component, value);
            throw new ConverterException(FacesMessageUtil.getMessage(context, this.getStringMessageId(), args), (Throwable)e);
        }
    }

    protected String getObjectMessageId() {
        return CONVERSION_OBJECT_ID;
    }

    protected String getStringMessageId() {
        return CONVERSION_STRING_ID;
    }
}

