/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.webapp.element.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seasar.teeda.core.config.webapp.element.ContextParamElement;
import org.seasar.teeda.core.config.webapp.element.FilterElement;
import org.seasar.teeda.core.config.webapp.element.ServletElement;
import org.seasar.teeda.core.config.webapp.element.ServletMappingElement;
import org.seasar.teeda.core.config.webapp.element.TaglibElement;
import org.seasar.teeda.core.config.webapp.element.WebappConfig;

public class WebappConfigImpl
implements WebappConfig,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map contextParams = new HashMap();
    private final Map filters = new HashMap();
    private final Map servletsByName = new HashMap();
    private final Map servletsByClass = new HashMap();
    private final List taglibs = new ArrayList();
    private final Map servletMappings = new HashMap();

    public List getContextParamElements() {
        return new ArrayList(this.contextParams.values());
    }

    public ContextParamElement getContextParamElementByParamName(String name) {
        return (ContextParamElement)this.contextParams.get(name);
    }

    public void addContextParamElement(ContextParamElement contextParam) {
        this.contextParams.put(contextParam.getParamName(), contextParam);
    }

    public List getServletElements() {
        return new ArrayList(this.servletsByName.values());
    }

    public ServletElement getServletElementByServletName(String servletName) {
        return (ServletElement)this.servletsByName.get(servletName);
    }

    public ServletElement getServletElementByServletClass(String servletClass) {
        return (ServletElement)this.servletsByClass.get(servletClass);
    }

    public void addServletElement(ServletElement servlet) {
        this.servletsByName.put(servlet.getServletName(), servlet);
        this.servletsByClass.put(servlet.getServletClass(), servlet);
    }

    public List getFilterElements() {
        return new ArrayList(this.filters.values());
    }

    public FilterElement getFilterElementByFilterName(String filterName) {
        return (FilterElement)this.filters.get(filterName);
    }

    public void addFilterElement(FilterElement filterElement) {
        this.filters.put(filterElement.getFilterName(), filterElement);
    }

    public List getTaglibElements() {
        return Collections.unmodifiableList(this.taglibs);
    }

    public void addTaglibElement(TaglibElement taglibElement) {
        this.taglibs.add(taglibElement);
    }

    public List getServletMappingElements() {
        return new ArrayList(this.servletMappings.values());
    }

    public ServletMappingElement getServletMappingElementByServletName(String servletName) {
        return (ServletMappingElement)this.servletMappings.get(servletName);
    }

    public void addServletMappingElement(ServletMappingElement servletMappingElement) {
        this.servletMappings.put(servletMappingElement.getServletName(), servletMappingElement);
    }

    public ServletMappingElement getServletMappingElementByServletClass(String servletClass) {
        ServletElement servletElement = this.getServletElementByServletClass(servletClass);
        if (servletElement == null) {
            return null;
        }
        ServletMappingElement servletMappingElement = this.getServletMappingElementByServletName(servletElement.getServletName());
        return servletMappingElement;
    }
}

