/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputTextarea;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import javax.faces.render.RendererTest;
import org.custommonkey.xmlunit.Diff;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockUIComponentBaseWithNamingContainer;
import org.seasar.teeda.core.render.html.HtmlInputTextareaRenderer;

public class HtmlInputTextareaRendererTest
extends RendererTest {
    private HtmlInputTextareaRenderer renderer;
    private MockHtmlInputTextarea htmlInputTextarea;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlInputTextareaRenderer();
        this.htmlInputTextarea = new MockHtmlInputTextarea();
        this.htmlInputTextarea.setRenderer((Renderer)this.renderer);
    }

    public void testEncode_WithNoValue() throws Exception {
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputTextarea);
        HtmlInputTextareaRendererTest.assertEquals((String)"<textarea name=\"_id0\"></textarea>", (String)this.getResponseText());
    }

    public void testEncode_RenderFalse() throws Exception {
        this.htmlInputTextarea.setRendered(false);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputTextarea);
        HtmlInputTextareaRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_WithValue() throws Exception {
        this.htmlInputTextarea.setValue("abc");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputTextarea);
        HtmlInputTextareaRendererTest.assertEquals((String)"<textarea name=\"_id0\">abc</textarea>", (String)this.getResponseText());
    }

    public void testEncode_WithId() throws Exception {
        this.htmlInputTextarea.setId("a");
        MockUIComponentBaseWithNamingContainer parent = new MockUIComponentBaseWithNamingContainer();
        parent.setId("b");
        parent.getChildren().add(this.htmlInputTextarea);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputTextarea);
        HtmlInputTextareaRendererTest.assertEquals((String)"<textarea id=\"a\" name=\"b:a\"></textarea>", (String)this.getResponseText());
    }

    public void testEncode_WithName() throws Exception {
        this.htmlInputTextarea.setId("a");
        this.htmlInputTextarea.getAttributes().put("name", "hoge");
        MockUIComponentBaseWithNamingContainer parent = new MockUIComponentBaseWithNamingContainer();
        parent.setId("b");
        parent.getChildren().add(this.htmlInputTextarea);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputTextarea);
        HtmlInputTextareaRendererTest.assertEquals((String)"<textarea id=\"a\" name=\"b:a\"></textarea>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute() throws Exception {
        this.htmlInputTextarea.setId("a");
        this.htmlInputTextarea.getAttributes().put("aa", "bb");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlInputTextarea);
        HtmlInputTextareaRendererTest.assertEquals((String)"<textarea id=\"a\" name=\"a\" aa=\"bb\"></textarea>", (String)this.getResponseText());
    }

    public void testDecode_None() throws Exception {
        this.htmlInputTextarea.setClientId("key1");
        MockFacesContext context = this.getFacesContext();
        this.renderer.decode((FacesContext)context, (UIComponent)this.htmlInputTextarea);
        HtmlInputTextareaRendererTest.assertEquals(null, (Object)this.htmlInputTextarea.getSubmittedValue());
    }

    public void testDecode_Success() throws Exception {
        this.htmlInputTextarea.setClientId("key1");
        MockFacesContext context = this.getFacesContext();
        context.getExternalContext().getRequestParameterMap().put("key1", "aabb");
        this.renderer.decode((FacesContext)context, (UIComponent)this.htmlInputTextarea);
        HtmlInputTextareaRendererTest.assertEquals((Object)"aabb", (Object)this.htmlInputTextarea.getSubmittedValue());
    }

    public void testEncodeBegin_WithAllAttributes() throws Exception {
        this.htmlInputTextarea.setAccesskey("a");
        this.htmlInputTextarea.setCols(10);
        this.htmlInputTextarea.setDir("c");
        this.htmlInputTextarea.setDisabled(true);
        this.htmlInputTextarea.setLang("e");
        this.htmlInputTextarea.setOnblur("g");
        this.htmlInputTextarea.setOnchange("h");
        this.htmlInputTextarea.setOnclick("i");
        this.htmlInputTextarea.setOndblclick("j");
        this.htmlInputTextarea.setOnfocus("k");
        this.htmlInputTextarea.setOnkeydown("l");
        this.htmlInputTextarea.setOnkeypress("m");
        this.htmlInputTextarea.setOnkeyup("n");
        this.htmlInputTextarea.setOnmousedown("o");
        this.htmlInputTextarea.setOnmousemove("p");
        this.htmlInputTextarea.setOnmouseout("q");
        this.htmlInputTextarea.setOnmouseover("r");
        this.htmlInputTextarea.setOnmouseup("s");
        this.htmlInputTextarea.setOnselect("t");
        this.htmlInputTextarea.setReadonly(true);
        this.htmlInputTextarea.setRows(20);
        this.htmlInputTextarea.setStyle("w");
        this.htmlInputTextarea.setStyleClass("u");
        this.htmlInputTextarea.setTabindex("x");
        this.htmlInputTextarea.setTitle("y");
        this.htmlInputTextarea.setWrap("z");
        this.htmlInputTextarea.setId("A");
        this.htmlInputTextarea.setValue("B");
        MockFacesContext context = this.getFacesContext();
        this.renderer.encodeBegin((FacesContext)context, (UIComponent)this.htmlInputTextarea);
        this.renderer.encodeEnd((FacesContext)context, (UIComponent)this.htmlInputTextarea);
        Diff diff = new Diff("<textarea id=\"A\" name=\"A\" accesskey=\"a\" cols=\"10\" dir=\"c\" disabled=\"disabled\" lang=\"e\" onblur=\"g\" onchange=\"h\" onclick=\"i\" ondblclick=\"j\" onfocus=\"k\" onkeydown=\"l\" onkeypress=\"m\" onkeyup=\"n\" onmousedown=\"o\" onmousemove=\"p\" onmouseout=\"q\" onmouseover=\"r\" onmouseup=\"s\" onselect=\"t\" readonly=\"readonly\" rows=\"20\" style=\"w\" class=\"u\" tabindex=\"x\" title=\"y\" wrap=\"z\">B</textarea>", this.getResponseText());
        HtmlInputTextareaRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testGetRendersChildren() throws Exception {
        HtmlInputTextareaRendererTest.assertEquals((boolean)false, (boolean)this.renderer.getRendersChildren());
    }

    private HtmlInputTextareaRenderer createHtmlInputTextareaRenderer() {
        return (HtmlInputTextareaRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlInputTextareaRenderer renderer = new HtmlInputTextareaRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }

    private static class MockHtmlInputTextarea
    extends HtmlInputTextarea {
        private Renderer renderer_;
        private String clientId_;

        private MockHtmlInputTextarea() {
        }

        public void setRenderer(Renderer renderer) {
            this.renderer_ = renderer;
        }

        protected Renderer getRenderer(FacesContext context) {
            if (this.renderer_ != null) {
                return this.renderer_;
            }
            return super.getRenderer(context);
        }

        public String getClientId(FacesContext context) {
            if (this.clientId_ != null) {
                return this.clientId_;
            }
            return super.getClientId(context);
        }

        public void setClientId(String clientId) {
            this.clientId_ = clientId;
        }
    }
}

