/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import javax.faces.render.RendererTest;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.custommonkey.xmlunit.Diff;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.framework.mock.servlet.MockHttpServletRequestImpl;
import org.seasar.framework.mock.servlet.MockHttpServletResponse;
import org.seasar.framework.mock.servlet.MockHttpServletResponseImpl;
import org.seasar.framework.mock.servlet.MockServletContext;
import org.seasar.framework.mock.servlet.MockServletContextImpl;
import org.seasar.teeda.core.application.ViewHandlerImpl;
import org.seasar.teeda.core.config.webapp.element.WebappConfig;
import org.seasar.teeda.core.config.webapp.element.impl.WebappConfigImpl;
import org.seasar.teeda.core.mock.MockExternalContext;
import org.seasar.teeda.core.mock.MockExternalContextImpl;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockHtmlForm;
import org.seasar.teeda.core.mock.MockStateManager;
import org.seasar.teeda.core.mock.MockViewHandlerImpl;
import org.seasar.teeda.core.render.html.HtmlFormRenderer;

public class HtmlFormRendererTest
extends RendererTest {
    private HtmlFormRenderer renderer;
    private MockHtmlForm htmlForm;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlFormRenderer();
        this.htmlForm = new MockHtmlForm();
        this.htmlForm.setRenderer((Renderer)this.renderer);
        this.htmlForm.setEnctype(null);
        this.renderer.addIgnoreAttributeName("setSubmittedCalls");
    }

    public void testEncode_NoValue() throws Exception {
        MockFacesContext context = this.getFacesContext();
        context.getViewRoot().setViewId("/aa");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlForm);
        System.out.println(this.getResponseText());
        HtmlFormRendererTest.assertEquals((String)"<form name=\"_id0\" method=\"post\" enctype=\"application/x-www-form-urlencoded\" action=\"/aa\"><input type=\"hidden\" name=\"_id0/aa\" value=\"_id0\" /></form>", (String)this.getResponseText());
    }

    public void testEncode_CallsViewHandler() throws Exception {
        MockFacesContext context = this.getFacesContext();
        final boolean[] calls = new boolean[]{false};
        context.getApplication().setViewHandler((ViewHandler)new MockViewHandlerImpl(){

            public void writeState(FacesContext context) throws IOException {
                calls[0] = true;
            }
        });
        context.getViewRoot().setViewId("/abc");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlForm);
        HtmlFormRendererTest.assertEquals((boolean)true, (boolean)calls[0]);
    }

    public void testEncode_RenderFalse() throws Exception {
        this.htmlForm.setRendered(false);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlForm);
        HtmlFormRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_WithId() throws Exception {
        MockFacesContext context = this.getFacesContext();
        context.getViewRoot().setViewId("/abc");
        this.htmlForm.setId("a");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlForm);
        HtmlFormRendererTest.assertEquals((String)"<form id=\"a\" name=\"a\" method=\"post\" enctype=\"application/x-www-form-urlencoded\" action=\"/abc\"><input type=\"hidden\" name=\"a/abc\" value=\"a\" /></form>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute() throws Exception {
        MockFacesContext context = this.getFacesContext();
        context.getViewRoot().setViewId("/abc");
        this.htmlForm.setId("a");
        this.htmlForm.getAttributes().put("zz", "yy");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlForm);
        HtmlFormRendererTest.assertEquals((String)"<form id=\"a\" name=\"a\" method=\"post\" enctype=\"application/x-www-form-urlencoded\" zz=\"yy\" action=\"/abc\"><input type=\"hidden\" name=\"a/abc\" value=\"a\" /></form>", (String)this.getResponseText());
    }

    public void testEncode_WithAllAttributes() throws Exception {
        this.htmlForm.setAccept("a");
        this.htmlForm.setAcceptcharset("b");
        this.htmlForm.setDir("c");
        this.htmlForm.setEnctype("d");
        this.htmlForm.setLang("e");
        this.htmlForm.setOnclick("f");
        this.htmlForm.setOndblclick("g");
        this.htmlForm.setOnkeydown("h");
        this.htmlForm.setOnkeypress("i");
        this.htmlForm.setOnkeyup("j");
        this.htmlForm.setOnmousedown("k");
        this.htmlForm.setOnmousemove("l");
        this.htmlForm.setOnmouseout("m");
        this.htmlForm.setOnmouseover("n");
        this.htmlForm.setOnmouseup("o");
        this.htmlForm.setOnreset("p");
        this.htmlForm.setOnsubmit("q");
        this.htmlForm.setStyle("r");
        this.htmlForm.setStyleClass("s");
        this.htmlForm.setTarget("t");
        this.htmlForm.setTitle("u");
        this.htmlForm.setId("AA");
        this.htmlForm.getAttributes().put("name", "BB");
        this.htmlForm.getAttributes().put("method", "CC");
        MockFacesContext context = this.getFacesContext();
        context.getViewRoot().setViewId("/xyz");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlForm);
        Diff diff = new Diff("<form id=\"AA\" name=\"AA\" method=\"post\" accept=\"a\" accept-charset=\"b\" dir=\"c\" enctype=\"d\" lang=\"e\" onclick=\"f\" ondblclick=\"g\" onkeydown=\"h\" onkeypress=\"i\" onkeyup=\"j\" onmousedown=\"k\" onmousemove=\"l\" onmouseout=\"m\" onmouseover=\"n\" onmouseup=\"o\" onreset=\"p\" onsubmit=\"q\" style=\"r\" class=\"s\" target=\"t\" title=\"u\" action=\"/xyz?newwindow=true\"><input type=\"hidden\" name=\"AA/xyz\" value=\"AA\" /></form>", this.getResponseText());
        HtmlFormRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testEncode_WithoutCookie() throws Exception {
        MockFacesContext facesContext = this.getFacesContext();
        MockExternalContext externalContext = (MockExternalContext)facesContext.getExternalContext();
        externalContext.setMockHttpServletResponse((MockHttpServletResponse)new MockHttpServletResponseImpl((HttpServletRequest)externalContext.getMockHttpServletRequest()){

            public String encodeURL(String url) {
                return url + ";jsessionid=HOGEHOGE";
            }
        });
        facesContext.getViewRoot().setViewId("/aa");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlForm);
        System.out.println(this.getResponseText());
        HtmlFormRendererTest.assertEquals((String)"<form name=\"_id0\" method=\"post\" enctype=\"application/x-www-form-urlencoded\" action=\"/aa;jsessionid=HOGEHOGE\"><input type=\"hidden\" name=\"_id0/aa\" value=\"_id0\" /></form>", (String)this.getResponseText());
    }

    public void testDecode_None() throws Exception {
        this.htmlForm.setClientId("key");
        MockFacesContext context = this.getFacesContext();
        this.renderer.decode((FacesContext)context, (UIComponent)this.htmlForm);
        HtmlFormRendererTest.assertEquals((int)1, (int)this.htmlForm.getSetSubmittedCalls());
        HtmlFormRendererTest.assertEquals((boolean)false, (boolean)this.htmlForm.isSubmitted());
    }

    public void testDecode_Success() throws Exception {
        this.htmlForm.setClientId("key1");
        MockFacesContext context = this.getFacesContext();
        context.getViewRoot().setViewId("/xyz");
        context.getExternalContext().getRequestParameterMap().put("key1/xyz", "12345");
        this.renderer.decode((FacesContext)context, (UIComponent)this.htmlForm);
        HtmlFormRendererTest.assertEquals((int)1, (int)this.htmlForm.getSetSubmittedCalls());
        HtmlFormRendererTest.assertEquals((boolean)true, (boolean)this.htmlForm.isSubmitted());
    }

    public void testAction_Null() throws Exception {
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlForm);
        HtmlFormRendererTest.assertTrue((this.getResponseText().indexOf("action") == -1 ? 1 : 0) != 0);
    }

    public void testGetRendersChildren() throws Exception {
        HtmlFormRendererTest.assertEquals((boolean)false, (boolean)this.renderer.getRendersChildren());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEncode_HiddenValue() throws Exception {
        MockFacesContext context = this.getFacesContext();
        context.getViewRoot().setViewId("/aa");
        HtmlFormRenderer.setCommandLinkHiddenParameter((UIForm)this.htmlForm, (String)"hoge", (Object)"foo");
        try {
            this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlForm);
            String readText = "<form name=\"_id0\" method=\"post\" enctype=\"application/x-www-form-urlencoded\" action=\"/aa\"><input type=\"hidden\" name=\"_id0/aa\" value=\"_id0\" /><input type=\"hidden\" name=\"hoge\" value=\"foo\" /><script language=\"JavaScript\" type=\"text/javascript\">\n<!--\nfunction clear__5Fid0(){var f = document.forms['_id0']; f.elements['hoge'].value='null'; f.target='';} clear__5Fid0();\n//-->\n</script></form>";
            Diff diff = this.diff(readText, this.getResponseText());
            HtmlFormRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
        }
        finally {
            HtmlFormRenderer.clearCommandLinkHiddenParameters((UIForm)this.htmlForm, (String)"hoge");
        }
    }

    public void testEncode_encodeActionURL() throws Exception {
        MockFacesContext context = this.getFacesContext();
        MockServletContextImpl servletContext = new MockServletContextImpl("/aaa");
        MockHttpServletRequestImpl req = new MockHttpServletRequestImpl((ServletContext)servletContext, "/bbb");
        MockHttpServletResponseImpl res = new MockHttpServletResponseImpl((HttpServletRequest)req);
        MockExternalContextImpl extContext = new MockExternalContextImpl((MockServletContext)servletContext, (MockHttpServletRequest)req, (MockHttpServletResponse)res);
        context.setExternalContext((ExternalContext)extContext);
        ViewHandlerImpl handler = new ViewHandlerImpl();
        context.getApplication().setViewHandler((ViewHandler)handler);
        context.getViewRoot().setViewId("/cc");
        MockStateManager sm = new MockStateManager();
        context.getApplication().setStateManager((StateManager)sm);
        WebappConfigImpl webAppConfig = new WebappConfigImpl();
        extContext.getApplicationMap().put(WebappConfig.class.getName(), webAppConfig);
        this.htmlForm.setTarget("_blank");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlForm);
        String readText = "<form name=\"_id0\" method=\"post\" enctype=\"application/x-www-form-urlencoded\" target=\"_blank\" action=\"/aaa/cc?newwindow=true\"><input type=\"hidden\" name=\"_id0/cc\" value=\"_id0\" /></form>";
        Diff diff = this.diff(readText, this.getResponseText());
        HtmlFormRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    private HtmlFormRenderer createHtmlFormRenderer() {
        return (HtmlFormRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlFormRenderer renderer = new HtmlFormRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }
}

