/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.el;

import java.util.HashMap;
import javax.faces.el.PropertyResolver;
import junit.framework.TestCase;
import org.seasar.teeda.core.el.TeedaPropertyResolver;
import org.seasar.teeda.core.exception.SetterNotFoundRuntimeException;
import org.seasar.teeda.core.mock.MockUIComponent;

public class TeedaPropertyResolverTest
extends TestCase {
    public void testGetValue_baseIsNull() throws Exception {
        PropertyResolver resolver = this.createPropertyResolver();
        TeedaPropertyResolverTest.assertNull((Object)resolver.getValue(null, (Object)"a"));
    }

    public void testGetValue_propertyIsNull() throws Exception {
        PropertyResolver resolver = this.createPropertyResolver();
        TeedaPropertyResolverTest.assertNull((Object)resolver.getValue((Object)"a", null));
    }

    public void testGetValue_baseIsMapAndValueFound() throws Exception {
        PropertyResolver resolver = this.createPropertyResolver();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "A");
        map.put("b", "B");
        TeedaPropertyResolverTest.assertEquals((Object)"A", (Object)resolver.getValue(map, (Object)"a"));
    }

    public void testGetValue_baseIsMapAndValueNotFound() throws Exception {
        PropertyResolver resolver = this.createPropertyResolver();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "A");
        map.put("b", "B");
        TeedaPropertyResolverTest.assertNull((Object)resolver.getValue(map, (Object)"c"));
    }

    public void testGetValue_UIComponentButNoChildren() throws Exception {
        PropertyResolver resolver = this.createPropertyResolver();
        MockUIComponent component = new MockUIComponent();
        TeedaPropertyResolverTest.assertNull((Object)resolver.getValue((Object)component, (Object)"id"));
    }

    public void testSetValue() throws Exception {
        PropertyResolver resolver = this.createPropertyResolver();
        try {
            resolver.setValue((Object)new Hoge(), (Object)"name", (Object)"hoge");
            TeedaPropertyResolverTest.fail();
        }
        catch (SetterNotFoundRuntimeException expected) {
            TeedaPropertyResolverTest.assertTrue((boolean)true);
        }
    }

    private PropertyResolver createPropertyResolver() {
        return new TeedaPropertyResolver();
    }

    public static class Hoge {
        private String name;

        public String getName() {
            return this.name;
        }
    }
}

