/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.webapp.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.faces.webapp.FacesServlet;
import junit.framework.TestCase;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.teeda.core.config.webapp.element.ContextParamElement;
import org.seasar.teeda.core.config.webapp.element.FilterElement;
import org.seasar.teeda.core.config.webapp.element.InitParamElement;
import org.seasar.teeda.core.config.webapp.element.ServletElement;
import org.seasar.teeda.core.config.webapp.element.ServletMappingElement;
import org.seasar.teeda.core.config.webapp.element.TaglibElement;
import org.seasar.teeda.core.config.webapp.element.WebappConfig;
import org.seasar.teeda.core.config.webapp.impl.WebappConfigBuilderImpl;

public class WebappConfigBuilderImplTest
extends TestCase {
    public void testContextParam() throws Exception {
        WebappConfig webappConfig = this.buildWebappConfig("WebappConfigBuilderImplTest-ContextParam-web.xml");
        List contextParams = webappConfig.getContextParamElements();
        WebappConfigBuilderImplTest.assertEquals((int)2, (int)contextParams.size());
        WebappConfigBuilderImplTest.assertEquals((boolean)true, (boolean)(contextParams.get(0) instanceof ContextParamElement));
        ContextParamElement contextParam = webappConfig.getContextParamElementByParamName("javax.faces.CONFIG_FILES");
        WebappConfigBuilderImplTest.assertNotNull((Object)contextParam);
        WebappConfigBuilderImplTest.assertEquals((String)"/WEB-INF/faces-config.xml", (String)contextParam.getParamValue());
        WebappConfigBuilderImplTest.assertEquals((String)"javax.faces.CONFIG_FILES", (String)contextParam.getParamName());
        WebappConfigBuilderImplTest.assertEquals((String)".html", (String)webappConfig.getContextParamElementByParamName("javax.faces.DEFAULT_SUFFIX").getParamValue());
    }

    public void testFilter() throws Exception {
        WebappConfig webappConfig = this.buildWebappConfig("WebappConfigBuilderImplTest-Filter-web.xml");
        List filterElements = webappConfig.getFilterElements();
        WebappConfigBuilderImplTest.assertEquals((int)2, (int)filterElements.size());
        WebappConfigBuilderImplTest.assertEquals((boolean)true, (boolean)(filterElements.get(0) instanceof FilterElement));
        FilterElement filter = webappConfig.getFilterElementByFilterName("encodingfilter");
        WebappConfigBuilderImplTest.assertNotNull((Object)filter);
        WebappConfigBuilderImplTest.assertEquals((String)"encodingfilter", (String)filter.getFilterName());
        WebappConfigBuilderImplTest.assertEquals((String)"org.seasar.extension.filter.EncodingFilter", (String)filter.getFilterClass());
        InitParamElement initParam = filter.getInitParamElementByParamName("encoding");
        WebappConfigBuilderImplTest.assertNotNull((Object)initParam);
        WebappConfigBuilderImplTest.assertEquals((String)"encoding", (String)initParam.getParamName());
        WebappConfigBuilderImplTest.assertEquals((String)"UTF-8", (String)initParam.getParamValue());
    }

    public void testServlet() throws Exception {
        WebappConfig webappConfig = this.buildWebappConfig("WebappConfigBuilderImplTest-Servlet-web.xml");
        List servletElements = webappConfig.getServletElements();
        WebappConfigBuilderImplTest.assertEquals((int)2, (int)servletElements.size());
        ServletElement servletElement = (ServletElement)servletElements.get(0);
        WebappConfigBuilderImplTest.assertEquals((String)"facesServlet", (String)servletElement.getServletName());
        WebappConfigBuilderImplTest.assertEquals((String)FacesServlet.class.getName(), (String)servletElement.getServletClass());
        servletElement = (ServletElement)servletElements.get(1);
        WebappConfigBuilderImplTest.assertEquals((String)"s2servlet", (String)servletElement.getServletName());
        ServletElement servlet = webappConfig.getServletElementByServletName("s2servlet");
        InitParamElement initParam = servlet.getInitParamElementByParamName("debug");
        WebappConfigBuilderImplTest.assertNotNull((Object)initParam);
        WebappConfigBuilderImplTest.assertEquals((String)"debug", (String)initParam.getParamName());
        WebappConfigBuilderImplTest.assertEquals((String)"true", (String)initParam.getParamValue());
        servlet = webappConfig.getServletElementByServletClass(FacesServlet.class.getName());
        WebappConfigBuilderImplTest.assertEquals((String)"facesServlet", (String)servlet.getServletName());
        List servletMappingElements = webappConfig.getServletMappingElements();
        WebappConfigBuilderImplTest.assertEquals((int)1, (int)servletMappingElements.size());
        ServletMappingElement servletMappingElement = (ServletMappingElement)servletMappingElements.get(0);
        WebappConfigBuilderImplTest.assertEquals((String)"facesServlet", (String)servletMappingElement.getServletName());
        WebappConfigBuilderImplTest.assertEquals((String)"/view/*", (String)servletMappingElement.getUrlPattern());
        servletMappingElement = webappConfig.getServletMappingElementByServletName("facesServlet");
        WebappConfigBuilderImplTest.assertEquals((String)"facesServlet", (String)servletMappingElement.getServletName());
        WebappConfigBuilderImplTest.assertEquals((String)"/view/*", (String)servletMappingElement.getUrlPattern());
        ServletMappingElement servletMappingElement2 = webappConfig.getServletMappingElementByServletClass("javax.faces.webapp.FacesServlet");
        WebappConfigBuilderImplTest.assertEquals((String)"facesServlet", (String)servletMappingElement2.getServletName());
        WebappConfigBuilderImplTest.assertEquals((String)"/view/*", (String)servletMappingElement2.getUrlPattern());
    }

    public void testTaglib() throws Exception {
        WebappConfig webappConfig = this.buildWebappConfig("WebappConfigBuilderImplTest-Taglib-web.xml");
        List taglibElements = webappConfig.getTaglibElements();
        WebappConfigBuilderImplTest.assertEquals((int)2, (int)taglibElements.size());
        TaglibElement taglib = (TaglibElement)taglibElements.get(0);
        WebappConfigBuilderImplTest.assertEquals((String)"http://www.seasar.org/jsf", (String)taglib.getTaglibUri());
        WebappConfigBuilderImplTest.assertEquals((String)"/WEB-INF/s2jsf.tld", (String)taglib.getTaglibLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebappConfig buildWebappConfig(String webXml) throws IOException {
        WebappConfigBuilderImpl builder = new WebappConfigBuilderImpl();
        String path = ((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/') + "/" + webXml;
        InputStream is = ResourceUtil.getResourceAsStream((String)path);
        try {
            WebappConfig webappConfig = builder.build(is, path);
            WebappConfigBuilderImplTest.assertNotNull((Object)webappConfig);
            WebappConfig webappConfig2 = webappConfig;
            return webappConfig2;
        }
        finally {
            InputStreamUtil.close((InputStream)is);
        }
    }
}

