/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.math.BigInteger;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.IntegerConverter;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.ValueBinding;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.internal.ConverterBuilder;
import javax.faces.internal.ConverterResource;
import javax.faces.internal.NormalConverterBuilderImpl;
import javax.faces.render.Renderer;
import javax.faces.validator.ValidatorException;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junitx.framework.ObjectAssert;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.teeda.core.mock.MockApplicationImpl;
import org.seasar.teeda.core.mock.MockConverter;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockFacesContextImpl;
import org.seasar.teeda.core.mock.MockMethodBinding;
import org.seasar.teeda.core.mock.MockUIInput;
import org.seasar.teeda.core.mock.MockValueBinding;
import org.seasar.teeda.core.mock.NullRenderer;
import org.seasar.teeda.core.mock.NullValidator;

public class UIInputOnlyTest
extends TestCase {
    public void setUp() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        SingletonS2ContainerFactory.setContainer((S2Container)container);
        SingletonS2ContainerFactory.init();
        ConverterResource.setConverterBuilder((ConverterBuilder)new NormalConverterBuilderImpl((S2Container)container));
    }

    public void testConstants() throws Exception {
        UIInputOnlyTest.assertEquals((String)"javax.faces.Input", (String)"javax.faces.Input");
        UIInputOnlyTest.assertEquals((String)"javax.faces.Input", (String)"javax.faces.Input");
        UIInputOnlyTest.assertEquals((String)"javax.faces.component.UIInput.CONVERSION", (String)"javax.faces.component.UIInput.CONVERSION");
        UIInputOnlyTest.assertEquals((String)"javax.faces.component.UIInput.REQUIRED", (String)"javax.faces.component.UIInput.REQUIRED");
    }

    public void testGetFamily() {
        UIInputOnlyTest.assertEquals((String)"javax.faces.Input", (String)new UIInput().getFamily());
    }

    public void testDefaultRendererType() throws Exception {
        UIInputOnlyTest.assertEquals((String)"javax.faces.Text", (String)new UIInput().getRendererType());
    }

    public void testProcessDecodes_CallValidateWhenImmediateIsTrue() throws Exception {
        final boolean[] calls = new boolean[]{false};
        MockUIInput input = new MockUIInput(){

            public void validate(FacesContext context) {
                calls[0] = true;
            }

            protected Renderer getRenderer(FacesContext context) {
                return null;
            }
        };
        input.setImmediate(true);
        MockFacesContext context = this.getFacesContext();
        input.processDecodes((FacesContext)context);
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)calls[0]);
        UIInputOnlyTest.assertEquals((boolean)false, (boolean)context.getRenderResponse());
    }

    public void testProcessDecodes_NotCallValidateWhenImmediateIsFalse() throws Exception {
        MockFacesContext context = this.getFacesContext();
        final boolean[] calls = new boolean[]{false};
        MockUIInput input = new MockUIInput(){

            public void validate(FacesContext context) {
                calls[0] = true;
            }

            protected Renderer getRenderer(FacesContext context) {
                return null;
            }
        };
        input.setImmediate(false);
        input.processDecodes((FacesContext)context);
        UIInputOnlyTest.assertEquals((boolean)false, (boolean)calls[0]);
        UIInputOnlyTest.assertEquals((boolean)false, (boolean)context.getRenderResponse());
    }

    public void testProcessDecodes_CallRenderResponseWhenNotValid() throws Exception {
        MockFacesContext context = this.getFacesContext();
        final boolean[] calls = new boolean[]{false};
        MockUIInput input = new MockUIInput(){

            public void validate(FacesContext context) {
                calls[0] = true;
                this.setValid(false);
            }

            protected Renderer getRenderer(FacesContext context) {
                return null;
            }
        };
        input.setImmediate(true);
        input.processDecodes((FacesContext)context);
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)calls[0]);
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)context.getRenderResponse());
    }

    public void testProcessDecodes_CallRenderResponseWhenRuntimeExceptionThrown() throws Exception {
        MockFacesContext context = this.getFacesContext();
        final boolean[] calls = new boolean[]{false};
        MockUIInput input = new MockUIInput(){

            public void validate(FacesContext context) {
                calls[0] = true;
                throw new RuntimeException("for test");
            }

            protected Renderer getRenderer(FacesContext context) {
                return null;
            }
        };
        input.setImmediate(true);
        try {
            input.processDecodes((FacesContext)context);
            UIInputOnlyTest.fail();
        }
        catch (RuntimeException expected) {
            UIInputOnlyTest.assertEquals((String)"for test", (String)expected.getMessage());
        }
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)calls[0]);
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)context.getRenderResponse());
    }

    public void testProcessValidators_CallValidateWhenImmediateIsFalse() throws Exception {
        MockFacesContext context = this.getFacesContext();
        final boolean[] calls = new boolean[]{false};
        MockUIInput input = new MockUIInput(){

            public void validate(FacesContext context) {
                calls[0] = true;
            }
        };
        input.setImmediate(false);
        input.setValid(true);
        input.processValidators((FacesContext)context);
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)calls[0]);
        UIInputOnlyTest.assertEquals((boolean)false, (boolean)context.getRenderResponse());
    }

    public void testProcessValidators_NotCallValidateWhenImmediateIsTrue() throws Exception {
        MockFacesContext context = this.getFacesContext();
        final boolean[] calls = new boolean[]{false};
        MockUIInput input = new MockUIInput(){

            public void validate(FacesContext context) {
                calls[0] = true;
            }
        };
        input.setImmediate(true);
        input.processValidators((FacesContext)context);
        UIInputOnlyTest.assertEquals((boolean)false, (boolean)calls[0]);
        UIInputOnlyTest.assertEquals((boolean)false, (boolean)context.getRenderResponse());
    }

    public void testProcessValidators_RenderResponseIsCalledWhenNotValid() throws Exception {
        MockFacesContext context = this.getFacesContext();
        final boolean[] calls = new boolean[]{false};
        MockUIInput input = new MockUIInput(){

            public void validate(FacesContext context) {
                calls[0] = true;
                this.setValid(false);
            }
        };
        input.setImmediate(false);
        input.processValidators((FacesContext)context);
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)calls[0]);
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)context.getRenderResponse());
    }

    public void testProcessValidators_RenderResponseIsCalledWhenRuntimeExceptionThrown() throws Exception {
        MockFacesContext context = this.getFacesContext();
        final boolean[] calls = new boolean[]{false};
        MockUIInput input = new MockUIInput(){

            public void validate(FacesContext context) {
                calls[0] = true;
                throw new RuntimeException("for test");
            }
        };
        input.setImmediate(false);
        try {
            input.processValidators((FacesContext)context);
            UIInputOnlyTest.fail();
        }
        catch (RuntimeException expected) {
            UIInputOnlyTest.assertEquals((String)"for test", (String)expected.getMessage());
        }
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)calls[0]);
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)context.getRenderResponse());
    }

    public void testProcessUpdates_CallUpdateModel() throws Exception {
        MockFacesContext context = this.getFacesContext();
        final boolean[] calls = new boolean[]{false};
        MockUIInput input = new MockUIInput(){

            public void updateModel(FacesContext context) {
                calls[0] = true;
            }
        };
        input.setValid(true);
        input.processUpdates((FacesContext)context);
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)calls[0]);
        UIInputOnlyTest.assertEquals((boolean)false, (boolean)context.getRenderResponse());
    }

    public void testProcessUpdates_RenderResponseIsCalledWhenNotValid() throws Exception {
        MockFacesContext context = this.getFacesContext();
        final boolean[] calls = new boolean[]{false};
        MockUIInput input = new MockUIInput(){

            public void updateModel(FacesContext context) {
                calls[0] = true;
                this.setValid(false);
            }
        };
        input.processUpdates((FacesContext)context);
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)calls[0]);
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)context.getRenderResponse());
    }

    public void testProcessUpdates_RenderResponseIsCalledWhenRuntimeExceptionThrown() throws Exception {
        MockFacesContext context = this.getFacesContext();
        final boolean[] calls = new boolean[]{false};
        MockUIInput input = new MockUIInput(){

            public void updateModel(FacesContext context) {
                calls[0] = true;
                throw new RuntimeException("for test");
            }
        };
        try {
            input.processUpdates((FacesContext)context);
            UIInputOnlyTest.fail();
        }
        catch (RuntimeException expected) {
            UIInputOnlyTest.assertEquals((String)"for test", (String)expected.getMessage());
        }
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)calls[0]);
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)context.getRenderResponse());
    }

    public void testUpdateModel_DoNothingWhenNotValid() throws Exception {
        UIInput input = new UIInput();
        input.setValid(false);
        input.setLocalValueSet(true);
        input.updateModel((FacesContext)this.getFacesContext());
        UIInputOnlyTest.assertTrue((String)"take no further action", (boolean)true);
        UIInputOnlyTest.assertEquals((boolean)false, (boolean)input.isValid());
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)input.isLocalValueSet());
    }

    public void testUpdateModel_DoNothingWhenLocalValueNotSet() throws Exception {
        UIInput input = new UIInput();
        input.setValid(true);
        input.setLocalValueSet(false);
        input.updateModel((FacesContext)this.getFacesContext());
        UIInputOnlyTest.assertTrue((String)"take no further action", (boolean)true);
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)input.isValid());
        UIInputOnlyTest.assertEquals((boolean)false, (boolean)input.isLocalValueSet());
    }

    public void testUpdateModel_DoNothingWhenValueBindingForValueNotSet() throws Exception {
        UIInput input = new UIInput();
        input.setValid(true);
        input.setValueBinding("value", null);
        input.updateModel((FacesContext)this.getFacesContext());
        UIInputOnlyTest.assertTrue((String)"take no further action", (boolean)true);
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)input.isValid());
        UIInputOnlyTest.assertEquals((boolean)false, (boolean)input.isLocalValueSet());
    }

    public void testUpdateModel_CallValueBindingSetValue() throws Exception {
        final boolean[] calls = new boolean[]{false};
        final Object[] params = new Object[]{null};
        UIInput input = new UIInput();
        input.setValue((Object)"a");
        input.setValid(true);
        MockValueBinding vb = new MockValueBinding(){

            public void setValue(FacesContext context, Object obj) throws EvaluationException, PropertyNotFoundException {
                calls[0] = true;
                params[0] = obj;
            }
        };
        MockFacesContext context = this.getFacesContext();
        input.setValueBinding("value", (ValueBinding)vb);
        input.updateModel((FacesContext)context);
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)calls[0]);
        UIInputOnlyTest.assertEquals((Object)"a", (Object)params[0]);
        UIInputOnlyTest.assertEquals(null, (Object)input.getLocalValue());
        UIInputOnlyTest.assertEquals((boolean)false, (boolean)input.isLocalValueSet());
    }

    public void testUpdateModel_ValueBindingSetValueFailed() throws Exception {
        final boolean[] calls = new boolean[]{false};
        MockUIInput input = new MockUIInput(){

            protected Renderer getRenderer(FacesContext context) {
                return null;
            }
        };
        input.setValue("a");
        input.setValid(true);
        MockValueBinding vb = new MockValueBinding(){

            public void setValue(FacesContext context, Object obj) throws EvaluationException, PropertyNotFoundException {
                calls[0] = true;
                throw new EvaluationException("forTest");
            }
        };
        MockFacesContext context = this.getFacesContext();
        input.setValueBinding("value", (ValueBinding)vb);
        UIInputOnlyTest.assertEquals((boolean)false, (boolean)context.getMessages().hasNext());
        input.updateModel((FacesContext)context);
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)calls[0]);
        Iterator messages = context.getMessages();
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)messages.hasNext());
        messages.next();
        UIInputOnlyTest.assertEquals((boolean)false, (boolean)messages.hasNext());
        UIInputOnlyTest.assertEquals((boolean)false, (boolean)input.isValid());
        UIInputOnlyTest.assertEquals((Object)"a", (Object)input.getLocalValue());
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)input.isLocalValueSet());
    }

    public void testValidate_DoNothingWhenSubmittedValueIsNull() throws Exception {
        MockUIInput input = new MockUIInput(){

            protected Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
                throw new AssertionFailedError("shouldn't be called");
            }
        };
        input.setSubmittedValue(null);
        input.setValid(true);
        input.validate((FacesContext)this.getFacesContext());
        UIInputOnlyTest.assertTrue((String)"take no further action", (boolean)true);
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)input.isValid());
    }

    public void testValidate_SetConvertedValue() throws Exception {
        MockUIInput input = new MockUIInput(){

            protected Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
                return submittedValue + "_" + "converted";
            }
        };
        input.setValue("a_converted");
        input.setSubmittedValue("a");
        input.setValid(true);
        input.validate((FacesContext)this.getFacesContext());
        UIInputOnlyTest.assertEquals((Object)"a_converted", (Object)input.getValue());
        UIInputOnlyTest.assertEquals(null, (Object)input.getSubmittedValue());
    }

    public void testValidate_NotSetConvertedValueWhenNotValid() throws Exception {
        MockUIInput input = new MockUIInput(){

            protected Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
                this.setValid(false);
                return submittedValue + "_converted";
            }
        };
        input.setSubmittedValue("a");
        input.setValid(true);
        input.validate((FacesContext)this.getFacesContext());
        UIInputOnlyTest.assertEquals(null, (Object)input.getValue());
        UIInputOnlyTest.assertEquals((Object)"a", (Object)input.getSubmittedValue());
    }

    public void testVaildate_QueueValueChangeEvent() throws Exception {
        final FacesEvent[] params = new FacesEvent[]{null};
        MockUIInput input = new MockUIInput(){

            public void queueEvent(FacesEvent event) {
                params[0] = event;
            }

            protected Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
                return submittedValue;
            }
        };
        input.setSubmittedValue("a");
        input.setValue("b");
        input.setValid(true);
        input.validate((FacesContext)this.getFacesContext());
        UIInputOnlyTest.assertNotNull((Object)params[0]);
        ObjectAssert.assertInstanceOf((Class)ValueChangeEvent.class, (Object)params[0]);
    }

    public void testVaildate_NotQueueValueChangeEvent() throws Exception {
        final FacesEvent[] facesEvent = new FacesEvent[1];
        MockUIInput input = new MockUIInput(){

            public void queueEvent(FacesEvent event) {
                facesEvent[0] = event;
            }

            protected Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
                return submittedValue;
            }
        };
        input.setSubmittedValue("a");
        input.setValue("a");
        input.setValid(true);
        input.validate((FacesContext)this.getFacesContext());
        UIInputOnlyTest.assertNull((Object)facesEvent[0]);
    }

    public void testGetConvertedValue_UsingRenderer() throws Exception {
        MockUIInput input = new MockUIInput(){

            protected Renderer getRenderer(FacesContext context) {
                return new NullRenderer(this){
                    private final /* synthetic */ 20 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
                        return submittedValue + ":converted";
                    }
                };
            }
        };
        Object convertedValue = input.getConvertedValue((FacesContext)this.getFacesContext(), "1");
        UIInputOnlyTest.assertEquals((Object)"1:converted", (Object)convertedValue);
    }

    public void testGetConvertedValue_UsingConverter() throws Exception {
        MockUIInput input = new MockUIInput(){

            protected Renderer getRenderer(FacesContext context) {
                return null;
            }
        };
        input.setConverter((Converter)new MockConverter(){

            public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
                return value + "@";
            }
        });
        Object convertedValue = input.getConvertedValue((FacesContext)this.getFacesContext(), "a");
        UIInputOnlyTest.assertEquals((Object)"a@", (Object)convertedValue);
    }

    public void testGetConvertedValue_NoConversionWhenValueBindingGetTypeReturnsNull() throws Exception {
        final boolean[] calls = new boolean[]{false};
        MockUIInput input = new MockUIInput(){

            protected Renderer getRenderer(FacesContext context) {
                return null;
            }
        };
        input.setConverter(null);
        MockValueBinding vb = new MockValueBinding(){

            public Class getType(FacesContext context) throws EvaluationException, PropertyNotFoundException {
                calls[0] = true;
                return null;
            }
        };
        input.setValueBinding("value", (ValueBinding)vb);
        Object convertedValue = input.getConvertedValue((FacesContext)this.getFacesContext(), "a");
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)calls[0]);
        UIInputOnlyTest.assertEquals((Object)"a", (Object)convertedValue);
    }

    public void testGetConvertedValue_CreateConverterFromValueBindingType() throws Exception {
        MockUIInput input = new MockUIInput(){

            protected Renderer getRenderer(FacesContext context) {
                return null;
            }
        };
        input.setConverter(null);
        MockValueBinding vb = new MockValueBinding(){

            public Class getType(FacesContext context) throws EvaluationException, PropertyNotFoundException {
                return class$java$math$BigInteger == null ? (class$java$math$BigInteger = UIInputOnlyTest.class$("java.math.BigInteger")) : class$java$math$BigInteger;
            }
        };
        input.setValueBinding("value", (ValueBinding)vb);
        final Object[] createConverterParams = new Object[]{null};
        MockFacesContext context = this.getFacesContext();
        context.setApplication((Application)new MockApplicationImpl(){

            public Converter createConverter(Class targetClass) {
                createConverterParams[0] = targetClass;
                return new MockConverter(this){
                    private final /* synthetic */ 28 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
                        return value + "aa";
                    }
                };
            }
        });
        Object convertedValue = input.getConvertedValue((FacesContext)context, "22");
        UIInputOnlyTest.assertEquals((Object)"22aa", (Object)convertedValue);
        UIInputOnlyTest.assertEquals((Object)BigInteger.class, (Object)createConverterParams[0]);
    }

    public void testGetConvertedValue_WithoutAnyConversionWhenNoRendererAndNotStringSubmitted() throws Exception {
        MockUIInput input = new MockUIInput(){

            protected Renderer getRenderer(FacesContext context) {
                return null;
            }

            public Converter getConverter() {
                throw new AssertionFailedError("shouldn't be called");
            }
        };
        input.setValueBinding("value", null);
        Object convertedValue = input.getConvertedValue((FacesContext)this.getFacesContext(), new Integer(123));
        UIInputOnlyTest.assertEquals((Object)new Integer(123), (Object)convertedValue);
    }

    public void testGetConvertedValue_WithoutAnyConversion2() throws Exception {
        MockUIInput input = new MockUIInput(){

            protected Renderer getRenderer(FacesContext context) {
                return null;
            }
        };
        input.setConverter(null);
        input.setValueBinding("value", null);
        Object convertedValue = input.getConvertedValue((FacesContext)this.getFacesContext(), "a");
        UIInputOnlyTest.assertEquals((Object)"a", (Object)convertedValue);
    }

    public void testValidateValue_DoNothingWhenNotValid() throws Exception {
        UIInput input = new UIInput();
        input.setValid(false);
        input.setRequired(true);
        input.validateValue((FacesContext)this.getFacesContext(), (Object)"b");
        UIInputOnlyTest.assertTrue((String)"take no further action", (boolean)true);
        UIInputOnlyTest.assertEquals((boolean)false, (boolean)input.isValid());
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)input.isRequired());
    }

    public void testValidateValue_DoNothingWhenNotRequired() throws Exception {
        UIInput input = new UIInput();
        input.setValid(true);
        input.setRequired(false);
        input.validateValue((FacesContext)this.getFacesContext(), (Object)"b");
        UIInputOnlyTest.assertTrue((String)"take no further action", (boolean)true);
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)input.isValid());
        UIInputOnlyTest.assertEquals((boolean)false, (boolean)input.isRequired());
    }

    public void testValidateValue_LocalValueIsEmpty() throws Exception {
        MockUIInput input = new MockUIInput(){

            protected Renderer getRenderer(FacesContext context) {
                return null;
            }
        };
        input.setValid(true);
        input.setRequired(true);
        MockFacesContext context = this.getFacesContext();
        input.validateValue((FacesContext)context, "");
        Iterator messages = context.getMessages();
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)messages.hasNext());
        messages.next();
        UIInputOnlyTest.assertEquals((boolean)false, (boolean)messages.hasNext());
        UIInputOnlyTest.assertEquals((boolean)false, (boolean)input.isValid());
    }

    public void testValidateValue_CallAddedValidators() throws Exception {
        final boolean[] calls = new boolean[2];
        MockUIInput input = new MockUIInput();
        input.setValid(true);
        input.setRequired(true);
        input.addValidator(new NullValidator(){

            public void validate(FacesContext context, UIComponent component, Object value) throws FacesException {
                calls[0] = true;
            }
        });
        input.addValidator(new NullValidator(){

            public void validate(FacesContext context, UIComponent component, Object value) throws FacesException {
                calls[1] = true;
            }
        });
        MockFacesContext context = this.getFacesContext();
        input.validateValue((FacesContext)context, "123");
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)calls[0]);
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)calls[1]);
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)input.isValid());
    }

    public void testValidateValue_CallSettedValidator() throws Exception {
        MockUIInput input = new MockUIInput(){

            protected Renderer getRenderer(FacesContext context) {
                return null;
            }
        };
        input.setValid(true);
        input.setRequired(true);
        MockMethodBinding validatorBinding = new MockMethodBinding();
        input.setValidator((MethodBinding)validatorBinding);
        MockFacesContext context = this.getFacesContext();
        input.validateValue((FacesContext)context, "123");
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)validatorBinding.isInvokeCalled());
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)input.isValid());
    }

    public void testValidateValue_CallValidatorsAndFailed() throws Exception {
        final boolean[] calls = new boolean[]{false, false};
        MockUIInput input = new MockUIInput(){

            protected Renderer getRenderer(FacesContext context) {
                return null;
            }
        };
        input.setValid(true);
        input.setRequired(true);
        input.addValidator(new NullValidator(){

            public void validate(FacesContext context, UIComponent component, Object value) throws FacesException {
                calls[0] = true;
                throw new ValidatorException(new FacesMessage("for test"));
            }
        });
        input.addValidator(new NullValidator(){

            public void validate(FacesContext context, UIComponent component, Object value) throws FacesException {
                calls[1] = true;
            }
        });
        MockMethodBinding validatorBinding = new MockMethodBinding();
        input.setValidator((MethodBinding)validatorBinding);
        MockFacesContext context = this.getFacesContext();
        input.validateValue((FacesContext)context, "123");
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)calls[0]);
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)calls[1]);
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)validatorBinding.isInvokeCalled());
        UIInputOnlyTest.assertEquals((boolean)false, (boolean)input.isValid());
        Iterator messages = context.getMessages();
        UIInputOnlyTest.assertEquals((boolean)true, (boolean)messages.hasNext());
        messages.next();
        UIInputOnlyTest.assertEquals((boolean)false, (boolean)messages.hasNext());
    }

    public final void testGetConvertedValue() throws Exception {
        UIViewRoot root = new UIViewRoot();
        UIInput input = new UIInput();
        input.setParent((UIComponent)root);
        input.setSubmittedValue((Object)"1000");
        input.setValid(true);
        SingletonS2ContainerFactory.getContainer().register((Object)new IntegerConverter(){

            public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
                return new Integer(value);
            }
        }, "integerConverter");
        ConverterResource.addConverter((String)"#{a.b}", (String)"integerConverter");
        input.setValueBinding("value", (ValueBinding)new MockValueBinding(){

            public String getExpressionString() {
                return "#{a.b}";
            }
        });
        input.validate((FacesContext)this.getFacesContext());
        UIInputOnlyTest.assertEquals((Object)new Integer(1000), (Object)input.getValue());
    }

    private MockFacesContext getFacesContext() {
        MockFacesContextImpl context = new MockFacesContextImpl();
        return context;
    }
}

