/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import org.seasar.teeda.core.unit.TeedaTestCase;
import org.seasar.teeda.core.util.ContentTypeUtil;

public class ContentTypeUtilTest
extends TeedaTestCase {
    public void testRemoveSemiColon_singleValues() throws Exception {
        String[] strs = ContentTypeUtil.removeSemiColon((String[])new String[]{"aaa;"});
        ContentTypeUtilTest.assertEquals((String)"aaa", (String)strs[0]);
    }

    public void testRemoveSemiColon_multipleValues() throws Exception {
        String[] strs = ContentTypeUtil.removeSemiColon((String[])new String[]{"aaa", "bbb;"});
        ContentTypeUtilTest.assertEquals((String)"aaa", (String)strs[0]);
        ContentTypeUtilTest.assertEquals((String)"bbb", (String)strs[1]);
    }

    public void testGetContentTypeFromFacesContext() throws Exception {
        this.getExternalContext().getRequestMap().put("Accept", "hoge");
        ContentTypeUtilTest.assertEquals((Object)"hoge", this.getExternalContext().getRequestMap().get("Accept"));
    }

    public void testIsHtmlContentType() throws Exception {
        ContentTypeUtilTest.assertFalse((boolean)ContentTypeUtil.isHtmlContentType((String)"hoge"));
        ContentTypeUtilTest.assertTrue((boolean)ContentTypeUtil.isHtmlContentType((String)"text/html"));
        ContentTypeUtilTest.assertTrue((boolean)ContentTypeUtil.isHtmlContentType((String)"*/*"));
        ContentTypeUtilTest.assertFalse((boolean)ContentTypeUtil.isHtmlContentType((String)"html/foo"));
    }

    public void testIsXmlContentType() throws Exception {
        ContentTypeUtilTest.assertFalse((boolean)ContentTypeUtil.isXmlContentType((String)"hoge"));
        ContentTypeUtilTest.assertTrue((boolean)ContentTypeUtil.isXmlContentType((String)"application/xhtml+xml"));
        ContentTypeUtilTest.assertTrue((boolean)ContentTypeUtil.isXmlContentType((String)"application/xml"));
        ContentTypeUtilTest.assertTrue((boolean)ContentTypeUtil.isXmlContentType((String)"text/xml"));
    }

    public void testGetContentType() throws Exception {
        ContentTypeUtilTest.assertEquals((String)"text/html", (String)ContentTypeUtil.getContentType((String)"hoge"));
        ContentTypeUtilTest.assertEquals((String)"text/html", (String)ContentTypeUtil.getContentType((String)"hoge, text/html, foo"));
        ContentTypeUtilTest.assertEquals((String)"text/html", (String)ContentTypeUtil.getContentType((String)"*/*"));
        ContentTypeUtilTest.assertEquals((String)"text/html", (String)ContentTypeUtil.getContentType((String)"hoge, */*, foo"));
        ContentTypeUtilTest.assertEquals((String)"application/xhtml+xml", (String)ContentTypeUtil.getContentType((String)"application/xhtml+xml"));
    }

    public void testGetContentType2() throws Exception {
        ContentTypeUtilTest.assertEquals((String)"text/html", (String)ContentTypeUtil.getContentType((String)"application/xml, text/html"));
        ContentTypeUtilTest.assertEquals((String)"text/html", (String)ContentTypeUtil.getContentType((String)"application/xhtml+xml, application/xml,text/html"));
        ContentTypeUtilTest.assertEquals((String)"text/html", (String)ContentTypeUtil.getContentType((String)" text/html"));
        ContentTypeUtilTest.assertNotSame((Object)"text/html", (Object)ContentTypeUtil.getContentType((String)"application/xml"));
    }
}

