/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.taglib.core;

import java.util.Locale;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.NumberConverter;
import javax.faces.el.ValueBinding;
import javax.servlet.jsp.PageContext;
import org.seasar.teeda.core.mock.MockApplication;
import org.seasar.teeda.core.mock.MockApplicationImpl;
import org.seasar.teeda.core.mock.MockValueBinding;
import org.seasar.teeda.core.mock.NullPageContext;
import org.seasar.teeda.core.taglib.core.ConvertNumberTag;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class ConvertNumberTagTest
extends TeedaTestCase {
    public void testSetPageContext() throws Exception {
        String converterId = "javax.faces.Number";
        String converterClassName = "javax.faces.convert.NumberConverter";
        MockApplicationImpl app = new MockApplicationImpl();
        app.addConverter(converterId, converterClassName);
        this.setApplication((MockApplication)app);
        ConvertNumberTag tag = new ConvertNumberTag();
        tag.setPageContext((PageContext)new NullPageContext());
        Converter c = tag.createConverter();
        ConvertNumberTagTest.assertNotNull((Object)c);
        ConvertNumberTagTest.assertTrue((boolean)(c instanceof NumberConverter));
    }

    public void testSetConverterCurrencyCode_constantValue() throws Exception {
        NumberConverter c = new NumberConverter();
        ConvertNumberTag tag = new ConvertNumberTag();
        tag.setCurrencyCode("JPY");
        tag.setConverterCurrencyCode((FacesContext)this.getFacesContext(), c);
        ConvertNumberTagTest.assertEquals((String)"JPY", (String)c.getCurrencyCode());
    }

    public void testSetConverterCurrencyCode_bindingValue() throws Exception {
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)"JPY");
        this.getApplication().setValueBinding((ValueBinding)vb);
        NumberConverter c = new NumberConverter();
        ConvertNumberTag tag = new ConvertNumberTag();
        tag.setCurrencyCode("#{hoge.japan}");
        tag.setConverterCurrencyCode((FacesContext)this.getFacesContext(), c);
        ConvertNumberTagTest.assertEquals((String)"JPY", (String)c.getCurrencyCode());
    }

    public void testSetConverterCurrencySymbol_bindingValue() throws Exception {
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)"$");
        this.getApplication().setValueBinding((ValueBinding)vb);
        NumberConverter c = new NumberConverter();
        ConvertNumberTag tag = new ConvertNumberTag();
        tag.setCurrencySymbol("#{hoge.doller}");
        tag.setConverterCurrencySymbol((FacesContext)this.getFacesContext(), c);
        ConvertNumberTagTest.assertEquals((String)"$", (String)c.getCurrencySymbol());
    }

    public void testSetConverterGroupingUsed_constantValue() throws Exception {
        NumberConverter c = new NumberConverter();
        ConvertNumberTag tag = new ConvertNumberTag();
        tag.setConverterGroupingUsed((FacesContext)this.getFacesContext(), c);
        ConvertNumberTagTest.assertTrue((new Boolean("true").booleanValue() == c.isGroupingUsed() ? 1 : 0) != 0);
    }

    public void testSetConverterGroupingUsed_bindingValue() throws Exception {
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)new Boolean(false));
        this.getApplication().setValueBinding((ValueBinding)vb);
        NumberConverter c = new NumberConverter();
        ConvertNumberTag tag = new ConvertNumberTag();
        tag.setGroupingUsed("#{hoge.false}");
        tag.setConverterGroupingUsed((FacesContext)this.getFacesContext(), c);
        ConvertNumberTagTest.assertEquals((boolean)false, (boolean)c.isGroupingUsed());
    }

    public void testSetConverterIntegerOnly_constantValue() throws Exception {
        NumberConverter c = new NumberConverter();
        ConvertNumberTag tag = new ConvertNumberTag();
        tag.setConverterGroupingUsed((FacesContext)this.getFacesContext(), c);
        ConvertNumberTagTest.assertTrue((new Boolean("false").booleanValue() == c.isIntegerOnly() ? 1 : 0) != 0);
    }

    public void testSetConverterIntegerOnly_bindingtValue() throws Exception {
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)new Boolean(true));
        this.getApplication().setValueBinding((ValueBinding)vb);
        NumberConverter c = new NumberConverter();
        ConvertNumberTag tag = new ConvertNumberTag();
        tag.setIntegerOnly("#{hoge.true}");
        tag.setConverterIntegerOnly((FacesContext)this.getFacesContext(), c);
        ConvertNumberTagTest.assertEquals((boolean)true, (boolean)c.isIntegerOnly());
    }

    public void testSetConverterLocale_constantValue() throws Exception {
        NumberConverter c = new NumberConverter();
        ConvertNumberTag tag = new ConvertNumberTag();
        tag.setLocale(Locale.CANADA.toString());
        tag.setConverterLocale((FacesContext)this.getFacesContext(), c);
        ConvertNumberTagTest.assertEquals((Object)Locale.CANADA, (Object)c.getLocale());
    }

    public void testSetConverterLocale_bindingValue() throws Exception {
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)Locale.ITALIAN);
        this.getApplication().setValueBinding((ValueBinding)vb);
        NumberConverter c = new NumberConverter();
        ConvertNumberTag tag = new ConvertNumberTag();
        tag.setLocale("#{locale.getmany}");
        tag.setConverterLocale((FacesContext)this.getFacesContext(), c);
        ConvertNumberTagTest.assertEquals((Object)Locale.ITALIAN, (Object)c.getLocale());
    }

    public void testSetConverterMaxFractionDigits_constantValue() throws Exception {
        NumberConverter c = new NumberConverter();
        ConvertNumberTag tag = new ConvertNumberTag();
        tag.setMaxFractionDigits("3");
        tag.setConverterMaxFractionDigits((FacesContext)this.getFacesContext(), c);
        ConvertNumberTagTest.assertEquals((int)3, (int)c.getMaxFractionDigits());
    }

    public void testSetConverterMaxFractionDigits_bindingValue() throws Exception {
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)new Integer(4));
        this.getApplication().setValueBinding((ValueBinding)vb);
        NumberConverter c = new NumberConverter();
        ConvertNumberTag tag = new ConvertNumberTag();
        tag.setMaxFractionDigits("#{hoge.maxfactiondigit}");
        tag.setConverterMaxFractionDigits((FacesContext)this.getFacesContext(), c);
        ConvertNumberTagTest.assertEquals((int)4, (int)c.getMaxFractionDigits());
    }

    public void testSetConverterMaxIntegerDigits_constantValue() throws Exception {
        NumberConverter c = new NumberConverter();
        ConvertNumberTag tag = new ConvertNumberTag();
        tag.setMaxIntegerDigits("5");
        tag.setConverterMaxIntegerDigits((FacesContext)this.getFacesContext(), c);
        ConvertNumberTagTest.assertEquals((int)5, (int)c.getMaxIntegerDigits());
    }

    public void testSetConverterMaxIntegerDigits_bindingValue() throws Exception {
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)new Integer(6));
        this.getApplication().setValueBinding((ValueBinding)vb);
        NumberConverter c = new NumberConverter();
        ConvertNumberTag tag = new ConvertNumberTag();
        tag.setMaxIntegerDigits("#{hoge.maxintegerdigits}");
        tag.setConverterMaxIntegerDigits((FacesContext)this.getFacesContext(), c);
        ConvertNumberTagTest.assertEquals((int)6, (int)c.getMaxIntegerDigits());
    }

    public void testConverterMinFractionDigits_constantValue() throws Exception {
        NumberConverter c = new NumberConverter();
        ConvertNumberTag tag = new ConvertNumberTag();
        tag.setMinFractionDigits("5");
        tag.setConverterMinFractionDigits((FacesContext)this.getFacesContext(), c);
        ConvertNumberTagTest.assertEquals((int)5, (int)c.getMinFractionDigits());
    }

    public void testSetConverterMinFractionDigits_bindingValue() throws Exception {
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)new Integer(6));
        this.getApplication().setValueBinding((ValueBinding)vb);
        NumberConverter c = new NumberConverter();
        ConvertNumberTag tag = new ConvertNumberTag();
        tag.setMinFractionDigits("#{hoge.minfractiondigits}");
        tag.setConverterMinFractionDigits((FacesContext)this.getFacesContext(), c);
        ConvertNumberTagTest.assertEquals((int)6, (int)c.getMinFractionDigits());
    }

    public void testSetConverterMinIntegerDigits_constantValue() throws Exception {
        NumberConverter c = new NumberConverter();
        ConvertNumberTag tag = new ConvertNumberTag();
        tag.setMinIntegerDigits("1");
        tag.setConverterMinIntegerDigits((FacesContext)this.getFacesContext(), c);
        ConvertNumberTagTest.assertEquals((int)1, (int)c.getMinIntegerDigits());
    }

    public void testSetConverterMinIntegerDigits_bindingValue() throws Exception {
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)new Integer(2));
        this.getApplication().setValueBinding((ValueBinding)vb);
        NumberConverter c = new NumberConverter();
        ConvertNumberTag tag = new ConvertNumberTag();
        tag.setMinIntegerDigits("#{hoge.minintegerdigits}");
        tag.setConverterMinIntegerDigits((FacesContext)this.getFacesContext(), c);
        ConvertNumberTagTest.assertEquals((int)2, (int)c.getMinIntegerDigits());
    }

    public void testSetConverterType_constantValue() throws Exception {
        NumberConverter c = new NumberConverter();
        ConvertNumberTag tag = new ConvertNumberTag();
        tag.setConverterGroupingUsed((FacesContext)this.getFacesContext(), c);
        ConvertNumberTagTest.assertEquals((String)"number", (String)"number");
    }

    public void testCreateConverter() throws Exception {
        String converterId = "javax.faces.Number";
        String converterClassName = "javax.faces.convert.NumberConverter";
        MockApplicationImpl app = new MockApplicationImpl();
        app.addConverter(converterId, converterClassName);
        this.setApplication((MockApplication)app);
        ConvertNumberTag tag = new ConvertNumberTag();
        tag.setPageContext((PageContext)new NullPageContext());
        tag.setCurrencyCode("JPY");
        tag.setCurrencySymbol("$");
        tag.setGroupingUsed("false");
        tag.setIntegerOnly("true");
        tag.setMaxFractionDigits("2");
        tag.setMaxIntegerDigits("4");
        tag.setMinFractionDigits("1");
        tag.setMinIntegerDigits("5");
        tag.setPattern("###,###.###");
        tag.setType("percent");
        Converter c = tag.createConverter();
        ConvertNumberTagTest.assertNotNull((Object)c);
        ConvertNumberTagTest.assertTrue((boolean)(c instanceof NumberConverter));
        NumberConverter nc = (NumberConverter)c;
        ConvertNumberTagTest.assertEquals((String)"JPY", (String)nc.getCurrencyCode());
        ConvertNumberTagTest.assertEquals((String)"$", (String)nc.getCurrencySymbol());
        ConvertNumberTagTest.assertEquals((boolean)false, (boolean)nc.isGroupingUsed());
        ConvertNumberTagTest.assertEquals((boolean)true, (boolean)nc.isIntegerOnly());
        ConvertNumberTagTest.assertEquals((int)2, (int)nc.getMaxFractionDigits());
        ConvertNumberTagTest.assertEquals((int)4, (int)nc.getMaxIntegerDigits());
        ConvertNumberTagTest.assertEquals((int)1, (int)nc.getMinFractionDigits());
        ConvertNumberTagTest.assertEquals((int)5, (int)nc.getMinIntegerDigits());
        ConvertNumberTagTest.assertEquals((String)"###,###.###", (String)nc.getPattern());
        ConvertNumberTagTest.assertEquals((String)"percent", (String)nc.getType());
    }

    public void testRelease() throws Exception {
        ConvertNumberTag tag = new ConvertNumberTag();
        tag.setCurrencyCode("JPY");
        tag.setCurrencySymbol("$");
        tag.setGroupingUsed("false");
        tag.setIntegerOnly("true");
        tag.setMaxFractionDigits("2");
        tag.setMaxIntegerDigits("4");
        tag.setMinFractionDigits("1");
        tag.setMinIntegerDigits("5");
        tag.setPattern("###,###.###");
        tag.setType("percent");
        tag.release();
        ConvertNumberTagTest.assertEquals(null, (String)tag.getCurrencyCode());
        ConvertNumberTagTest.assertEquals(null, (String)tag.getCurrencySymbol());
        ConvertNumberTagTest.assertEquals((String)"true", (String)tag.getGroupingUsed());
        ConvertNumberTagTest.assertEquals((String)"false", (String)tag.getIntegerOnly());
        ConvertNumberTagTest.assertEquals(null, (String)tag.getLocale());
        ConvertNumberTagTest.assertEquals(null, (String)tag.getMaxFractionDigits());
        ConvertNumberTagTest.assertEquals(null, (String)tag.getMaxIntegerDigits());
        ConvertNumberTagTest.assertEquals(null, (String)tag.getMinFractionDigits());
        ConvertNumberTagTest.assertEquals(null, (String)tag.getMinIntegerDigits());
        ConvertNumberTagTest.assertEquals(null, (String)tag.getPattern());
        ConvertNumberTagTest.assertEquals((String)"number", (String)tag.getType());
    }
}

