/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import javax.faces.render.Renderer;
import javax.faces.render.RendererTest;
import org.custommonkey.xmlunit.Diff;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockHtmlSelectOneMenu;
import org.seasar.teeda.core.mock.MockValueBinding;
import org.seasar.teeda.core.render.html.HtmlSelectOneMenuRenderer;
import org.seasar.teeda.core.util.PostbackUtil;

public class HtmlSelectOneMenuRendererTest
extends RendererTest {
    private HtmlSelectOneMenuRenderer renderer;
    private MockHtmlSelectOneMenu htmlSelectOneMenu;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlSelectOneMenuRenderer();
        this.htmlSelectOneMenu = new MockHtmlSelectOneMenu();
        this.htmlSelectOneMenu.setRenderer((Renderer)this.renderer);
        this.renderer.addIgnoreAttributeName("setSubmittedValueCalls");
    }

    public void testEncode_NoChild() throws Exception {
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneMenu);
        HtmlSelectOneMenuRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_RenderFalse() throws Exception {
        this.htmlSelectOneMenu.setRendered(false);
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectOneMenu.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneMenu);
        HtmlSelectOneMenuRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_Child() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v");
        selectItem.setItemLabel("l");
        this.htmlSelectOneMenu.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneMenu);
        HtmlSelectOneMenuRendererTest.assertEquals((String)"<select name=\"_id0\" size=\"1\"><option value=\"v\">l</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Id() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectOneMenu.getChildren().add(selectItem);
        this.htmlSelectOneMenu.setId("a");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneMenu);
        HtmlSelectOneMenuRendererTest.assertEquals((String)"<select id=\"a\" name=\"a\" size=\"1\"><option value=\"val\">lab</option></select>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute1() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectOneMenu.getChildren().add(selectItem);
        this.htmlSelectOneMenu.setId("a");
        this.htmlSelectOneMenu.getAttributes().put("aa", "11");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneMenu);
        HtmlSelectOneMenuRendererTest.assertEquals((String)"<select id=\"a\" name=\"a\" size=\"1\" aa=\"11\"><option value=\"val\">lab</option></select>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute2() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectOneMenu.getChildren().add(selectItem);
        this.htmlSelectOneMenu.setId("a");
        this.htmlSelectOneMenu.getAttributes().put("a.a", "11");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneMenu);
        HtmlSelectOneMenuRendererTest.assertEquals((String)"<select id=\"a\" name=\"a\" size=\"1\"><option value=\"val\">lab</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Children() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        this.htmlSelectOneMenu.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectOneMenu.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneMenu);
        HtmlSelectOneMenuRendererTest.assertEquals((String)"<select name=\"_id0\" size=\"1\"><option value=\"v1\">l1</option><option value=\"v2\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_SelectedIfPostbacked() throws Exception {
        PostbackUtil.setPostback((Map)this.getFacesContext().getExternalContext().getRequestMap(), (boolean)true);
        this.htmlSelectOneMenu.setValue("v2");
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        this.htmlSelectOneMenu.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectOneMenu.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneMenu);
        HtmlSelectOneMenuRendererTest.assertEquals((String)"<select name=\"_id0\" size=\"1\"><option value=\"v1\">l1</option><option value=\"v2\" selected=\"selected\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Selected_noValueBinding() throws Exception {
        PostbackUtil.setPostback((Map)this.getFacesContext().getExternalContext().getRequestMap(), (boolean)false);
        this.htmlSelectOneMenu.setValue("v2");
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        this.htmlSelectOneMenu.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectOneMenu.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneMenu);
        HtmlSelectOneMenuRendererTest.assertEquals((String)"<select name=\"_id0\" size=\"1\"><option value=\"v1\">l1</option><option value=\"v2\" selected=\"selected\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Selected_targetIsPrimitive() throws Exception {
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)new Integer(2));
        vb.setType(Integer.TYPE);
        PostbackUtil.setPostback((Map)this.getFacesContext().getExternalContext().getRequestMap(), (boolean)false);
        this.htmlSelectOneMenu.setValue("2");
        this.htmlSelectOneMenu.setValueBinding("value", (ValueBinding)vb);
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"1");
        selectItem.setItemLabel("l1");
        this.htmlSelectOneMenu.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"2");
        selectItem.setItemLabel("l2");
        this.htmlSelectOneMenu.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneMenu);
        HtmlSelectOneMenuRendererTest.assertEquals((String)"<select name=\"_id0\" size=\"1\"><option value=\"1\">l1</option><option value=\"2\" selected=\"selected\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Selected_targetIsPrimitiveZeroIgnored() throws Exception {
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)this.getFacesContext(), (Object)new Integer(0));
        vb.setType(Integer.TYPE);
        PostbackUtil.setPostback((Map)this.getFacesContext().getExternalContext().getRequestMap(), (boolean)false);
        this.htmlSelectOneMenu.setValue("0");
        this.htmlSelectOneMenu.setValueBinding("value", (ValueBinding)vb);
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"0");
        selectItem.setItemLabel("l1");
        this.htmlSelectOneMenu.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"1");
        selectItem.setItemLabel("l2");
        this.htmlSelectOneMenu.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneMenu);
        HtmlSelectOneMenuRendererTest.assertEquals((String)"<select name=\"_id0\" size=\"1\"><option value=\"0\">l1</option><option value=\"1\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_ItemDisabled() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        selectItem.setItemDisabled(true);
        this.htmlSelectOneMenu.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectOneMenu.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneMenu);
        HtmlSelectOneMenuRendererTest.assertEquals((String)"<select name=\"_id0\" size=\"1\"><option value=\"v1\" disabled=\"disabled\">l1</option><option value=\"v2\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Disabled() throws Exception {
        this.htmlSelectOneMenu.setDisabled(true);
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        selectItem.setItemDisabled(true);
        this.htmlSelectOneMenu.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectOneMenu.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneMenu);
        HtmlSelectOneMenuRendererTest.assertEquals((String)"<select name=\"_id0\" size=\"1\" disabled=\"disabled\"><option value=\"v1\" disabled=\"disabled\">l1</option><option value=\"v2\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_LabelClass() throws Exception {
        this.htmlSelectOneMenu.setEnabledClass("ec");
        this.htmlSelectOneMenu.setDisabledClass("dc");
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        this.htmlSelectOneMenu.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        selectItem.setItemDisabled(true);
        this.htmlSelectOneMenu.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneMenu);
        HtmlSelectOneMenuRendererTest.assertEquals((String)"<select name=\"_id0\" size=\"1\"><option value=\"v1\" class=\"ec\">l1</option><option value=\"v2\" class=\"dc\" disabled=\"disabled\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_GroupChildren() throws Exception {
        UISelectItems selectItems = new UISelectItems();
        SelectItem item1 = new SelectItem((Object)"v1", "l1");
        SelectItem item2 = new SelectItem((Object)"v2", "l2", null, true);
        selectItems.setValue((Object)new SelectItem[]{item1, item2});
        this.htmlSelectOneMenu.getChildren().add(selectItems);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneMenu);
        HtmlSelectOneMenuRendererTest.assertEquals((String)"<select name=\"_id0\" size=\"1\"><option value=\"v1\">l1</option><option value=\"v2\" disabled=\"disabled\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Optgroup() throws Exception {
        SelectItem item1 = new SelectItem((Object)"v1", "l1");
        SelectItem item2 = new SelectItem((Object)"v2", "l2", null, true);
        SelectItemGroup group = new SelectItemGroup("gl");
        group.setSelectItems(new SelectItem[]{item1, item2});
        UISelectItem selectItem = new UISelectItem();
        selectItem.setValue((Object)group);
        this.htmlSelectOneMenu.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneMenu);
        HtmlSelectOneMenuRendererTest.assertEquals((String)"<select name=\"_id0\" size=\"1\"><optgroup label=\"gl\"><option value=\"v1\">l1</option><option value=\"v2\" disabled=\"disabled\">l2</option></optgroup></select>", (String)this.getResponseText());
    }

    public void testEncode_WithAllAttributes() throws Exception {
        PostbackUtil.setPostback((Map)this.getFacesContext().getExternalContext().getRequestMap(), (boolean)true);
        this.htmlSelectOneMenu.setAccesskey("a");
        this.htmlSelectOneMenu.setDir("b");
        this.htmlSelectOneMenu.setDisabled(true);
        this.htmlSelectOneMenu.setDisabledClass("d");
        this.htmlSelectOneMenu.setEnabledClass("e");
        this.htmlSelectOneMenu.setLang("f");
        this.htmlSelectOneMenu.setOnblur("g");
        this.htmlSelectOneMenu.setOnchange("h");
        this.htmlSelectOneMenu.setOnclick("i");
        this.htmlSelectOneMenu.setOndblclick("j");
        this.htmlSelectOneMenu.setOnfocus("k");
        this.htmlSelectOneMenu.setOnkeydown("l");
        this.htmlSelectOneMenu.setOnkeypress("m");
        this.htmlSelectOneMenu.setOnkeyup("n");
        this.htmlSelectOneMenu.setOnmousedown("o");
        this.htmlSelectOneMenu.setOnmousemove("p");
        this.htmlSelectOneMenu.setOnmouseout("q");
        this.htmlSelectOneMenu.setOnmouseover("r");
        this.htmlSelectOneMenu.setOnmouseup("s");
        this.htmlSelectOneMenu.setOnselect("t");
        this.htmlSelectOneMenu.setReadonly(true);
        this.htmlSelectOneMenu.setStyle("w");
        this.htmlSelectOneMenu.setStyleClass("u");
        this.htmlSelectOneMenu.setTabindex("x");
        this.htmlSelectOneMenu.setTitle("y");
        this.htmlSelectOneMenu.getAttributes().put("name", "hoge");
        this.htmlSelectOneMenu.setId("A");
        this.htmlSelectOneMenu.setSubmittedValue("val");
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        selectItem.getAttributes().put("selected", "selected");
        this.htmlSelectOneMenu.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectOneMenu);
        Diff diff = new Diff("<select id=\"A\" name=\"A\" size=\"1\" style=\"w\" class=\"u\" accesskey=\"a\" dir=\"b\" disabled=\"disabled\" lang=\"f\" onblur=\"g\" onchange=\"h\" onclick=\"i\" ondblclick=\"j\" onfocus=\"k\" onkeydown=\"l\" onkeypress=\"m\" onkeyup=\"n\" onmousedown=\"o\" onmousemove=\"p\" onmouseout=\"q\" onmouseover=\"r\" onmouseup=\"s\" onselect=\"t\" readonly=\"readonly\" tabindex=\"x\" title=\"y\"><option value=\"val\" class=\"d\" selected=\"selected\">lab</option></select>", this.getResponseText());
        HtmlSelectOneMenuRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testDecode_RequestParameterNotExist() throws Exception {
        this.htmlSelectOneMenu.setClientId("key");
        MockFacesContext context = this.getFacesContext();
        this.renderer.decode((FacesContext)context, (UIComponent)this.htmlSelectOneMenu);
        HtmlSelectOneMenuRendererTest.assertEquals((int)0, (int)this.htmlSelectOneMenu.getSetSubmittedValueCalls());
        HtmlSelectOneMenuRendererTest.assertEquals(null, (Object)this.htmlSelectOneMenu.getSubmittedValue());
    }

    public void testDecodeSuccess() throws Exception {
        this.htmlSelectOneMenu.setClientId("keyA");
        MockFacesContext context = this.getFacesContext();
        MockHttpServletRequest mockHttpServletRequest = context.getMockExternalContext().getMockHttpServletRequest();
        mockHttpServletRequest.addParameter("keyA", new String[]{"a"});
        this.renderer.decode((FacesContext)context, (UIComponent)this.htmlSelectOneMenu);
        HtmlSelectOneMenuRendererTest.assertEquals((int)1, (int)this.htmlSelectOneMenu.getSetSubmittedValueCalls());
        HtmlSelectOneMenuRendererTest.assertEquals((Object)"a", (Object)this.htmlSelectOneMenu.getSubmittedValue());
    }

    public void testGetRendersChildren() throws Exception {
        HtmlSelectOneMenuRendererTest.assertEquals((boolean)false, (boolean)this.renderer.getRendersChildren());
    }

    private HtmlSelectOneMenuRenderer createHtmlSelectOneMenuRenderer() {
        return (HtmlSelectOneMenuRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlSelectOneMenuRenderer renderer = new HtmlSelectOneMenuRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }
}

