/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.util.ArrayList;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import javax.faces.render.Renderer;
import javax.faces.render.RendererTest;
import junitx.framework.ArrayAssert;
import org.custommonkey.xmlunit.Diff;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockHtmlSelectManyListbox;
import org.seasar.teeda.core.render.html.HtmlSelectManyListboxRenderer;

public class HtmlSelectManyListboxRendererTest
extends RendererTest {
    private HtmlSelectManyListboxRenderer renderer;
    private MockHtmlSelectManyListbox htmlSelectManyListbox;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlSelectManyListboxRenderer();
        this.htmlSelectManyListbox = new MockHtmlSelectManyListbox();
        this.htmlSelectManyListbox.setRenderer((Renderer)this.renderer);
        this.renderer.addIgnoreAttributeName("setSubmittedValueCalls");
    }

    public void testEncode_NoChild() throws Exception {
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyListbox);
        HtmlSelectManyListboxRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_RenderFalse() throws Exception {
        this.htmlSelectManyListbox.setRendered(false);
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectManyListbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyListbox);
        HtmlSelectManyListboxRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_Child() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v");
        selectItem.setItemLabel("l");
        this.htmlSelectManyListbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyListbox);
        HtmlSelectManyListboxRendererTest.assertEquals((String)"<select name=\"_id0\" multiple=\"multiple\" size=\"1\"><option value=\"v\">l</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Id() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectManyListbox.getChildren().add(selectItem);
        this.htmlSelectManyListbox.setId("a");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyListbox);
        HtmlSelectManyListboxRendererTest.assertEquals((String)"<select id=\"a\" name=\"a\" multiple=\"multiple\" size=\"1\"><option value=\"val\">lab</option></select>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute1() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectManyListbox.getChildren().add(selectItem);
        this.htmlSelectManyListbox.setId("a");
        this.htmlSelectManyListbox.getAttributes().put("zz", "y");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyListbox);
        HtmlSelectManyListboxRendererTest.assertEquals((String)"<select id=\"a\" name=\"a\" multiple=\"multiple\" size=\"1\" zz=\"y\"><option value=\"val\">lab</option></select>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute2() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        this.htmlSelectManyListbox.getChildren().add(selectItem);
        this.htmlSelectManyListbox.setId("a");
        this.htmlSelectManyListbox.getAttributes().put("z.z", "y");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyListbox);
        HtmlSelectManyListboxRendererTest.assertEquals((String)"<select id=\"a\" name=\"a\" multiple=\"multiple\" size=\"1\"><option value=\"val\">lab</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Children() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        this.htmlSelectManyListbox.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectManyListbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyListbox);
        HtmlSelectManyListboxRendererTest.assertEquals((String)"<select name=\"_id0\" multiple=\"multiple\" size=\"2\"><option value=\"v1\">l1</option><option value=\"v2\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Size() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        this.htmlSelectManyListbox.getChildren().add(selectItem);
        this.htmlSelectManyListbox.setSize(6);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyListbox);
        HtmlSelectManyListboxRendererTest.assertEquals((String)"<select name=\"_id0\" multiple=\"multiple\" size=\"6\"><option value=\"v1\">l1</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Selected() throws Exception {
        this.htmlSelectManyListbox.setSelectedValues(new String[]{"v2"});
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        this.htmlSelectManyListbox.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectManyListbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyListbox);
        HtmlSelectManyListboxRendererTest.assertEquals((String)"<select name=\"_id0\" multiple=\"multiple\" size=\"2\"><option value=\"v1\">l1</option><option value=\"v2\" selected=\"selected\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_ItemDisabled() throws Exception {
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        selectItem.setItemDisabled(true);
        this.htmlSelectManyListbox.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectManyListbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyListbox);
        HtmlSelectManyListboxRendererTest.assertEquals((String)"<select name=\"_id0\" multiple=\"multiple\" size=\"2\"><option value=\"v1\" disabled=\"disabled\">l1</option><option value=\"v2\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Disabled() throws Exception {
        this.htmlSelectManyListbox.setDisabled(true);
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        selectItem.setItemDisabled(true);
        this.htmlSelectManyListbox.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        this.htmlSelectManyListbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyListbox);
        HtmlSelectManyListboxRendererTest.assertEquals((String)"<select name=\"_id0\" multiple=\"multiple\" size=\"2\" disabled=\"disabled\"><option value=\"v1\" disabled=\"disabled\">l1</option><option value=\"v2\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_LabelClass() throws Exception {
        this.htmlSelectManyListbox.setEnabledClass("ec");
        this.htmlSelectManyListbox.setDisabledClass("dc");
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v1");
        selectItem.setItemLabel("l1");
        this.htmlSelectManyListbox.getChildren().add(selectItem);
        selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"v2");
        selectItem.setItemLabel("l2");
        selectItem.setItemDisabled(true);
        this.htmlSelectManyListbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyListbox);
        HtmlSelectManyListboxRendererTest.assertEquals((String)"<select name=\"_id0\" multiple=\"multiple\" size=\"2\"><option value=\"v1\" class=\"ec\">l1</option><option value=\"v2\" class=\"dc\" disabled=\"disabled\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_GroupChildren() throws Exception {
        UISelectItems selectItems = new UISelectItems();
        SelectItem item1 = new SelectItem((Object)"v1", "l1");
        SelectItem item2 = new SelectItem((Object)"v2", "l2", null, true);
        selectItems.setValue((Object)new SelectItem[]{item1, item2});
        this.htmlSelectManyListbox.getChildren().add(selectItems);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyListbox);
        HtmlSelectManyListboxRendererTest.assertEquals((String)"<select name=\"_id0\" multiple=\"multiple\" size=\"2\"><option value=\"v1\">l1</option><option value=\"v2\" disabled=\"disabled\">l2</option></select>", (String)this.getResponseText());
    }

    public void testEncode_Optgroup() throws Exception {
        SelectItem item1 = new SelectItem((Object)"v1", "l1");
        SelectItem item2 = new SelectItem((Object)"v2", "l2", null, true);
        SelectItemGroup group = new SelectItemGroup("gl");
        group.setSelectItems(new SelectItem[]{item1, item2});
        UISelectItem selectItem = new UISelectItem();
        selectItem.setValue((Object)group);
        this.htmlSelectManyListbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyListbox);
        HtmlSelectManyListboxRendererTest.assertEquals((String)"<select name=\"_id0\" multiple=\"multiple\" size=\"3\"><optgroup label=\"gl\"><option value=\"v1\">l1</option><option value=\"v2\" disabled=\"disabled\">l2</option></optgroup></select>", (String)this.getResponseText());
    }

    public void testEncode_WithAllAttributes() throws Exception {
        this.htmlSelectManyListbox.setAccesskey("a");
        this.htmlSelectManyListbox.setDir("b");
        this.htmlSelectManyListbox.setDisabled(true);
        this.htmlSelectManyListbox.setDisabledClass("d");
        this.htmlSelectManyListbox.setEnabledClass("e");
        this.htmlSelectManyListbox.setLang("f");
        this.htmlSelectManyListbox.setOnblur("g");
        this.htmlSelectManyListbox.setOnchange("h");
        this.htmlSelectManyListbox.setOnclick("i");
        this.htmlSelectManyListbox.setOndblclick("j");
        this.htmlSelectManyListbox.setOnfocus("k");
        this.htmlSelectManyListbox.setOnkeydown("l");
        this.htmlSelectManyListbox.setOnkeypress("m");
        this.htmlSelectManyListbox.setOnkeyup("n");
        this.htmlSelectManyListbox.setOnmousedown("o");
        this.htmlSelectManyListbox.setOnmousemove("p");
        this.htmlSelectManyListbox.setOnmouseout("q");
        this.htmlSelectManyListbox.setOnmouseover("r");
        this.htmlSelectManyListbox.setOnmouseup("s");
        this.htmlSelectManyListbox.setOnselect("t");
        this.htmlSelectManyListbox.setReadonly(true);
        this.htmlSelectManyListbox.setSize(4);
        this.htmlSelectManyListbox.setStyle("w");
        this.htmlSelectManyListbox.setStyleClass("u");
        this.htmlSelectManyListbox.setTabindex("x");
        this.htmlSelectManyListbox.setTitle("y");
        this.htmlSelectManyListbox.getAttributes().put("name", "hoge");
        this.htmlSelectManyListbox.setId("A");
        this.htmlSelectManyListbox.setValue(new String[]{"val"});
        UISelectItem selectItem = new UISelectItem();
        selectItem.setItemValue((Object)"val");
        selectItem.setItemLabel("lab");
        selectItem.getAttributes().put("selected", "selected");
        this.htmlSelectManyListbox.getChildren().add(selectItem);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyListbox);
        Diff diff = new Diff("<select id=\"A\" name=\"A\" multiple=\"multiple\" size=\"4\" style=\"w\" class=\"u\" accesskey=\"a\" dir=\"b\" disabled=\"disabled\" lang=\"f\" onblur=\"g\" onchange=\"h\" onclick=\"i\" ondblclick=\"j\" onfocus=\"k\" onkeydown=\"l\" onkeypress=\"m\" onkeyup=\"n\" onmousedown=\"o\" onmousemove=\"p\" onmouseout=\"q\" onmouseover=\"r\" onmouseup=\"s\" onselect=\"t\" readonly=\"readonly\" tabindex=\"x\" title=\"y\"><option value=\"val\" class=\"d\" selected=\"selected\">lab</option></select>", this.getResponseText());
        HtmlSelectManyListboxRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testDecode_RequestParameterNotExist() throws Exception {
        this.htmlSelectManyListbox.setClientId("key");
        MockFacesContext context = this.getFacesContext();
        this.renderer.decode((FacesContext)context, (UIComponent)this.htmlSelectManyListbox);
        HtmlSelectManyListboxRendererTest.assertEquals((int)1, (int)this.htmlSelectManyListbox.getSetSubmittedValueCalls());
        String[] submittedValue = (String[])this.htmlSelectManyListbox.getSubmittedValue();
        HtmlSelectManyListboxRendererTest.assertEquals((int)0, (int)submittedValue.length);
    }

    public void testDecodeSuccess() throws Exception {
        this.htmlSelectManyListbox.setClientId("keyA");
        MockFacesContext context = this.getFacesContext();
        context.getExternalContext().getRequestParameterValuesMap().put("keyA", new String[]{"a", "b", "c"});
        this.renderer.decode((FacesContext)context, (UIComponent)this.htmlSelectManyListbox);
        HtmlSelectManyListboxRendererTest.assertEquals((int)1, (int)this.htmlSelectManyListbox.getSetSubmittedValueCalls());
        ArrayAssert.assertEquivalenceArrays((Object[])new String[]{"a", "b", "c"}, (Object[])((Object[])this.htmlSelectManyListbox.getSubmittedValue()));
    }

    public void testGetRendersChildren() throws Exception {
        HtmlSelectManyListboxRendererTest.assertEquals((boolean)false, (boolean)this.renderer.getRendersChildren());
    }

    public void testSelectItemValueIsNull() throws Exception {
        this.htmlSelectManyListbox.setRendered(true);
        UISelectItems selectItems = new UISelectItems();
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        SelectItem selectItem = new SelectItem();
        selectItem.setLabel("aaa");
        list.add(selectItem);
        selectItems.setValue(list);
        this.htmlSelectManyListbox.getChildren().add(selectItems);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlSelectManyListbox);
        HtmlSelectManyListboxRendererTest.assertEquals((String)"<select name=\"_id0\" multiple=\"multiple\" size=\"1\"><option>aaa</option></select>", (String)this.getResponseText());
    }

    private HtmlSelectManyListboxRenderer createHtmlSelectManyListboxRenderer() {
        return (HtmlSelectManyListboxRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlSelectManyListboxRenderer renderer = new HtmlSelectManyListboxRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }
}

