/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import javax.faces.render.RendererTest;
import org.custommonkey.xmlunit.Diff;
import org.seasar.teeda.core.mock.MockHtmlOutputText;
import org.seasar.teeda.core.mock.MockHtmlPanelGroup;
import org.seasar.teeda.core.render.html.HtmlOutputTextRenderer;
import org.seasar.teeda.core.render.html.HtmlPanelGroupRenderer;

public class HtmlPanelGroupRendererTest
extends RendererTest {
    private HtmlPanelGroupRenderer renderer;
    private MockHtmlPanelGroup htmlPanelGroup;
    private HtmlOutputTextRenderer textRenderer;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlPanelGroupRenderer();
        this.textRenderer = new HtmlOutputTextRenderer();
        this.htmlPanelGroup = new MockHtmlPanelGroup();
        this.htmlPanelGroup.setRenderer((Renderer)this.renderer);
    }

    public void testEncode_NoChild() throws Exception {
        this.renderer.encodeBegin((FacesContext)this.getFacesContext(), (UIComponent)this.htmlPanelGroup);
        HtmlPanelGroupRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_Child() throws Exception {
        MockHtmlOutputText child = new MockHtmlOutputText();
        child.setValue("a");
        child.setRenderer((Renderer)this.textRenderer);
        this.htmlPanelGroup.getChildren().add(child);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlPanelGroup);
        HtmlPanelGroupRendererTest.assertEquals((String)"a", (String)this.getResponseText());
    }

    public void testEncode_Children() throws Exception {
        MockHtmlOutputText child = new MockHtmlOutputText();
        child.setValue("a");
        child.setRenderer((Renderer)this.textRenderer);
        this.htmlPanelGroup.getChildren().add(child);
        child = new MockHtmlOutputText();
        child.setValue("b");
        child.setRenderer((Renderer)this.textRenderer);
        this.htmlPanelGroup.getChildren().add(child);
        child = new MockHtmlOutputText();
        child.setValue("c");
        child.setRenderer((Renderer)this.textRenderer);
        this.htmlPanelGroup.getChildren().add(child);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlPanelGroup);
        HtmlPanelGroupRendererTest.assertEquals((String)"abc", (String)this.getResponseText());
    }

    public void testEncode_NestedChildren() throws Exception {
        MockHtmlOutputText child = new MockHtmlOutputText();
        child.setValue("a");
        child.setRenderer((Renderer)this.textRenderer);
        this.htmlPanelGroup.getChildren().add(child);
        MockHtmlPanelGroup childGroup = new MockHtmlPanelGroup();
        childGroup.setRenderer((Renderer)this.renderer);
        MockHtmlOutputText child2 = new MockHtmlOutputText();
        child2.setValue("b");
        child2.setRenderer((Renderer)this.textRenderer);
        childGroup.getChildren().add(child2);
        child2 = new MockHtmlOutputText();
        child2.setValue("c");
        child2.setRenderer((Renderer)this.textRenderer);
        childGroup.getChildren().add(child2);
        this.htmlPanelGroup.getChildren().add(childGroup);
        child = new MockHtmlOutputText();
        child.setValue("d");
        child.setRenderer((Renderer)this.textRenderer);
        this.htmlPanelGroup.getChildren().add(child);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlPanelGroup);
        HtmlPanelGroupRendererTest.assertEquals((String)"abcd", (String)this.getResponseText());
    }

    public void testEncode_RenderFalse() throws Exception {
        this.htmlPanelGroup.setRendered(false);
        this.htmlPanelGroup.setId("a");
        HtmlOutputTextRenderer textRenderer = new HtmlOutputTextRenderer();
        MockHtmlOutputText child = new MockHtmlOutputText();
        child.setValue("v");
        child.setRenderer((Renderer)textRenderer);
        this.htmlPanelGroup.getChildren().add(child);
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlPanelGroup);
        HtmlPanelGroupRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_Id() throws Exception {
        this.htmlPanelGroup.setId("aaa");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlPanelGroup);
        HtmlPanelGroupRendererTest.assertEquals((String)"<span id=\"aaa\"></span>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute1() throws Exception {
        this.htmlPanelGroup.getAttributes().put("a", "b");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlPanelGroup);
        HtmlPanelGroupRendererTest.assertEquals((String)"<span a=\"b\"></span>", (String)this.getResponseText());
    }

    public void testEncode_WithUnknownAttribute2() throws Exception {
        this.htmlPanelGroup.getAttributes().put("a.c", "b");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlPanelGroup);
        HtmlPanelGroupRendererTest.assertEquals((String)"", (String)this.getResponseText());
    }

    public void testEncode_Style() throws Exception {
        this.htmlPanelGroup.setStyle("a");
        this.htmlPanelGroup.setStyleClass("b");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlPanelGroup);
        Diff diff = new Diff("<span style=\"a\" class=\"b\"></span>", this.getResponseText());
        HtmlPanelGroupRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testEncode_WithAllAttributes() throws Exception {
        this.htmlPanelGroup.setId("a");
        this.htmlPanelGroup.setStyle("b");
        this.htmlPanelGroup.setStyleClass("c");
        this.encodeByRenderer((Renderer)this.renderer, (UIComponent)this.htmlPanelGroup);
        Diff diff = new Diff("<span id=\"a\" style=\"b\" class=\"c\"></span>", this.getResponseText());
        HtmlPanelGroupRendererTest.assertEquals((String)diff.toString(), (boolean)true, (boolean)diff.identical());
    }

    public void testGetRendersChildren() throws Exception {
        HtmlPanelGroupRendererTest.assertEquals((boolean)true, (boolean)this.renderer.getRendersChildren());
    }

    private HtmlPanelGroupRenderer createHtmlPanelGroupRenderer() {
        return (HtmlPanelGroupRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlPanelGroupRenderer renderer = new HtmlPanelGroupRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }
}

