/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.render.AbstractRendererTeedaTest;
import javax.faces.render.Renderer;
import org.seasar.framework.container.S2Container;
import org.seasar.teeda.core.el.ELParser;
import org.seasar.teeda.core.el.ExpressionProcessor;
import org.seasar.teeda.core.el.impl.ValueBindingImpl;
import org.seasar.teeda.core.el.impl.commons.CommonsELParser;
import org.seasar.teeda.core.el.impl.commons.CommonsExpressionProcessorImpl;
import org.seasar.teeda.core.mock.MockFacesContext;
import org.seasar.teeda.core.mock.MockHtmlInputText;
import org.seasar.teeda.core.mock.MockUIViewRoot;
import org.seasar.teeda.core.render.html.HtmlInputTextRenderer;

public class HtmlInputTextRendererTeedaTest
extends AbstractRendererTeedaTest {
    private S2Container container;
    private HtmlInputTextRenderer renderer;
    private MockHtmlInputText htmlInputText;

    protected void setUp() throws Exception {
        super.setUp();
        this.renderer = this.createHtmlInputTextRenderer();
        this.htmlInputText = new MockHtmlInputText();
        this.htmlInputText.setRenderer((Renderer)this.renderer);
    }

    public void testEncode() throws Exception {
        this.htmlInputText.setId("a");
        Foo foo = new Foo();
        foo.setAaa("b");
        this.container.register((Object)foo, "foo");
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        ValueBindingImpl vb = new ValueBindingImpl(this.getFacesContext().getApplication(), "#{foo.aaa}", (ELParser)parser);
        this.htmlInputText.setValueBinding("value", (ValueBinding)vb);
        MockFacesContext context = this.getFacesContext();
        this.encodeComponent((FacesContext)context, (UIComponent)this.htmlInputText);
        HtmlInputTextRendererTeedaTest.assertEquals((String)"<input type=\"text\" id=\"a\" name=\"a\" value=\"b\" />", (String)this.getResponseText());
    }

    public void testDecode() throws Exception {
        MockUIViewRoot mockUIViewRoot = new MockUIViewRoot();
        mockUIViewRoot.getChildren().add(this.htmlInputText);
        this.htmlInputText.setId("a");
        Foo foo = new Foo();
        this.container.register((Object)foo, "foo");
        MockFacesContext context = this.getFacesContext();
        context.getExternalContext().getRequestParameterMap().put("a", "12345");
        CommonsELParser parser = new CommonsELParser();
        parser.setExpressionProcessor((ExpressionProcessor)new CommonsExpressionProcessorImpl());
        ValueBindingImpl vb = new ValueBindingImpl(this.getFacesContext().getApplication(), "#{foo.aaa}", (ELParser)parser);
        this.htmlInputText.setValueBinding("value", (ValueBinding)vb);
        this.htmlInputText.decode((FacesContext)context);
        HtmlInputTextRendererTeedaTest.assertEquals((Object)"12345", (Object)this.htmlInputText.getSubmittedValue());
        this.htmlInputText.processValidators((FacesContext)context);
        this.htmlInputText.processUpdates((FacesContext)context);
        HtmlInputTextRendererTeedaTest.assertEquals(null, (Object)this.htmlInputText.getSubmittedValue());
        HtmlInputTextRendererTeedaTest.assertEquals((String)"12345", (String)foo.getAaa());
    }

    private HtmlInputTextRenderer createHtmlInputTextRenderer() {
        return (HtmlInputTextRenderer)this.createRenderer();
    }

    protected Renderer createRenderer() {
        HtmlInputTextRenderer renderer = new HtmlInputTextRenderer();
        renderer.setComponentIdLookupStrategy(this.getComponentIdLookupStrategy());
        return renderer;
    }

    public static class Foo {
        private String aaa;

        public String getAaa() {
            return this.aaa;
        }

        public void setAaa(String aaa) {
            this.aaa = aaa;
        }
    }
}

