/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.el.impl.commons;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.VariableResolver;
import junit.textui.TestRunner;
import org.apache.commons.el.parser.ELParser;
import org.seasar.teeda.core.el.impl.commons.CommonsExpressionProcessorImpl;
import org.seasar.teeda.core.mock.MockApplication;
import org.seasar.teeda.core.mock.MockUIComponent;
import org.seasar.teeda.core.mock.MockVariableResolver;
import org.seasar.teeda.core.unit.TeedaTestCase;

public class CommonsExpressionProcessorImplTest
extends TeedaTestCase {
    public static void main(String[] args) {
        TestRunner.run((Class)CommonsExpressionProcessorImplTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public CommonsExpressionProcessorImplTest(String arg0) {
        super(arg0);
    }

    public void testProcessExpression() {
        CommonsExpressionProcessorImpl processor = new CommonsExpressionProcessorImpl();
        ELParser parser = new ELParser((Reader)new StringReader("${a.b}"));
        try {
            Object obj = parser.ExpressionString();
            processor.processExpression(obj, Object.class);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            processor.processExpression(new Object(), Object.class);
            CommonsExpressionProcessorImplTest.fail();
        }
        catch (IllegalStateException e) {
            CommonsExpressionProcessorImplTest.success();
        }
    }

    public void testEvaluate() {
        CommonsExpressionProcessorImpl processor = new CommonsExpressionProcessorImpl();
        ELParser parser = new ELParser((Reader)new StringReader("${a}"));
        Object expression = null;
        try {
            expression = parser.ExpressionString();
            processor.processExpression(expression, Object.class);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        MockVariableResolver resolver = this.getVariableResolver();
        A a = new A();
        resolver.putValue("a", (Object)a);
        Object o = processor.evaluate((FacesContext)this.getFacesContext(), expression);
        CommonsExpressionProcessorImplTest.assertSame((Object)a, (Object)o);
    }

    public void testEvaluate2() {
        CommonsExpressionProcessorImpl processor = new CommonsExpressionProcessorImpl();
        ELParser parser = new ELParser((Reader)new StringReader("b${a}"));
        Object expression = null;
        try {
            expression = parser.ExpressionString();
            processor.processExpression(expression, Object.class);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        MockVariableResolver resolver = this.getVariableResolver();
        resolver.putValue("a", (Object)"A");
        MockApplication app = this.getApplication();
        app.setVariableResolver((VariableResolver)resolver);
        Object o = processor.evaluate((FacesContext)this.getFacesContext(), expression);
        CommonsExpressionProcessorImplTest.assertEquals((Object)"bA", (Object)o);
    }

    public void testToIndex() {
        ArrayList previous = new ArrayList();
        CommonsExpressionProcessorImpl processor = new CommonsExpressionProcessorImpl();
        Integer indexValue = processor.toIndex(previous, (Object)"1");
        CommonsExpressionProcessorImplTest.assertEquals((Object)new Integer(1), (Object)indexValue);
        indexValue = processor.toIndex((Object)new String[]{"2"}, (Object)"2");
        CommonsExpressionProcessorImplTest.assertEquals((Object)new Integer(2), (Object)indexValue);
        try {
            indexValue = processor.toIndex(previous, (Object)List.class);
            CommonsExpressionProcessorImplTest.fail();
        }
        catch (ReferenceSyntaxException expected) {
            CommonsExpressionProcessorImplTest.success();
        }
        indexValue = processor.toIndex((Object)new MockUIComponent(), (Object)"3");
        CommonsExpressionProcessorImplTest.assertEquals((Object)new Integer(3), (Object)indexValue);
    }

    public void testResolveBase1() {
        CommonsExpressionProcessorImpl processor = new CommonsExpressionProcessorImpl();
        ELParser parser = new ELParser((Reader)new StringReader("${a}"));
        Object expression = null;
        try {
            expression = parser.ExpressionString();
            processor.processExpression(expression, Object.class);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        Object o = processor.resolveBase((FacesContext)this.getFacesContext(), expression);
        CommonsExpressionProcessorImplTest.assertNotNull((Object)o);
        CommonsExpressionProcessorImplTest.assertTrue((boolean)(o instanceof String));
        CommonsExpressionProcessorImplTest.assertEquals((String)"a", (String)((String)o));
    }

    public void testResolveBase2() {
        CommonsExpressionProcessorImpl processor = new CommonsExpressionProcessorImpl();
        ELParser parser = new ELParser((Reader)new StringReader("${a.name}"));
        Object expression = null;
        try {
            expression = parser.ExpressionString();
            processor.processExpression(expression, Object.class);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        MockVariableResolver resolver = this.getVariableResolver();
        A a = new A();
        resolver.putValue("a", (Object)a);
        Object o = processor.resolveBase((FacesContext)this.getFacesContext(), expression);
        CommonsExpressionProcessorImplTest.assertNotNull((Object)o);
        CommonsExpressionProcessorImplTest.assertTrue((boolean)(o instanceof Object[]));
        Object[] objs = (Object[])o;
        CommonsExpressionProcessorImplTest.assertSame((Object)a, (Object)objs[0]);
        CommonsExpressionProcessorImplTest.assertEquals((Object)"name", (Object)objs[1]);
    }

    public void testGetCoercedObject() {
        CommonsExpressionProcessorImpl processor = new CommonsExpressionProcessorImpl();
        ArrayList<String> list = new ArrayList<String>();
        list.add("a");
        Object o = processor.getCoercedObject(list, List.class);
        CommonsExpressionProcessorImplTest.assertNotNull((Object)o);
        CommonsExpressionProcessorImplTest.assertTrue((boolean)(o instanceof List));
        List l = (List)o;
        CommonsExpressionProcessorImplTest.assertEquals((Object)"a", l.get(0));
    }

    public static class A {
        private String name_ = "aaa";

        public String getName() {
            return this.name_;
        }
    }
}

