/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.impl;

import java.util.Locale;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContextFactory;
import javax.faces.internal.FacesConfigOptions;
import javax.faces.internal.FactoryFinderUtil;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKitFactory;
import junitx.framework.ObjectAssert;
import org.seasar.extension.unit.S2TestCase;
import org.seasar.teeda.core.config.faces.assembler.AssembleProvider;
import org.seasar.teeda.core.config.faces.assembler.AssemblerAssembler;
import org.seasar.teeda.core.config.faces.assembler.impl.DefaultAssembleProvider;
import org.seasar.teeda.core.config.faces.element.FacesConfig;
import org.seasar.teeda.core.config.faces.impl.ConfigFilesFacesConfigurator;
import org.seasar.teeda.core.mock.MockActionListener;
import org.seasar.teeda.core.mock.MockApplication;
import org.seasar.teeda.core.mock.MockApplicationFactory;
import org.seasar.teeda.core.mock.MockFacesContextFactory;
import org.seasar.teeda.core.mock.MockLifecycleFactory;
import org.seasar.teeda.core.mock.MockNavigationHandler;
import org.seasar.teeda.core.mock.MockPropertyResolver;
import org.seasar.teeda.core.mock.MockRenderKitFactory;
import org.seasar.teeda.core.mock.MockStateManager;
import org.seasar.teeda.core.mock.MockVariableResolver;
import org.seasar.teeda.core.mock.MockViewHandlerImpl;

public class ConfigFilesFacesConfiguratorTest
extends S2TestCase {
    public ConfigFilesFacesConfiguratorTest(String name) {
        super(name);
    }

    protected void tearDown() {
        FacesConfigOptions.clear();
    }

    public void testConfigure1() throws Exception {
        String path1 = ((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/') + "/ConfigFilesFacesConfiguratorTest-testConfigure1_1.xml";
        String path2 = ((Object)((Object)this)).getClass().getPackage().getName().replace('.', '/') + "/ConfigFilesFacesConfiguratorTest-testConfigure1_2.xml";
        FacesConfigOptions.setConfigFiles((String)(path1 + ", " + path2));
        ConfigFilesFacesConfigurator configurator = new ConfigFilesFacesConfigurator();
        FacesConfig facesConfig = configurator.configure();
        ConfigFilesFacesConfiguratorTest.assertNotNull((Object)facesConfig);
        AssemblerAssembler assembler = new AssemblerAssembler();
        DefaultAssembleProvider provider = new DefaultAssembleProvider();
        assembler.setAssembleProvider((AssembleProvider)provider);
        assembler.assembleFactories(facesConfig);
        ApplicationFactory appFactory = FactoryFinderUtil.getApplicationFactory();
        ObjectAssert.assertInstanceOf((Class)MockApplicationFactory.class, (Object)appFactory);
        LifecycleFactory lifecycleFactory = FactoryFinderUtil.getLifecycleFactory();
        ObjectAssert.assertInstanceOf((Class)MockLifecycleFactory.class, (Object)lifecycleFactory);
        FacesContextFactory contextFactory = FactoryFinderUtil.getFacesContextFactory();
        ObjectAssert.assertInstanceOf((Class)MockFacesContextFactory.class, (Object)contextFactory);
        RenderKitFactory renderKitFactory = FactoryFinderUtil.getRenderKitFactory();
        ObjectAssert.assertInstanceOf((Class)MockRenderKitFactory.class, (Object)renderKitFactory);
        assembler.assembleApplication(facesConfig);
        Application app = appFactory.getApplication();
        ConfigFilesFacesConfiguratorTest.assertNotNull((Object)app);
        ObjectAssert.assertInstanceOf((Class)MockApplication.class, (Object)app);
        ObjectAssert.assertInstanceOf((Class)MockActionListener.class, (Object)app.getActionListener());
        ObjectAssert.assertInstanceOf((Class)MockStateManager.class, (Object)app.getStateManager());
        ObjectAssert.assertInstanceOf((Class)MockNavigationHandler.class, (Object)app.getNavigationHandler());
        ObjectAssert.assertInstanceOf((Class)MockPropertyResolver.class, (Object)app.getPropertyResolver());
        ObjectAssert.assertInstanceOf((Class)MockVariableResolver.class, (Object)app.getVariableResolver());
        ObjectAssert.assertInstanceOf((Class)MockViewHandlerImpl.class, (Object)app.getViewHandler());
        ConfigFilesFacesConfiguratorTest.assertEquals((Object)Locale.JAPANESE, (Object)app.getDefaultLocale());
        ConfigFilesFacesConfiguratorTest.assertEquals((Object)Locale.ENGLISH, app.getSupportedLocales().next());
        ConfigFilesFacesConfiguratorTest.assertEquals((String)"hoge", (String)app.getDefaultRenderKitId());
        ConfigFilesFacesConfiguratorTest.assertEquals((String)"message", (String)app.getMessageBundle());
    }
}

