/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.Serializable;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.FacesEvent;
import junit.framework.TestCase;
import junitx.framework.StringAssert;
import org.seasar.teeda.core.mock.MockValueBinding;
import org.seasar.teeda.core.mock.NullFacesContext;
import org.seasar.teeda.core.mock.NullFacesEvent;
import org.seasar.teeda.core.mock.NullValueBinding;
import org.seasar.teeda.core.unit.ExceptionAssert;

public abstract class AbstractUIComponentTest
extends TestCase {
    public final void testGetValueBinding_NullArg() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.getValueBinding(null);
            AbstractUIComponentTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public final void testSetValueBinding_NullArg() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.setValueBinding(null, (ValueBinding)new NullValueBinding());
            AbstractUIComponentTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public final void testSetValueBinding_IllegalArgName1() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.setValueBinding("id", (ValueBinding)new NullValueBinding());
        }
        catch (IllegalArgumentException iae) {
            ExceptionAssert.assertMessageExist(iae);
        }
    }

    public final void testSetValueBinding_IllegalArgName2() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.setValueBinding("parent", (ValueBinding)new NullValueBinding());
        }
        catch (IllegalArgumentException iae) {
            ExceptionAssert.assertMessageExist(iae);
        }
    }

    public final void testGetClientId_NullArg() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.getClientId(null);
            AbstractUIComponentTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public final void testSetIdNull() throws Exception {
        UIComponent component = this.createUIComponent();
        component.setId(null);
        AbstractUIComponentTest.assertTrue((boolean)true);
    }

    public final void testSetId_IllegalArg1() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.setId("");
            AbstractUIComponentTest.fail();
        }
        catch (IllegalArgumentException iae) {
            ExceptionAssert.assertMessageExist(iae);
        }
    }

    public final void testSetId_IllegalArg2() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.setId("1");
            AbstractUIComponentTest.fail();
        }
        catch (IllegalArgumentException iae) {
            ExceptionAssert.assertMessageExist(iae);
        }
    }

    public final void testSetId_IllegalArg3() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.setId("a:");
            AbstractUIComponentTest.fail();
        }
        catch (IllegalArgumentException iae) {
            ExceptionAssert.assertMessageExist(iae);
        }
    }

    public final void testFindComponent_NullArg() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.findComponent(null);
            AbstractUIComponentTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public final void todo_testFindComponent_IllegalArgs() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.findComponent("");
            AbstractUIComponentTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public void testAddChildNoUIComponent() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.getChildren().add(new Integer("123"));
            AbstractUIComponentTest.fail();
        }
        catch (ClassCastException e) {
            String message = e.getMessage();
            StringAssert.assertContains((String)message, (String)Integer.class.getName());
        }
    }

    public final void testBroadcast_NullArg() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.broadcast(null);
            AbstractUIComponentTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public final void testDecode_NullArg() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.decode(null);
            AbstractUIComponentTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public final void testEncodeBegin_NullArg() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.encodeBegin(null);
            AbstractUIComponentTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public final void testEncodeChildren_NullArg() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.encodeChildren(null);
            AbstractUIComponentTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public final void testEncodeEnd_NullArg() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.encodeEnd(null);
            AbstractUIComponentTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public final void testAddFacesListener_NullArg() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.addFacesListener(null);
            AbstractUIComponentTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public final void testGetFacesListeners_NullArg() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.getFacesListeners(null);
            AbstractUIComponentTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public final void testGetFacesListeners_IllegalArg() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.getFacesListeners(String.class);
            AbstractUIComponentTest.fail();
        }
        catch (IllegalArgumentException iae) {
            ExceptionAssert.assertMessageExist(iae);
        }
    }

    public final void testRemoveFacesListener_NullArg() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.removeFacesListener(null);
            AbstractUIComponentTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public final void testQueueEvent_NullArg() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.queueEvent(null);
            AbstractUIComponentTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public final void testQueueEvent_NoParent() throws Exception {
        UIComponent component = this.createUIComponent();
        if (component instanceof UIViewRoot) {
            component.queueEvent((FacesEvent)new NullFacesEvent());
        } else {
            try {
                component.queueEvent((FacesEvent)new NullFacesEvent());
                AbstractUIComponentTest.fail();
            }
            catch (IllegalStateException ise) {
                ExceptionAssert.assertMessageExist(ise);
            }
        }
    }

    public final void testProcessRestoreState_NullArg() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.processRestoreState(null, new Object());
            AbstractUIComponentTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public final void testProcessDecodes_NullArg() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.processDecodes(null);
            AbstractUIComponentTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public final void testProcessValidators_NullArg() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.processValidators(null);
            AbstractUIComponentTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public final void testProcessUpdates_NullArg() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.processUpdates(null);
            AbstractUIComponentTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public final void testProcessSaveState_NullArg() throws Exception {
        UIComponent component = this.createUIComponent();
        try {
            component.processSaveState(null);
            AbstractUIComponentTest.fail();
        }
        catch (NullPointerException npe) {
            ExceptionAssert.assertMessageExist(npe);
        }
    }

    public final void testGetAttributes_ShouldBeSerializable() throws Exception {
        UIComponent component = this.createUIComponent();
        Map attributes = component.getAttributes();
        AbstractUIComponentTest.assertEquals((boolean)true, (boolean)(attributes instanceof Serializable));
    }

    public final void testGetAttributes() throws Exception {
        UIComponent component = this.createUIComponent();
        Map attributes = component.getAttributes();
        attributes.put("id", "hoge");
        AbstractUIComponentTest.assertEquals((String)"hoge", (String)component.getId());
        component.setId("bar");
        AbstractUIComponentTest.assertEquals((Object)"bar", attributes.get("id"));
    }

    public final void testSetGetTransient() throws Exception {
        UIComponent component = this.createUIComponent();
        AbstractUIComponentTest.assertEquals((boolean)false, (boolean)component.isTransient());
        component.setTransient(true);
        AbstractUIComponentTest.assertEquals((boolean)true, (boolean)component.isTransient());
    }

    public final void testSetGetTransient_ValueBindingNotWork() throws Exception {
        UIComponent component = this.createUIComponent();
        MockValueBinding vb = new MockValueBinding();
        vb.setValue((FacesContext)new NullFacesContext(), (Object)Boolean.TRUE);
        component.setValueBinding("transient", (ValueBinding)vb);
        AbstractUIComponentTest.assertEquals((String)"[transient] property don't need ValueBinding", (boolean)false, (boolean)component.isTransient());
    }

    protected abstract UIComponent createUIComponent();
}

