/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.core.util.BindingUtil;

public class MethodBindingUtil {
    private MethodBindingUtil() {
    }

    public static String getComponentName(String fromAction) {
        if (fromAction == null) {
            return null;
        }
        if (!BindingUtil.isValueReference(fromAction)) {
            return null;
        }
        int index = fromAction.indexOf(46);
        if (index > 0) {
            return fromAction.substring(2, index);
        }
        return null;
    }

    public static String getMethodName(String fromAction) {
        if (fromAction == null) {
            return null;
        }
        if (!BindingUtil.isValueReference(fromAction)) {
            return null;
        }
        int index = fromAction.lastIndexOf(46);
        if (index > 0) {
            return fromAction.substring(index + 1, fromAction.length() - 1);
        }
        return null;
    }

    public static String getFromAction(String componentName, String methodName) {
        AssertionUtil.assertNotNull((String)"componentName", (Object)componentName);
        AssertionUtil.assertNotNull((String)"methodName", (Object)methodName);
        return "#{" + componentName + "." + methodName + "}";
    }

    public static String invoke(MethodBinding methodBinding, FacesContext context) {
        try {
            return (String)methodBinding.invoke(context, null);
        }
        catch (EvaluationException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof AbortProcessingException) {
                throw (AbortProcessingException)cause;
            }
            throw e;
        }
    }
}

