/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.unit.xmlunit;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HtmlDomUtil {
    public static String toStructureString(Document document) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        NodeList childNodes = document.getChildNodes();
        HtmlDomUtil.printNodes(pw, childNodes, 0);
        return sw.toString();
    }

    private static void printNodes(PrintWriter pw, NodeList childNodes, int indent) {
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            HtmlDomUtil.printIndent(pw, indent);
            String nodeName = node.getNodeName();
            if (3 == node.getNodeType()) {
                if (node.hasChildNodes()) {
                    throw new RuntimeException();
                }
                pw.println("[" + nodeName + "]");
                continue;
            }
            if (node.hasChildNodes()) {
                pw.println("<" + nodeName + ">");
                HtmlDomUtil.printNodes(pw, node.getChildNodes(), indent + 1);
                HtmlDomUtil.printIndent(pw, indent);
                pw.println("</" + nodeName + ">");
                continue;
            }
            pw.println("<" + nodeName + " />");
        }
    }

    private static void printIndent(PrintWriter pw, int indent) {
        for (int i = 0; i < indent; ++i) {
            pw.print("  ");
        }
    }

    public static void removeNode(Node node) {
        node.getParentNode().removeChild(node);
    }

    public static void removeBlankTextNode(NodeList nodes) {
        Node node;
        int i;
        for (i = 0; i < nodes.getLength(); ++i) {
            node = nodes.item(i);
            if (3 != node.getNodeType() || 0 != node.getNodeValue().trim().length()) continue;
            HtmlDomUtil.removeNode(node);
        }
        for (i = 0; i < nodes.getLength(); ++i) {
            node = nodes.item(i);
            HtmlDomUtil.removeBlankTextNode(node.getChildNodes());
        }
    }
}

