/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.jsp;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import org.seasar.teeda.extension.exception.StreamClosedException;

public class BodyContentImpl
extends BodyContent {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private char[] cb;
    private int nextChar = 0;
    private boolean closed = false;

    public BodyContentImpl(JspWriter writer) {
        this(writer, 8192);
    }

    public BodyContentImpl(JspWriter writer, int bufferSize) {
        super(writer);
        this.cb = new char[bufferSize];
    }

    protected void ensureOpen() throws IOException {
        if (this.closed) {
            throw new StreamClosedException();
        }
    }

    public void write(int c) throws IOException {
        this.ensureOpen();
        this.reallocBufferIfNeed(1);
        this.cb[this.nextChar++] = (char)c;
    }

    protected void reallocBufferIfNeed(int len) {
        int available = this.cb.length - this.nextChar;
        if (len < available) {
            return;
        }
        char[] tmp = null;
        tmp = len <= this.cb.length * 3 + available ? new char[this.cb.length * 4] : new char[this.cb.length + len];
        System.arraycopy(this.cb, 0, tmp, 0, this.cb.length);
        this.cb = tmp;
        tmp = null;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.reallocBufferIfNeed(len);
        System.arraycopy(cbuf, off, this.cb, this.nextChar, len);
        this.nextChar += len;
    }

    public void write(char[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(String s, int off, int len) throws IOException {
        this.ensureOpen();
        this.reallocBufferIfNeed(len);
        s.getChars(off, off + len, this.cb, this.nextChar);
        this.nextChar += len;
    }

    public void write(String s) throws IOException {
        this.write(s, 0, s.length());
    }

    public void newLine() throws IOException {
        this.write("\n");
    }

    public void print(boolean b) throws IOException {
        this.write(b ? "true" : "false");
    }

    public void print(char c) throws IOException {
        this.write(String.valueOf(c));
    }

    public void print(int i) throws IOException {
        this.write(String.valueOf(i));
    }

    public void print(long l) throws IOException {
        this.write(String.valueOf(l));
    }

    public void print(float f) throws IOException {
        this.write(String.valueOf(f));
    }

    public void print(double d) throws IOException {
        this.write(String.valueOf(d));
    }

    public void print(char[] s) throws IOException {
        this.write(s);
    }

    public void print(String s) throws IOException {
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    public void print(Object o) throws IOException {
        this.write(String.valueOf(o));
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(boolean b) throws IOException {
        this.print(b);
        this.println();
    }

    public void println(char c) throws IOException {
        this.print(c);
        this.println();
    }

    public void println(int i) throws IOException {
        this.print(i);
        this.println();
    }

    public void println(long l) throws IOException {
        this.print(l);
        this.println();
    }

    public void println(float f) throws IOException {
        this.print(f);
        this.println();
    }

    public void println(double d) throws IOException {
        this.print(d);
        this.println();
    }

    public void println(char[] s) throws IOException {
        this.print(s);
        this.println();
    }

    public void println(String s) throws IOException {
        this.print(s);
        this.println();
    }

    public void println(Object o) throws IOException {
        this.print(o);
        this.println();
    }

    public void clear() throws IOException {
        this.clearBuffer();
    }

    public void clearBuffer() throws IOException {
        this.nextChar = 0;
    }

    public void close() throws IOException {
        this.cb = null;
        this.closed = true;
    }

    public int getRemaining() {
        return this.bufferSize - this.nextChar;
    }

    public Reader getReader() {
        return new CharArrayReader(this.cb, 0, this.nextChar);
    }

    public String getString() {
        return new String(this.cb, 0, this.nextChar);
    }

    public void writeOut(Writer out) throws IOException {
        out.write(this.cb, 0, this.nextChar);
    }
}

