/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.factory;

import java.util.Map;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.factory.AbstractElementProcessorFactory;

public class HolidayCalendarFactory
extends AbstractElementProcessorFactory {
    private static final String TAG_NAME = "holidayCalendar";
    private static final String HOLIDAYS = "Holidays";
    private static final String JANUARY = "january";
    private static final String FEBRUARY = "february";
    private static final String MARCH = "march";
    private static final String APRIL = "april";
    private static final String MAY = "may";
    private static final String JUNE = "june";
    private static final String JULY = "july";
    private static final String AUGUST = "august";
    private static final String SEPTEMBER = "september";
    private static final String OCTOBER = "october";
    private static final String NOVEMBER = "november";
    private static final String DECEMBER = "december";
    private static final String HOLIDAYS_YEAR = "holidaysYear";

    protected String getTagName() {
        return TAG_NAME;
    }

    protected String getUri() {
        return "http://www.seasar.org/teeda/extension";
    }

    public boolean isMatch(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        if (!"span".equalsIgnoreCase(elementNode.getTagName())) {
            return false;
        }
        String id = elementNode.getId();
        if (id == null) {
            return false;
        }
        if (pageDesc == null) {
            return false;
        }
        if (!id.endsWith(HOLIDAYS)) {
            return false;
        }
        return pageDesc.hasProperty(id);
    }

    protected void customizeProperties(Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        super.customizeProperties(properties, elementNode, pageDesc, actionDesc);
        if (pageDesc == null) {
            return;
        }
        String pageName = pageDesc.getPageName();
        String id = elementNode.getId();
        properties.put("value", this.getBindingExpression(pageName, id));
        String month = this.calcMonth(id);
        if (month != null) {
            properties.put("month", month);
        }
        if (pageDesc.hasProperty(HOLIDAYS_YEAR)) {
            properties.put("year", this.getBindingExpression(pageName, HOLIDAYS_YEAR));
        }
    }

    protected String calcMonth(String id) {
        String s = StringUtil.trimSuffix((String)id, (String)HOLIDAYS);
        if (JANUARY.equals(s)) {
            return "0";
        }
        if (FEBRUARY.equals(s)) {
            return "1";
        }
        if (MARCH.equals(s)) {
            return "2";
        }
        if (APRIL.equals(s)) {
            return "3";
        }
        if (MAY.equals(s)) {
            return "4";
        }
        if (JUNE.equals(s)) {
            return "5";
        }
        if (JULY.equals(s)) {
            return "6";
        }
        if (AUGUST.equals(s)) {
            return "7";
        }
        if (SEPTEMBER.equals(s)) {
            return "8";
        }
        if (OCTOBER.equals(s)) {
            return "9";
        }
        if (NOVEMBER.equals(s)) {
            return "10";
        }
        if (DECEMBER.equals(s)) {
            return "11";
        }
        return null;
    }

    public boolean isLeaf() {
        return true;
    }
}

