/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import javax.faces.component.ActionSource;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.internal.UICommandUtil;

public class UICommand
extends UIComponentBase
implements ActionSource {
    public static final String COMPONENT_FAMILY = "javax.faces.Command";
    public static final String COMPONENT_TYPE = "javax.faces.Command";
    private MethodBinding action = null;
    private MethodBinding actionListener = null;
    private boolean immediate = false;
    private boolean immediateSet = false;
    private Object value = null;
    private static final String IMMEDIATE_BINDING_NAME = "immediate";
    private static final String VALUE_BINDING_NAME = "value";
    private static final String DEFAULT_RENDER_TYPE = "javax.faces.Button";

    public UICommand() {
        this.setRendererType(DEFAULT_RENDER_TYPE);
    }

    public String getFamily() {
        return "javax.faces.Command";
    }

    public MethodBinding getAction() {
        return this.action;
    }

    public void setAction(MethodBinding action) {
        this.action = action;
    }

    public MethodBinding getActionListener() {
        return this.actionListener;
    }

    public void setActionListener(MethodBinding actionListener) {
        this.actionListener = actionListener;
    }

    public boolean isImmediate() {
        if (this.immediateSet) {
            return this.immediate;
        }
        ValueBinding vb = this.getValueBinding(IMMEDIATE_BINDING_NAME);
        return vb != null ? this.isBindingValueTrue(vb) : this.immediate;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
        this.immediateSet = true;
    }

    public Object getValue() {
        if (this.value != null) {
            return this.value;
        }
        ValueBinding vb = this.getValueBinding(VALUE_BINDING_NAME);
        return vb != null ? this.getValueFromBinding(vb) : null;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void addActionListener(ActionListener listener) {
        this.addFacesListener(listener);
    }

    public ActionListener[] getActionListeners() {
        ActionListener[] listeners = (ActionListener[])this.getFacesListeners(ActionListener.class);
        return listeners;
    }

    public void removeActionListener(ActionListener listener) {
        this.removeFacesListener(listener);
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.action = (MethodBinding)UICommand.restoreAttachedState(context, values[1]);
        this.actionListener = (MethodBinding)UICommand.restoreAttachedState(context, values[2]);
        this.immediate = (Boolean)values[3];
        this.immediateSet = (Boolean)values[4];
        this.value = values[5];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), UICommand.saveAttachedState(context, this.action), UICommand.saveAttachedState(context, this.actionListener), this.immediate ? Boolean.TRUE : Boolean.FALSE, this.immediateSet ? Boolean.TRUE : Boolean.FALSE, this.value};
        return values;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof ActionEvent) {
            ActionListener listener;
            FacesContext context = this.getFacesContext();
            MethodBinding mb = this.getActionListener();
            if (mb != null) {
                mb.invoke(context, new Object[]{event});
            }
            if ((listener = context.getApplication().getActionListener()) != null) {
                listener.processAction((ActionEvent)event);
            }
        }
    }

    public void queueEvent(FacesEvent event) {
        if (event instanceof ActionEvent) {
            if (this.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
            FacesContext facesContext = this.getFacesContext();
            UICommandUtil.setSubmittedCommand(facesContext, this);
        }
        super.queueEvent(event);
    }

    private boolean isBindingValueTrue(ValueBinding vb) {
        Object value = this.getValueFromBinding(vb);
        return Boolean.TRUE.equals(value);
    }

    private Object getValueFromBinding(ValueBinding vb) {
        return vb.getValue(this.getFacesContext());
    }
}

