/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.internal.FacesConfigOptions;
import javax.faces.internal.UIComponentUtil;
import javax.servlet.ServletContext;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.util.DIContainerUtil;
import org.seasar.teeda.core.util.ServletContextUtil;
import org.seasar.teeda.extension.component.TInclude;
import org.seasar.teeda.extension.component.TIncludeChildBody;
import org.seasar.teeda.extension.component.TViewRoot;
import org.seasar.teeda.extension.component.UIBody;
import org.seasar.teeda.extension.component.UITitle;
import org.seasar.teeda.extension.component.html.THtmlHead;
import org.seasar.teeda.extension.helper.PathHelper;
import org.seasar.teeda.extension.html.HtmlDescCache;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.PageDescCache;
import org.seasar.teeda.extension.render.IncludedBody;

public class LayoutBuilder {
    public static final String LIST_KEY = LayoutBuilder.class.getName();
    public static final String POP_INDEX_KEY = LIST_KEY + ".INDEX";
    private static final Logger logger = Logger.getLogger((Class)LayoutBuilder.class);
    private ServletContext servletContext;
    private ViewHandler viewHandler;
    private PathHelper pathHelper;
    private HtmlDescCache htmlDescCache;
    private PageDescCache pageDescCache;
    static /* synthetic */ Class class$org$seasar$teeda$extension$component$UITitle;
    static /* synthetic */ Class class$org$seasar$teeda$extension$component$html$THtmlStyle;
    static /* synthetic */ Class class$org$seasar$teeda$extension$component$html$THtmlScript;
    static /* synthetic */ Class class$org$seasar$teeda$extension$component$html$THtmlLink;

    public static List getIncludedBodies(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        return (List)requestMap.get(LIST_KEY);
    }

    public void layout(FacesContext context, TViewRoot component) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)((Object)component));
        TViewRoot child = component;
        TViewRoot parent = this.getParentViewRoot(context, child);
        UIComponent title = null;
        List styleList = new ArrayList();
        List scriptList = new ArrayList();
        List linkList = new ArrayList();
        while (parent != null) {
            UIComponent head;
            UIComponent body = UIComponentUtil.findDescendant((UIComponent)child, (Class)(class$org$seasar$teeda$extension$component$UIBody == null ? LayoutBuilder.class$("org.seasar.teeda.extension.component.UIBody") : class$org$seasar$teeda$extension$component$UIBody));
            if (body == null) {
                logger.log("WTDA0202", new Object[]{child.getViewId()});
            }
            if ((head = UIComponentUtil.findDescendant((UIComponent)component, (Class)(class$org$seasar$teeda$extension$component$html$THtmlHead == null ? LayoutBuilder.class$("org.seasar.teeda.extension.component.html.THtmlHead") : class$org$seasar$teeda$extension$component$html$THtmlHead))) != null) {
                title = UIComponentUtil.findDescendant((UIComponent)head, (Class)(class$org$seasar$teeda$extension$component$UITitle == null ? LayoutBuilder.class$("org.seasar.teeda.extension.component.UITitle") : class$org$seasar$teeda$extension$component$UITitle));
                styleList = UIComponentUtil.collectDescendants((UIComponent)head, (Class)(class$org$seasar$teeda$extension$component$html$THtmlStyle == null ? LayoutBuilder.class$("org.seasar.teeda.extension.component.html.THtmlStyle") : class$org$seasar$teeda$extension$component$html$THtmlStyle));
                scriptList = UIComponentUtil.collectDescendants((UIComponent)head, (Class)(class$org$seasar$teeda$extension$component$html$THtmlScript == null ? LayoutBuilder.class$("org.seasar.teeda.extension.component.html.THtmlScript") : class$org$seasar$teeda$extension$component$html$THtmlScript));
                linkList = UIComponentUtil.collectDescendants((UIComponent)head, (Class)(class$org$seasar$teeda$extension$component$html$THtmlLink == null ? LayoutBuilder.class$("org.seasar.teeda.extension.component.html.THtmlLink") : class$org$seasar$teeda$extension$component$html$THtmlLink));
            }
            if (body != null) {
                List children = body.getChildren();
                IncludedBody includedBody = new IncludedBody(child.getViewId(), children);
                LayoutBuilder.pushIncludedBody(context, includedBody);
            }
            child = parent;
            parent = this.getParentViewRoot(context, child);
        }
        if (child != component) {
            component.setRootViewId(child.getViewId());
            component.getChildren().clear();
            component.getChildren().addAll(child.getChildren());
            UIComponent head = UIComponentUtil.findDescendant((UIComponent)component, (Class)THtmlHead.class);
            if (styleList.size() > 0) {
                head.getChildren().addAll(styleList);
            }
            if (scriptList.size() > 0) {
                head.getChildren().addAll(scriptList);
            }
            if (linkList.size() > 0) {
                head.getChildren().addAll(linkList);
            }
            if (title != null) {
                this.replaceComponent(head, title);
            }
        } else {
            component.setRootViewId(component.getViewId());
        }
    }

    public void processInclude(FacesContext context, UIComponent component) {
        if (component instanceof TInclude) {
            this.include(context, (TInclude)component);
        } else if (component instanceof TIncludeChildBody) {
            this.include(context, (TIncludeChildBody)component);
        }
        Iterator it = component.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            this.processInclude(context, child);
        }
    }

    protected TViewRoot getParentViewRoot(FacesContext context, TViewRoot component) {
        UIViewRoot viewRoot;
        String parentViewId = this.getParentViewId(context, component);
        if (parentViewId == null) {
            return null;
        }
        if (HotdeployUtil.isHotdeploy() || this.htmlDescCache.getHtmlDesc(parentViewId) == null) {
            InputStream is = ServletContextUtil.getResourceAsStream((ServletContext)this.servletContext, (String)parentViewId);
            if (is != null) {
                InputStreamUtil.close((InputStream)is);
            } else {
                return null;
            }
        }
        if ((viewRoot = this.viewHandler.restoreView(context, parentViewId)) == null) {
            viewRoot = this.viewHandler.createView(context, parentViewId);
        }
        return (TViewRoot)viewRoot;
    }

    protected String getParentViewId(FacesContext context, TViewRoot component) {
        Object page;
        BeanDesc beanDesc;
        PropertyDesc propDesc;
        PageDesc pageDesc;
        String defaultSuffix = FacesConfigOptions.getDefaultSuffix();
        if (defaultSuffix.indexOf(".jsp") >= 0) {
            return null;
        }
        String parentPath = FacesConfigOptions.getDefaultLayoutPath();
        int i = parentPath.lastIndexOf("/");
        String dirPath = parentPath.length() > i + 1 ? parentPath.substring(0, i + 1) : parentPath;
        UIViewRoot viewRoot = context.getViewRoot();
        if (component != viewRoot || viewRoot.getViewId().indexOf(dirPath) >= 0) {
            parentPath = null;
        }
        if ((pageDesc = this.pageDescCache.getPageDesc(component.getViewId())) != null && pageDesc.hasProperty("layout") && (propDesc = (beanDesc = BeanDescFactory.getBeanDesc((page = DIContainerUtil.getComponent((Object)pageDesc.getPageName())).getClass())).getPropertyDesc("layout")).isReadable()) {
            parentPath = (String)propDesc.getValue(page);
        }
        if (parentPath == null) {
            return null;
        }
        return this.pathHelper.fromViewRootRelativePathToViewId(parentPath);
    }

    protected static void pushIncludedBody(FacesContext context, IncludedBody includedBody) {
        Map requestMap = context.getExternalContext().getRequestMap();
        ArrayList<IncludedBody> list = (ArrayList<IncludedBody>)requestMap.get(LIST_KEY);
        if (list == null) {
            list = new ArrayList<IncludedBody>();
            requestMap.put(LIST_KEY, list);
        }
        requestMap.put(POP_INDEX_KEY, new Integer(list.size()));
        list.add(includedBody);
    }

    public static IncludedBody popIncludedBody(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        List list = (List)requestMap.get(LIST_KEY);
        if (list == null) {
            return null;
        }
        Integer popIndex = (Integer)requestMap.get(POP_INDEX_KEY);
        if (popIndex == null) {
            return null;
        }
        int index = popIndex;
        IncludedBody body = (IncludedBody)list.get(index);
        requestMap.put(POP_INDEX_KEY, new Integer(index - 1));
        return body;
    }

    protected boolean replaceComponent(UIComponent root, UIComponent titleCandidate) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            UIComponent child = (UIComponent)root.getChildren().get(i);
            boolean b = this.replaceComponent(child, titleCandidate);
            if (b) {
                return true;
            }
            if (!(child instanceof UITitle)) continue;
            root.getChildren().remove(i);
            root.getChildren().add(i, titleCandidate);
        }
        return false;
    }

    protected void include(FacesContext context, TIncludeChildBody component) {
        IncludedBody includedBody = LayoutBuilder.popIncludedBody(context);
        if (includedBody == null) {
            return;
        }
        component.getChildren().addAll(includedBody.getComponentList());
        component.setIncludedViewId(includedBody.getViewId());
    }

    protected void include(FacesContext context, TInclude component) {
        String src = component.getSrc();
        if (StringUtil.isEmpty((String)src)) {
            return;
        }
        String srcViewId = this.pathHelper.fromViewRootRelativePathToViewId(src);
        UIViewRoot viewRoot = this.viewHandler.restoreView(context, srcViewId);
        if (viewRoot == null) {
            viewRoot = this.viewHandler.createView(context, srcViewId);
        }
        if (viewRoot == null) {
            return;
        }
        UIComponent body = UIComponentUtil.findDescendant((UIComponent)viewRoot, (Class)UIBody.class);
        if (body == null) {
            logger.log("WTDA0202", new Object[]{viewRoot.getViewId()});
            return;
        }
        IncludedBody includedBody = new IncludedBody(viewRoot.getViewId(), body.getChildren());
        component.getChildren().addAll(includedBody.getComponentList());
        component.setIncludedViewId(includedBody.getViewId());
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setViewHandler(ViewHandler viewHandler) {
        this.viewHandler = viewHandler;
    }

    public void setPathHelper(PathHelper pathHelper) {
        this.pathHelper = pathHelper;
    }

    public void setHtmlDescCache(HtmlDescCache htmlDescCache) {
        this.htmlDescCache = htmlDescCache;
    }

    public void setPageDescCache(PageDescCache pageDescCache) {
        this.pageDescCache = pageDescCache;
    }
}

