/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.extension.ExtensionConstants;
import org.seasar.teeda.extension.component.TreeModel;
import org.seasar.teeda.extension.component.TreeNode;

public class TreeModelImpl
implements TreeModel {
    private static final long serialVersionUID = 1L;
    private static final String ROOT_NODE_ID = "0";
    private TreeNode root;
    private TreeNode currentNode = null;

    public TreeModelImpl(TreeNode root) {
        AssertionUtil.assertNotNull((String)"root", (Object)root);
        this.root = root;
    }

    public boolean isNodeExpanded(String nodeId) {
        AssertionUtil.assertNotNull((String)"nodeId", (Object)nodeId);
        if (this.isRootNode(nodeId)) {
            return this.root.isExpanded();
        }
        TreeNode node = this.getNodeById(nodeId);
        return node.isExpanded();
    }

    public void toggleExpanded(String nodeId) {
        AssertionUtil.assertNotNull((String)"nodeId", (Object)nodeId);
        this.setExpanded(nodeId, true);
    }

    public void collapseExpanded(String nodeId) {
        AssertionUtil.assertNotNull((String)"nodeId", (Object)nodeId);
        this.setExpanded(nodeId, false);
    }

    protected void setExpanded(String nodeId, boolean expanded) {
        TreeNode node = null;
        node = this.isRootNode(nodeId) ? this.root : this.getNodeById(nodeId);
        node.setExpanded(expanded);
    }

    public String[] getPathInformation(String nodeId) {
        if (nodeId == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> pathList = new ArrayList<String>();
        pathList.add(nodeId);
        while (nodeId.lastIndexOf(ExtensionConstants.NAME_SEPARATOR) != -1) {
            nodeId = nodeId.substring(0, nodeId.lastIndexOf(ExtensionConstants.NAME_SEPARATOR));
            pathList.add(nodeId);
        }
        String[] ret = pathList.toArray(new String[pathList.size()]);
        Arrays.sort(ret, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                int len2;
                int len1 = arg0.toString().length();
                if (len1 < (len2 = arg1.toString().length())) {
                    return -1;
                }
                if (len1 == len2) {
                    return 0;
                }
                return 1;
            }
        });
        return ret;
    }

    public boolean isLastChild(String nodeId) {
        TreeNode parentNode;
        AssertionUtil.assertNotNull((String)"nodeId", (Object)nodeId);
        if (this.isRootNode(nodeId)) {
            return true;
        }
        String parentId = nodeId.substring(0, nodeId.lastIndexOf(ExtensionConstants.NAME_SEPARATOR));
        String childString = nodeId.substring(nodeId.lastIndexOf(ExtensionConstants.NAME_SEPARATOR) + 1);
        int childId = Integer.parseInt(childString);
        return childId + 1 == (parentNode = this.getNodeById(parentId)).getChildCount();
    }

    protected boolean isRootNode(String nodeId) {
        return nodeId.lastIndexOf(ExtensionConstants.NAME_SEPARATOR) == -1;
    }

    public TreeNode getNodeById(String nodeId) {
        if (nodeId == null) {
            return null;
        }
        TreeNode node = null;
        StringTokenizer st = new StringTokenizer(nodeId, ExtensionConstants.NAME_SEPARATOR);
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            int nodeIndex = Integer.parseInt(nextToken);
            if (node == null) {
                node = this.root;
                continue;
            }
            List children = node.getChildren();
            if (children.size() <= 0) break;
            node = (TreeNode)children.get(nodeIndex);
        }
        return node;
    }

    public void setNodeById(String nodeId) {
        if (nodeId == null) {
            this.currentNode = null;
            return;
        }
        this.currentNode = this.getNodeById(nodeId);
    }

    public TreeNode getCurrentTreeNode() {
        return this.currentNode;
    }

    public TreeNode getRootNode() {
        return this.getNodeById(ROOT_NODE_ID);
    }
}

