/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.hotdeploy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.seasar.framework.container.hotdeploy.HotdeployHttpServletRequest;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.exception.SessionObjectNotSerializableRuntimeException;
import org.seasar.framework.log.Logger;

public class HotdeployHttpSession
implements HttpSession {
    private static final Logger logger = Logger.getLogger(HotdeployHttpSession.class);
    protected final HotdeployHttpServletRequest request;
    protected final HttpSession originalSession;
    protected final Map attributes = new HashMap();
    protected boolean active = true;

    public HotdeployHttpSession(HttpSession originalSession) {
        this(null, originalSession);
    }

    public HotdeployHttpSession(HotdeployHttpServletRequest request, HttpSession originalSession) {
        this.request = request;
        this.originalSession = originalSession;
    }

    public void flush() {
        if (this.active) {
            Iterator it = this.attributes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                try {
                    this.originalSession.setAttribute((String)entry.getKey(), (Object)new SerializedObjectHolder(entry.getValue()));
                }
                catch (IllegalStateException e) {
                    return;
                }
                catch (Exception e) {
                    logger.log("ESSR0017", new Object[]{e}, e);
                }
            }
        }
    }

    public Object getAttribute(String name) {
        this.assertActive();
        if (this.attributes.containsKey(name)) {
            return this.attributes.get(name);
        }
        Object value = this.originalSession.getAttribute(name);
        if (value instanceof SerializedObjectHolder) {
            if ((value = ((SerializedObjectHolder)value).getDeserializedObject(name)) != null) {
                this.attributes.put(name, value);
            } else {
                this.originalSession.removeAttribute(name);
            }
        }
        return value;
    }

    public void setAttribute(String name, Object value) {
        this.assertActive();
        if (value == null) {
            this.originalSession.setAttribute(name, value);
            return;
        }
        if (!(value instanceof Serializable)) {
            throw new SessionObjectNotSerializableRuntimeException(value.getClass());
        }
        this.attributes.put(name, value);
        this.originalSession.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
        this.originalSession.removeAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.originalSession.getAttributeNames();
    }

    public long getCreationTime() {
        return this.originalSession.getCreationTime();
    }

    public String getId() {
        return this.originalSession.getId();
    }

    public long getLastAccessedTime() {
        return this.originalSession.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this.originalSession.getMaxInactiveInterval();
    }

    public ServletContext getServletContext() {
        return this.originalSession.getServletContext();
    }

    public HttpSessionContext getSessionContext() {
        return this.originalSession.getSessionContext();
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        return this.originalSession.getValueNames();
    }

    public void invalidate() {
        this.originalSession.invalidate();
        if (this.request != null) {
            this.request.invalidateSession();
        }
        this.active = false;
    }

    public boolean isNew() {
        return this.originalSession.isNew();
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void setMaxInactiveInterval(int interval) {
        this.originalSession.setMaxInactiveInterval(interval);
    }

    protected void assertActive() {
        if (!this.active) {
            throw new IllegalStateException("session invalidated");
        }
    }

    public static class SerializedObjectHolder {
        protected byte[] bytes;

        public SerializedObjectHolder(Object sessionObject) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(sessionObject);
                oos.close();
                this.bytes = baos.toByteArray();
            }
            catch (NotSerializableException e) {
                throw new SessionObjectNotSerializableRuntimeException(e);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }

        public Object getDeserializedObject(String name) {
            try {
                return HotdeployUtil.deserializeInternal(this.bytes);
            }
            catch (Exception e) {
                logger.log("ISSR0008", new Object[]{name}, e);
                return null;
            }
        }
    }
}

