/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.core.util.BindingUtil;
import org.seasar.teeda.core.util.ForEachContext;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.extension.component.TForEach;
import org.seasar.teeda.extension.util.AdjustValueHolderUtil;
import org.seasar.teeda.extension.util.TeedaExtensionConfiguration;

public class TForEachRenderer
extends AbstractRenderer {
    public static final String COMPONENT_FAMILY = "org.seasar.teeda.extension.ForEach";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.ForEach";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component);
        if (!this.isRendered(context, component)) {
            return;
        }
        TForEach forEach = (TForEach)component;
        if (forEach.isOmittag()) {
            return;
        }
        String tagName = forEach.getTagName();
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement(tagName, component);
        RendererUtil.renderIdAttributeIfNecessary((ResponseWriter)writer, (UIComponent)component, (String)this.getIdForRender(context, (UIComponent)forEach));
        this.renderAttributes(writer, forEach);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        TForEach forEach = (TForEach)component;
        ForEachContext foreachContext = ForEachContext.getContext();
        foreachContext.begin();
        try {
            this.encodeForEachChildren(context, forEach);
        }
        finally {
            foreachContext.end();
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component);
        if (!this.isRendered(context, component)) {
            return;
        }
        TForEach forEach = (TForEach)component;
        if (forEach.isOmittag()) {
            return;
        }
        String tagName = forEach.getTagName();
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement(tagName);
    }

    private void encodeForEachChildren(FacesContext context, TForEach forEach) throws IOException {
        Object page = forEach.getPage(context);
        BeanDesc pageBeanDesc = BeanDescFactory.getBeanDesc(page.getClass());
        Object[] items = forEach.getItems(context);
        int rowSize = items.length;
        for (int i = 0; i < rowSize; ++i) {
            Object item = items[i];
            if (item == null) continue;
            Integer savedIndex = forEach.bindRowIndex(context, new Integer(i));
            Map savedValues = forEach.itemToPage(pageBeanDesc, page, item);
            forEach.enterRow(context, i, (UIComponent)forEach);
            super.encodeChildren(context, (UIComponent)forEach);
            forEach.leaveRow(context, (UIComponent)forEach);
            forEach.pageToItem(page, pageBeanDesc, item, BeanDescFactory.getBeanDesc(item.getClass()), savedValues);
            forEach.bindRowIndex(context, savedIndex);
        }
    }

    protected boolean isRendered(FacesContext context, UIComponent component) {
        Object[] items;
        if (!component.isRendered()) {
            return false;
        }
        TForEach forEach = (TForEach)component;
        if (forEach.isOmittag()) {
            return false;
        }
        return TeedaExtensionConfiguration.getInstance().outputForEachIfEmptyItems || (items = forEach.getItems(context)) != null && items.length != 0;
    }

    protected void renderAttributes(ResponseWriter writer, TForEach component) throws IOException {
        Map attrs = component.getAttributes();
        Iterator i = attrs.keySet().iterator();
        while (i.hasNext()) {
            String attrName = (String)i.next();
            if (attrName.indexOf(46) > 0) continue;
            Object value = component.getAttributes().get(attrName);
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)attrName, value, (String)attrName);
        }
        String[] bindingPropertyNames = component.getBindingPropertyNames();
        for (int i2 = 0; i2 < bindingPropertyNames.length; ++i2) {
            String name = bindingPropertyNames[i2];
            Object value = BindingUtil.getBindingValue((UIComponent)component, (String)name);
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)name, (Object)value, (String)name);
        }
    }

    public void decode(FacesContext context, UIComponent component) {
        this.assertNotNull(context, component);
        this.decodeAllRows(context, (TForEach)component, component);
    }

    protected void decodeAllRows(FacesContext context, TForEach forEach, UIComponent base) {
        forEach.setRowIndex(-1);
        int rowSize = this.getRowSize(context, forEach);
        forEach.setRowSize(rowSize);
        for (int i = 0; i < rowSize; ++i) {
            Integer savedIndex = forEach.bindRowIndex(context, new Integer(i));
            forEach.enterRow(context, i, base);
            this.decodeChildren(context, base);
            forEach.leaveRow(context, base);
            forEach.bindRowIndex(context, savedIndex);
        }
    }

    private int getRowSize(FacesContext context, TForEach forEach) {
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        Map reqParam = AdjustValueHolderUtil.adjustParamMap(paramMap);
        String clientId = AdjustValueHolderUtil.getAdjustedValue(forEach.getClientId(context));
        String namingPrefix = clientId + ':';
        int rowSize = -1;
        Iterator it = reqParam.keySet().iterator();
        while (it.hasNext()) {
            int pos;
            String name = (String)it.next();
            if (!name.startsWith(namingPrefix) || -1 >= (pos = name.indexOf(58, namingPrefix.length()))) continue;
            String num = name.substring(namingPrefix.length(), pos);
            try {
                int index = Integer.parseInt(num);
                rowSize = Math.max(rowSize, index);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return ++rowSize;
    }

    private void decodeChildren(FacesContext context, UIComponent component) {
        Iterator it = component.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            child.processDecodes(context);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }
}

