/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.validator;

import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.internal.FacesMessageUtil;
import javax.faces.internal.UIComponentUtil;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.NumberConversionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.util.TargetCommandUtil;

public class TGreaterThanConstantValidator
implements Validator,
StateHolder {
    private static final String GC_MESSAGE_ID = "org.seasar.teeda.extension.validator.TGreaterThanConstantValidator.GC";
    protected boolean transientValue = false;
    protected Object target = new Integer(0);
    protected String targetCommand = null;
    protected String[] targetCommands;
    protected String messageId = null;

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)component);
        if (value == null) {
            return;
        }
        if (this.target == null) {
            return;
        }
        if (!TargetCommandUtil.isTargetCommand(context, this.targetCommands)) {
            return;
        }
        Object t = NumberConversionUtil.convertNumber(value.getClass(), (Object)this.getTarget());
        if (this.isLessEqual(value, t)) {
            Object[] args = new Object[]{t, UIComponentUtil.getLabel((UIComponent)component)};
            String messaId = this.getMessageId();
            FacesMessage message = FacesMessageUtil.getMessage((FacesContext)context, (String)messaId, (Object[])args);
            throw new ValidatorException(message, messaId, args);
        }
    }

    private boolean isLessEqual(Object value, Object targetValue) {
        return !(value instanceof Comparable) || ((Comparable)value).compareTo(targetValue) <= 0;
    }

    public String getMessageId() {
        return this.messageId != null ? this.messageId : GC_MESSAGE_ID;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.messageId, this.target, this.targetCommand};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.messageId = (String)values[0];
        this.target = values[1];
        this.targetCommand = (String)values[2];
        this.setTargetCommand(this.targetCommand);
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public String getTargetCommand() {
        return this.targetCommand;
    }

    public void setTargetCommand(String targetCommand) {
        this.targetCommand = targetCommand;
        if (StringUtil.isEmpty((String)targetCommand)) {
            return;
        }
        this.targetCommands = StringUtil.split((String)targetCommand, (String)", ");
    }
}

