/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.assembler;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.Application;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.application.ConfigurationSupport;
import org.seasar.teeda.core.application.ConverterConfiguration;
import org.seasar.teeda.core.config.faces.assembler.JsfAssembler;
import org.seasar.teeda.core.config.faces.element.ConverterElement;
import org.seasar.teeda.core.config.faces.element.PropertyElement;
import org.seasar.teeda.core.util.ApplicationUtil;
import org.seasar.teeda.core.util.IteratorUtil;

public abstract class ConverterChildAssembler
implements JsfAssembler {
    private Application application_;
    private Map targetCovnerters_ = Collections.EMPTY_MAP;

    public ConverterChildAssembler(Map targetConverters) {
        this.application_ = ApplicationUtil.getApplicationFromFactory();
        this.targetCovnerters_ = targetConverters;
    }

    public void assemble() {
        String converterKey = null;
        ConverterElement converterElement = null;
        Iterator itr = IteratorUtil.getEntryIterator(this.targetCovnerters_);
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            converterKey = (String)entry.getKey();
            converterElement = (ConverterElement)entry.getValue();
            if (StringUtil.isEmpty((String)converterKey) || converterElement == null) continue;
            this.setConverterConfiguration(converterKey, converterElement);
            this.doAssemble(converterKey, converterElement);
        }
    }

    protected void setConverterConfiguration(String converterKey, ConverterElement converterElement) {
        if (converterElement == null) {
            return;
        }
        Application app = this.getApplication();
        if (app instanceof ConfigurationSupport) {
            List properties = converterElement.getPropertyElements();
            ConfigurationSupport support = (ConfigurationSupport)((Object)app);
            Iterator itr = IteratorUtil.getIterator(properties);
            while (itr.hasNext()) {
                PropertyElement property = (PropertyElement)itr.next();
                String propertyName = property.getPropertyName();
                String propertyClass = property.getPropertyClass();
                String defaultValue = property.getDefaultValue();
                if (StringUtil.isEmpty((String)propertyName) || StringUtil.isEmpty((String)propertyClass)) continue;
                this.doAddConverterConfiguration(support, converterKey, new ConverterConfiguration(propertyName, propertyClass, defaultValue));
            }
        }
    }

    protected final Application getApplication() {
        return this.application_;
    }

    protected abstract void doAssemble(String var1, ConverterElement var2);

    protected abstract void doAddConverterConfiguration(ConfigurationSupport var1, String var2, ConverterConfiguration var3);
}

