/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import java.util.Map;
import javax.faces.context.FacesContext;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.teeda.core.util.DIContainerUtil;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.SubApplicationScopeHandler;
import org.seasar.teeda.extension.html.impl.ScopeValueHelper;

public class SubApplicationScopeHandlerImpl
implements SubApplicationScopeHandler {
    public boolean toScope(PageDesc pageDesc, FacesContext context) {
        if (pageDesc == null || !pageDesc.hasSubapplicationScopeProperty()) {
            return false;
        }
        String pageName = pageDesc.getPageName();
        Object page = DIContainerUtil.getComponent((Object)pageName);
        Map subApplicationScopeValues = ScopeValueHelper.getOrCreateSubApplicationScopeValues(context);
        String[] propertyNames = pageDesc.getSubapplicationScopePropertyNames();
        this.saveValueToScope(page, subApplicationScopeValues, propertyNames);
        return true;
    }

    protected void saveValueToScope(Object component, Map scopeContext, String[] scopePropertyNames) {
        if (component == null) {
            return;
        }
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(component.getClass());
        for (int i = 0; i < scopePropertyNames.length; ++i) {
            PropertyDesc propertyDesc;
            String propertyName = scopePropertyNames[i];
            if (!beanDesc.hasPropertyDesc(propertyName) || !(propertyDesc = beanDesc.getPropertyDesc(propertyName)).isReadable()) continue;
            Object value = propertyDesc.getValue(component);
            scopeContext.put(propertyName, value);
        }
    }
}

