/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.convert;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.internal.ConvertUtil;
import javax.faces.internal.FacesMessageUtil;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.component.html.THtmlInputFile;
import org.seasar.teeda.extension.convert.ConvertTargetSelectable;
import org.seasar.teeda.extension.convert.ConverterHelper;
import org.seasar.teeda.extension.util.TargetCommandUtil;
import org.seasar.teeda.extension.util.UploadedFile;

public abstract class AbstractUploadedFileConverter
implements Converter,
ConvertTargetSelectable,
StateHolder {
    protected String objectMessageId = this.getClass().getName() + ".CONVERSION";
    protected String stringMessageId = this.getClass().getName() + ".CONVERSION_STRING";
    protected String target;
    protected String[] targets;
    protected boolean transientValue = false;

    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        AssertionUtil.assertNotNull((String)"FacesContext", (Object)context);
        AssertionUtil.assertNotNull((String)"UIComponent", (Object)component);
        if (!ConverterHelper.isTargetCommand(context, component, this.targets, this)) {
            return null;
        }
        Object submittedValue = null;
        try {
            THtmlInputFile inputFile = (THtmlInputFile)component;
            submittedValue = inputFile.getSubmittedValue();
            if (submittedValue instanceof UploadedFile) {
                return this.getAsObject(context, (UploadedFile)submittedValue);
            }
            return null;
        }
        catch (Exception e) {
            Object[] args = ConvertUtil.createExceptionMessageArgs((UIComponent)component, submittedValue);
            throw new ConverterException(FacesMessageUtil.getMessage((FacesContext)context, (String)this.objectMessageId, (Object[])args), (Throwable)e);
        }
    }

    protected abstract Object getAsObject(FacesContext var1, UploadedFile var2) throws Exception;

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        if (!this.isTargetCommandConvert(context, this.targets)) {
            return null;
        }
        return "";
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
        if (StringUtil.isEmpty((String)target)) {
            return;
        }
        this.targets = StringUtil.split((String)target, (String)", ");
    }

    public boolean isTargetCommandConvert(FacesContext context, String[] targets) {
        return TargetCommandUtil.isTargetCommand(context, targets);
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.setTarget((String)values[0]);
        this.objectMessageId = (String)values[1];
        this.stringMessageId = (String)values[2];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.target, this.objectMessageId, this.stringMessageId};
        return values;
    }

    public String getObjectMessageId() {
        return this.objectMessageId;
    }

    public void setObjectMessageId(String objectMessageId) {
        this.objectMessageId = objectMessageId;
    }

    public String getStringMessageId() {
        return this.stringMessageId;
    }

    public void setStringMessageId(String stringMessageId) {
        this.stringMessageId = stringMessageId;
    }
}

