/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.component;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.internal.ComponentStates;
import javax.faces.internal.FacesMessageUtil;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.extension.component.TreeModel;
import org.seasar.teeda.extension.component.TreeModelImpl;
import org.seasar.teeda.extension.component.TreeNode;
import org.seasar.teeda.extension.event.ToggleEvent;
import org.seasar.teeda.extension.event.TreeEventWrapper;

public class UITreeData
extends UIInput
implements NamingContainer {
    public static final String COMPONENT_TYPE = "org.seasar.teeda.extension.Tree";
    public static final String COMPONENT_FAMILY = "org.seasar.teeda.extension.Tree";
    public static final String DEFAULT_RENDERER_TYPE = "org.seasar.teeda.extension.Tree";
    private TreeModel model;
    private String nodeId;
    private Object value;
    private String var;
    private ComponentStates states = new ComponentStates();

    public UITreeData() {
        this.setRendererType("org.seasar.teeda.extension.Tree");
    }

    public String getFamily() {
        return "org.seasar.teeda.extension.Tree";
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.var};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.var = (String)values[1];
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.states.clear();
        this.model = null;
        super.encodeBegin(context);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        TreeModel model = this.getDataModel();
        if (model == null) {
            throw new IllegalStateException();
        }
    }

    public void queueEvent(FacesEvent event) {
        super.queueEvent((FacesEvent)new TreeEventWrapper(event, this.getNodeId(), (UIComponent)this));
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof TreeEventWrapper) {
            TreeEventWrapper childEvent = (TreeEventWrapper)event;
            String currNodeId = this.getNodeId();
            this.setNodeId(childEvent.getOriginalNodeId());
            FacesEvent originalEvent = childEvent.getOriginalEvent();
            originalEvent.getComponent().broadcast(originalEvent);
            this.setNodeId(currNodeId);
        } else if (event instanceof ToggleEvent) {
            ToggleEvent toggleEvent = (ToggleEvent)event;
            String currentNodeId = this.getNodeId();
            this.setNodeId(toggleEvent.getNodeId());
            this.toggleExpanded();
            this.setNodeId(currentNodeId);
        } else {
            super.broadcast(event);
        }
    }

    public void processDecodes(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (!this.isRendered()) {
            return;
        }
        this.model = null;
        this.states.clear();
        this.setNodeId(null);
        this.decode(context);
        this.processNodes(context, PhaseId.APPLY_REQUEST_VALUES, null, 0);
    }

    public void processValidators(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (!this.isRendered()) {
            return;
        }
        this.processNodes(context, PhaseId.PROCESS_VALIDATIONS, null, 0);
        this.setNodeId(null);
        if (!this.hasErrorFacesMessageInTree(context)) {
            this.processNodes(context, PhaseId.UPDATE_MODEL_VALUES, null, 0);
            this.setNodeId(null);
        }
    }

    private boolean hasErrorFacesMessageInTree(FacesContext context) {
        Iterator clientIds = this.states.getSavedStates().keySet().iterator();
        while (clientIds.hasNext()) {
            String clientId = (String)clientIds.next();
            Iterator messages = context.getMessages(clientId);
            while (messages.hasNext()) {
                FacesMessage message = (FacesMessage)messages.next();
                if (message.getSeverity().compareTo((Object)FacesMessage.SEVERITY_ERROR) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public void processUpdates(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (!this.isRendered()) {
            return;
        }
        this.processNodes(context, PhaseId.UPDATE_MODEL_VALUES, null, 0);
        this.setNodeId(null);
    }

    public void updateModel(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        ValueBinding valueBinding = this.getValueBinding("value");
        if (valueBinding == null) {
            return;
        }
        try {
            Object value = this.getValue();
            valueBinding.setValue(context, value);
        }
        catch (RuntimeException e) {
            Object[] args = new Object[]{this.getId()};
            context.getExternalContext().log(e.getMessage(), (Throwable)e);
            FacesMessageUtil.addErrorComponentMessage((FacesContext)context, (UIComponent)this, (String)"javax.faces.component.UIInput.CONVERSION", (Object[])args);
            this.setValid(false);
        }
    }

    public String getClientId(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        String ownClientId = this.getOwnClientId(context);
        if (this.nodeId != null) {
            return ownClientId + ':' + this.nodeId;
        }
        return ownClientId;
    }

    public String getOwnClientId(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        return super.getClientId(context);
    }

    public void setValueBinding(String name, ValueBinding binding) {
        if ("value".equals(name)) {
            this.model = null;
        } else if ("nodeVar".equals(name) || "nodeId".equals(name) || "treeVar".equals(name)) {
            throw new IllegalArgumentException("name " + name);
        }
        super.setValueBinding(name, binding);
    }

    public void setValue(Object value) {
        this.model = null;
        this.value = value;
        this.setLocalValueSet(true);
    }

    public Object getValue() {
        if (this.value != null) {
            return this.value;
        }
        ValueBinding vb = this.getValueBinding("value");
        return vb != null ? vb.getValue(this.getFacesContext()) : null;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getVar() {
        return this.var;
    }

    public TreeNode getNode() {
        TreeModel dataModel = this.getDataModel();
        if (dataModel == null) {
            return null;
        }
        return dataModel.getCurrentTreeNode();
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        FacesContext context = this.getFacesContext();
        this.saveDescendantState(context);
        this.nodeId = nodeId;
        TreeModel model = this.getDataModel();
        if (model == null) {
            return;
        }
        try {
            model.setNodeById(nodeId);
        }
        catch (IndexOutOfBoundsException aob) {
            FacesMessage message = FacesMessageUtil.getMessage((FacesContext)context, (String)"missing_node_message_id_here", (Object[])new String[]{nodeId});
            message.setSeverity(FacesMessage.SEVERITY_WARN);
            context.addMessage(this.getId(), message);
        }
        this.restoreDescendantState(context);
        if (this.var != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            if (nodeId == null) {
                requestMap.remove(this.var);
            } else {
                requestMap.put(this.var, this.getNode());
            }
        }
    }

    public String[] getPathInformation(String nodeId) {
        return this.getDataModel().getPathInformation(nodeId);
    }

    public boolean isLastChild(String nodeId) {
        return this.getDataModel().isLastChild(nodeId);
    }

    public TreeModel getDataModel() {
        if (this.model != null) {
            return this.model;
        }
        Object value = this.getValue();
        if (value != null) {
            if (value instanceof TreeModel) {
                this.model = (TreeModel)value;
            } else if (value instanceof TreeNode) {
                this.model = this.wrapTreeNode((TreeNode)value);
            } else {
                throw new IllegalStateException("Value must be a TreeModel or TreeNode");
            }
        }
        return this.model;
    }

    protected TreeModel wrapTreeNode(TreeNode node) {
        return new TreeModelImpl(node);
    }

    public void expandAll() {
        this.toggleAll(true);
    }

    public void collapseAll() {
        this.toggleAll(false);
    }

    private void toggleAll(boolean expanded) {
        String id = this.getNodeId();
        if (expanded && !this.model.isNodeExpanded(id) || !expanded && this.model.isNodeExpanded(id)) {
            this.model.toggleExpanded(id);
        }
    }

    protected void processNodes(FacesContext context, PhaseId phaseId, String parentId, int level) {
        String id = parentId != null ? parentId + ':' + level : "0";
        this.setNodeId(id);
        TreeNode node = this.getNode();
        if (node == null) {
            return;
        }
        String type = node.getType();
        UIComponent facet = this.getFacet(type);
        if (facet == null) {
            return;
        }
        if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
            facet.processDecodes(context);
        } else if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
            facet.processValidators(context);
        } else if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
            facet.processUpdates(context);
        }
        this.processChildNodes(context, node, phaseId);
    }

    protected void processChildNodes(FacesContext context, TreeNode node, PhaseId phaseId) {
        String currentId = this.getNodeId();
        List children = node.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            this.processNodes(context, phaseId, currentId, i);
        }
    }

    public void restoreDescendantState(FacesContext context) {
        this.states.restoreDescendantState(context, (UIComponent)this);
    }

    public void saveDescendantState(FacesContext context) {
        this.states.saveDescendantComponentStates(context, (UIComponent)this);
    }

    public void toggleExpanded() {
        TreeModel model = this.getDataModel();
        if (model != null) {
            model.toggleExpanded(this.getNodeId());
        }
    }

    public boolean isNodeExpanded() {
        TreeModel model = this.getDataModel();
        if (model != null) {
            return model.isNodeExpanded(this.getNodeId());
        }
        return false;
    }
}

