/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import java.util.HashMap;
import java.util.Map;
import org.seasar.teeda.core.application.TeedaStateManager;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ActionDescCache;
import org.seasar.teeda.extension.html.HtmlDesc;
import org.seasar.teeda.extension.html.HtmlDescCache;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.PageDescCache;
import org.seasar.teeda.extension.html.TagProcessor;
import org.seasar.teeda.extension.html.TagProcessorAssembler;
import org.seasar.teeda.extension.html.TagProcessorCache;

public class TagProcessorCacheImpl
implements TagProcessorCache {
    private Map cache = new HashMap();
    private HtmlDescCache htmlDescCache;
    private PageDescCache pageDescCache;
    private ActionDescCache actionDescCache;
    private TagProcessorAssembler assembler;
    private TeedaStateManager stateManager;

    public void setHtmlDescCache(HtmlDescCache htmlDescCache) {
        this.htmlDescCache = htmlDescCache;
    }

    public void setPageDescCache(PageDescCache pageDescCache) {
        this.pageDescCache = pageDescCache;
    }

    public void setActionDescCache(ActionDescCache actionDescCache) {
        this.actionDescCache = actionDescCache;
    }

    public void setAssembler(TagProcessorAssembler assembler) {
        this.assembler = assembler;
    }

    public void setStateManager(TeedaStateManager stateManager) {
        this.stateManager = stateManager;
    }

    public synchronized TagProcessor updateTagProcessor(String viewId) {
        ActionDesc actionDesc;
        PageDesc pageDesc;
        boolean created = false;
        HtmlDesc htmlDesc = this.htmlDescCache.getHtmlDesc(viewId);
        if ((htmlDesc == null || htmlDesc.isModified()) && (htmlDesc = this.htmlDescCache.createHtmlDesc(viewId)) != null) {
            created = true;
        }
        if (((pageDesc = this.pageDescCache.getPageDesc(viewId)) == null || pageDesc.isModified()) && (pageDesc = this.pageDescCache.createPageDesc(viewId)) != null) {
            created = true;
        }
        if (((actionDesc = this.actionDescCache.getActionDesc(viewId)) == null || actionDesc.isModified()) && (actionDesc = this.actionDescCache.createActionDesc(viewId)) != null) {
            created = true;
        }
        if (created) {
            this.cache.put(viewId, this.assembler.assemble(htmlDesc, pageDesc, actionDesc));
            this.stateManager.removeSerializedView(viewId);
        }
        return this.getTagProcessor(viewId);
    }

    public synchronized TagProcessor getTagProcessor(String viewId) {
        return (TagProcessor)this.cache.get(viewId);
    }
}

