/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.config.taglib.impl;

import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.ServletContext;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.framework.util.URLUtil;
import org.seasar.teeda.extension.config.taglib.impl.AbstractTaglibManager;

public class ServletContextTaglibManagerImpl
extends AbstractTaglibManager {
    private static Logger logger = Logger.getLogger((Class)ServletContextTaglibManagerImpl.class);
    private ServletContext servletContext;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void init() {
        this.scanTlds("/WEB-INF/");
        this.scanJars("/WEB-INF/lib/");
    }

    public void scanJars(String libPath) {
        Set jars = this.servletContext.getResourcePaths(libPath);
        if (jars != null) {
            Iterator i = jars.iterator();
            while (i.hasNext()) {
                String path = (String)i.next();
                if (!path.toLowerCase().endsWith(".jar")) continue;
                this.scanJar(path);
            }
        }
    }

    public void scanJar(String jarPath) {
        try {
            URL url = this.servletContext.getResource(jarPath);
            JarURLConnection conn = this.openJarURLConnection(url);
            if (conn == null) {
                return;
            }
            this.scanJar(conn);
        }
        catch (Throwable t) {
            logger.log(t);
        }
    }

    public void scanTlds(String basePath) {
        Set tlds = this.servletContext.getResourcePaths(basePath);
        if (tlds != null) {
            Iterator i = tlds.iterator();
            while (i.hasNext()) {
                String path = (String)i.next();
                if (path.toLowerCase().endsWith(".tld")) {
                    this.scanTld(path);
                    continue;
                }
                if (!path.endsWith("/")) continue;
                this.scanTlds(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanTld(String tldPath) {
        try {
            URL url = this.servletContext.getResource(tldPath);
            InputStream is = URLUtil.openStream((URL)url);
            try {
                if (is == null) {
                    return;
                }
                this.scanTld(is, tldPath);
            }
            finally {
                InputStreamUtil.close((InputStream)is);
            }
        }
        catch (Throwable t) {
            logger.log(t);
        }
    }
}

