/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.httpsession;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.seasar.extension.httpsession.S2HttpSession;
import org.seasar.extension.httpsession.SessionIdUtil;
import org.seasar.extension.httpsession.SessionStateManager;
import org.seasar.framework.container.servlet.S2ContainerServlet;
import org.seasar.framework.util.UUID;

public class S2HttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private HttpServletRequest request;
    private SessionStateManager sessionStateManager;
    private S2HttpSession session;
    private String requestedSessionIdFromCookie;
    private String requestedSessionIdFromURL;
    private String createdSessionId;

    public S2HttpServletRequestWrapper(HttpServletRequest request, SessionStateManager sessionStateManager) {
        super(request);
        this.request = request;
        this.sessionStateManager = sessionStateManager;
        this.setupSessionId();
    }

    protected void setupSessionId() {
        this.requestedSessionIdFromCookie = SessionIdUtil.getSessionIdFromCookie(this.request);
        if (this.requestedSessionIdFromCookie == null) {
            this.requestedSessionIdFromURL = SessionIdUtil.getSessionIdFromURL(this.request);
        }
        if (this.requestedSessionIdFromURL == null) {
            this.createdSessionId = UUID.create();
        }
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (this.session != null) {
            return this.session;
        }
        boolean isNew = false;
        String sessionId = this.getRequestedSessionId();
        if (sessionId == null) {
            if (!create) {
                return null;
            }
            sessionId = this.createdSessionId;
            isNew = true;
        }
        this.session = new S2HttpSession(sessionId, this.sessionStateManager, S2ContainerServlet.getInstance().getServletContext(), isNew);
        return this.session;
    }

    public S2HttpSession getS2HttpSession() {
        return this.session;
    }

    public String getRequestedSessionId() {
        if (this.requestedSessionIdFromCookie != null) {
            return this.requestedSessionIdFromCookie;
        }
        return this.requestedSessionIdFromURL;
    }

    public String getCreatedSessionId() {
        return this.createdSessionId;
    }

    public String getSessionId() {
        String sessionId = this.getRequestedSessionId();
        if (sessionId == null) {
            sessionId = this.createdSessionId;
        }
        return sessionId;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.requestedSessionIdFromCookie != null;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.requestedSessionIdFromURL != null;
    }
}

