/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlOutputFormat;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.IgnoreAttribute;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.core.util.ValueHolderUtil;

public class HtmlOutputFormatRenderer
extends AbstractRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Output";
    public static final String RENDERER_TYPE = "javax.faces.Format";
    private final IgnoreAttribute ignoreComponent = new IgnoreAttribute();

    public HtmlOutputFormatRenderer() {
        this.ignoreComponent.addAttributeName("id");
        this.ignoreComponent.addAttributeName("value");
        this.ignoreComponent.addAttributeName("escape");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlOutputFormatEnd(context, (HtmlOutputFormat)component);
    }

    protected void encodeHtmlOutputFormatEnd(FacesContext context, HtmlOutputFormat htmlOutputFormat) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean startSpan = false;
        if (this.containsAttributeForRender(htmlOutputFormat, this.ignoreComponent)) {
            writer.startElement("span", htmlOutputFormat);
            startSpan = true;
            RendererUtil.renderIdAttributeIfNecessary(writer, htmlOutputFormat, this.getIdForRender(context, htmlOutputFormat));
            this.renderRemainAttributes(htmlOutputFormat, writer, this.ignoreComponent);
        }
        String value = this.getFormattedValue(context, htmlOutputFormat);
        if (htmlOutputFormat.isEscape()) {
            writer.writeText(value, null);
        } else {
            writer.write(value);
        }
        if (startSpan) {
            writer.endElement("span");
        }
    }

    protected String getFormattedValue(FacesContext context, HtmlOutputFormat htmlOutputFormat) {
        ArrayList<Object> args = new ArrayList<Object>();
        Iterator it = htmlOutputFormat.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            if (!(child instanceof UIParameter)) continue;
            UIParameter parameter = (UIParameter)child;
            args.add(parameter.getValue());
        }
        String pattern = ValueHolderUtil.getValueForRender(context, htmlOutputFormat);
        MessageFormat format = new MessageFormat(pattern, this.getLocale(context));
        String value = format.format(args.toArray(new Object[args.size()]));
        return value;
    }

    protected Locale getLocale(FacesContext context) {
        Locale locale = context.getViewRoot().getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }
}

