/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.context.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.faces.internal.EncodeUrlCustomizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.framework.container.external.servlet.CookieMap;
import org.seasar.framework.container.external.servlet.HttpSessionMap;
import org.seasar.framework.container.external.servlet.ServletApplicationMap;
import org.seasar.framework.container.external.servlet.ServletInitParameterMap;
import org.seasar.framework.container.external.servlet.ServletRequestHeaderMap;
import org.seasar.framework.container.external.servlet.ServletRequestHeaderValuesMap;
import org.seasar.framework.container.external.servlet.ServletRequestMap;
import org.seasar.framework.container.external.servlet.ServletRequestParameterMap;
import org.seasar.framework.container.external.servlet.ServletRequestParameterValuesMap;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.core.context.Releaseable;
import org.seasar.teeda.core.scope.impl.DispatchScopeFactory;
import org.seasar.teeda.core.util.ServletExternalContextUtil;

public class ServletExternalContextImpl
extends ExternalContext
implements Releaseable {
    private static Logger logger = Logger.getLogger((Class)ServletExternalContextImpl.class);
    private ServletContext context;
    private ServletRequest request;
    private ServletResponse response;
    private String servletPath = null;
    private String pathInfo = null;
    private boolean isHttpServletRequest = false;
    private boolean isHttpServletResponse = false;
    private Map applicationMap = null;
    private Map initParameterMap = null;
    private Map sessionMap = null;
    private Map requestCookieMap = null;
    private Map requestParameterMap = null;
    private Map requestParameterValuesMap = null;
    private Map requestMap = null;
    private Map requestHeaderMap = null;
    private Map requestHeaderValuesMap = null;
    private EncodeUrlCustomizer customizer = null;

    public ServletExternalContextImpl(ServletContext context, ServletRequest request, ServletResponse response) {
        this.context = context;
        this.request = request;
        this.response = response;
        this.isHttpServletRequest = ServletExternalContextUtil.isHttpServletRequest(this.request);
        this.isHttpServletResponse = ServletExternalContextUtil.isHttpServletResponse(this.response);
        ServletExternalContextUtil.setCharacterEncoding(this.request);
        if (this.isHttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            this.servletPath = httpServletRequest.getServletPath();
            this.pathInfo = httpServletRequest.getPathInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(String path) throws IOException {
        try {
            ServletExternalContextUtil.dispatch(path, this.request, this.response);
        }
        finally {
            DispatchScopeFactory.destroy();
        }
    }

    public String encodeActionURL(String url) {
        this.assertHttpServletResponse();
        String encodedUrl = this.customizer.encodeActionUrl(this, url);
        HttpServletResponse httpResponse = (HttpServletResponse)this.response;
        if (((HttpServletRequest)this.request).isRequestedSessionIdFromCookie()) {
            return encodedUrl;
        }
        return httpResponse.encodeURL(encodedUrl);
    }

    public String encodeNamespace(String name) {
        AssertionUtil.assertNotNull((String)"name is null.", (Object)name);
        return name;
    }

    public String encodeResourceURL(String url) {
        this.assertHttpServletResponse();
        String encodedUrl = this.customizer.encodeResourceUrl(this, url);
        HttpServletResponse httpResponse = (HttpServletResponse)this.response;
        if (((HttpServletRequest)this.request).isRequestedSessionIdFromCookie()) {
            return encodedUrl;
        }
        return httpResponse.encodeURL(encodedUrl);
    }

    public Map getApplicationMap() {
        if (this.applicationMap == null) {
            this.applicationMap = new ServletApplicationMap(this.context);
        }
        return this.applicationMap;
    }

    public String getAuthType() {
        this.assertHttpServletRequest();
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.request;
        return httpServletRequest.getAuthType();
    }

    public Object getContext() {
        return this.context;
    }

    public String getInitParameter(String name) {
        return this.context.getInitParameter(name);
    }

    public Map getInitParameterMap() {
        if (this.initParameterMap == null) {
            this.initParameterMap = new ServletInitParameterMap(this.context);
        }
        return this.initParameterMap;
    }

    public String getRemoteUser() {
        this.assertHttpServletRequest();
        HttpServletRequest httpRequest = (HttpServletRequest)this.request;
        return httpRequest.getRemoteUser();
    }

    public Object getRequest() {
        return this.request;
    }

    public String getRequestContextPath() {
        this.assertHttpServletRequest();
        HttpServletRequest httpRequest = (HttpServletRequest)this.request;
        return httpRequest.getContextPath();
    }

    public Map getRequestCookieMap() {
        this.assertHttpServletRequest();
        if (this.requestCookieMap == null) {
            this.requestCookieMap = new CookieMap((HttpServletRequest)this.request);
        }
        return this.requestCookieMap;
    }

    public Map getRequestHeaderMap() {
        this.assertHttpServletRequest();
        if (this.requestHeaderMap == null) {
            this.requestHeaderMap = new ServletRequestHeaderMap((HttpServletRequest)this.request);
        }
        return this.requestHeaderMap;
    }

    public Map getRequestHeaderValuesMap() {
        if (this.requestHeaderValuesMap == null) {
            this.requestHeaderValuesMap = new ServletRequestHeaderValuesMap((HttpServletRequest)this.request);
        }
        return this.requestHeaderValuesMap;
    }

    public Locale getRequestLocale() {
        return this.request.getLocale();
    }

    public Iterator getRequestLocales() {
        Enumeration locales = this.request.getLocales();
        return ServletExternalContextUtil.getLocales(locales);
    }

    public Map getRequestMap() {
        if (this.requestMap == null) {
            this.requestMap = new ServletRequestMap(this.request);
        }
        return this.requestMap;
    }

    public Map getRequestParameterMap() {
        if (this.requestParameterMap == null) {
            this.requestParameterMap = new ServletRequestParameterMap(this.request);
        }
        return this.requestParameterMap;
    }

    public Iterator getRequestParameterNames() {
        Enumeration paramNames = this.request.getParameterNames();
        return ServletExternalContextUtil.getRequestParameterNames(paramNames);
    }

    public Map getRequestParameterValuesMap() {
        if (this.requestParameterValuesMap == null) {
            this.requestParameterValuesMap = new ServletRequestParameterValuesMap(this.request);
        }
        return this.requestParameterValuesMap;
    }

    public String getRequestPathInfo() {
        return this.pathInfo;
    }

    public String getRequestServletPath() {
        return this.servletPath;
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.context.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.context.getResourceAsStream(path);
    }

    public Set getResourcePaths(String path) {
        return this.context.getResourcePaths(path);
    }

    public Object getResponse() {
        return this.response;
    }

    public Object getSession(boolean create) {
        this.assertHttpServletRequest();
        HttpServletRequest httpRequest = (HttpServletRequest)this.request;
        return httpRequest.getSession(create);
    }

    public Map getSessionMap() {
        if (this.sessionMap == null) {
            HttpServletRequest httpRequest = (HttpServletRequest)this.request;
            this.sessionMap = new HttpSessionMap(httpRequest);
        }
        return this.sessionMap;
    }

    public Principal getUserPrincipal() {
        this.assertHttpServletRequest();
        HttpServletRequest httpRequest = (HttpServletRequest)this.request;
        return httpRequest.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        this.assertHttpServletRequest();
        HttpServletRequest httpRequest = (HttpServletRequest)this.request;
        return httpRequest.isUserInRole(role);
    }

    public void log(String message) {
        AssertionUtil.assertNotNull((String)"message is null.", (Object)message);
        this.context.log(message);
        logger.debug((Object)message);
    }

    public void log(String message, Throwable exception) {
        AssertionUtil.assertNotNull((String)"message", (Object)message);
        AssertionUtil.assertNotNull((String)"exception", (Object)exception);
        this.context.log(message, exception);
        logger.log(exception);
    }

    public void redirect(String url) throws IOException {
        this.assertHttpServletResponse();
        ServletExternalContextUtil.redirect(url, this.request, this.response);
    }

    private void assertHttpServletRequest() {
        if (!this.isHttpServletRequest) {
            throw new IllegalStateException();
        }
    }

    private void assertHttpServletResponse() {
        if (!this.isHttpServletResponse) {
            throw new IllegalStateException();
        }
    }

    public void release() {
        this.context = null;
        this.request = null;
        this.response = null;
        this.servletPath = null;
        this.pathInfo = null;
        this.applicationMap = null;
        this.initParameterMap = null;
        this.sessionMap = null;
        this.requestCookieMap = null;
        this.requestParameterMap = null;
        this.requestParameterValuesMap = null;
        this.requestMap = null;
        this.requestHeaderMap = null;
        this.requestHeaderValuesMap = null;
    }

    public void setEncodeUrlCustomizer(EncodeUrlCustomizer customizer) {
        this.customizer = customizer;
    }
}

