/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.context;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.framework.util.EnumerationIterator;

public abstract class AbstractExternalContextMap
extends AbstractMap {
    private Set entrySet_;
    private Set keySet_;
    private Collection values_;

    public void clear() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            list.add(key);
        }
        this.clearReally(list);
    }

    private void clearReally(List keys) {
        Iterator itr = keys.iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            this.removeAttribute(key);
        }
    }

    public boolean containsKey(Object key) {
        return this.getAttribute(key.toString()) != null;
    }

    public boolean containsValue(Object value) {
        if (value != null) {
            Enumeration e = this.getAttributeNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object attributeValue = this.getAttribute(key);
                if (!value.equals(attributeValue)) continue;
                return true;
            }
        }
        return false;
    }

    public Set entrySet() {
        if (this.entrySet_ == null) {
            this.entrySet_ = new EntrySet(this);
        }
        return this.entrySet_;
    }

    public Object get(Object key) {
        return this.getAttribute(key.toString());
    }

    public Object put(Object key, Object value) {
        String keyStr = key.toString();
        Object o = this.getAttribute(keyStr);
        this.setAttribute(keyStr, value);
        return o;
    }

    public void putAll(Map map) {
        Iterator itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            String key = (String)entry.getKey();
            this.setAttribute(key, entry.getValue());
        }
    }

    public boolean isEmpty() {
        return !this.getAttributeNames().hasMoreElements();
    }

    public Set keySet() {
        if (this.keySet_ == null) {
            this.keySet_ = new KeySet(this);
        }
        return this.keySet_;
    }

    public Object remove(Object key) {
        String keyStr = key.toString();
        Object o = this.getAttribute(keyStr);
        this.removeAttribute(keyStr);
        return o;
    }

    public Collection values() {
        if (this.values_ == null) {
            this.values_ = new ValuesCollection(this);
        }
        return this.values_;
    }

    protected abstract Object getAttribute(String var1);

    protected abstract void setAttribute(String var1, Object var2);

    protected abstract Enumeration getAttributeNames();

    protected abstract void removeAttribute(String var1);

    protected static class ImmutableEntry
    implements Map.Entry {
        private final Object key_;
        private final Object value_;

        public ImmutableEntry(Object key, Object value) {
            this.key_ = key;
            this.value_ = value;
        }

        public Object getKey() {
            return this.key_;
        }

        public Object getValue() {
            return this.value_;
        }

        public Object setValue(Object arg0) {
            throw new UnsupportedOperationException("Immutable entry.");
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ImmutableEntry)) {
                return false;
            }
            ImmutableEntry entry = (ImmutableEntry)obj;
            Object key = entry.getKey();
            Object value = entry.getValue();
            return (key == this.key_ || key != null && key.equals(this.key_)) && (value == this.value_ || value != null && value.equals(this.value_));
        }

        public int hashCode() {
            return (this.key_ != null ? this.key_.hashCode() : 0) ^ (this.value_ != null ? this.value_.hashCode() : 0);
        }
    }

    class ValuesIterator
    extends AbstractExternalContextIterator {
        public ValuesIterator(AbstractExternalContextMap contextMap) {
            super(contextMap);
        }

        protected Object doNext() {
            String key = this.getCurrentKey();
            return this.getValueFromMap(key);
        }

        protected void doRemove() {
            String key = this.getCurrentKey();
            Object value = this.getValueFromMap(key);
            this.removeValueFromMap(value);
        }
    }

    class KeyIterator
    extends AbstractExternalContextIterator {
        public KeyIterator(AbstractExternalContextMap contextMap) {
            super(contextMap);
        }

        protected Object doNext() {
            return this.getCurrentKey();
        }

        protected void doRemove() {
            this.removeKeyFromMap(this.getCurrentKey());
        }
    }

    class EntryIterator
    extends AbstractExternalContextIterator {
        public EntryIterator(AbstractExternalContextMap contextMap) {
            super(contextMap);
        }

        protected Object doNext() {
            String key = this.getCurrentKey();
            return new ImmutableEntry(key, this.getValueFromMap(key));
        }

        protected void doRemove() {
            String key = this.getCurrentKey();
            this.removeKeyFromMap(key);
        }
    }

    abstract class AbstractExternalContextIterator
    extends EnumerationIterator {
        private final AbstractExternalContextMap contextMap_;
        private String currentKey_;
        private boolean removeCalled_;

        public AbstractExternalContextIterator(AbstractExternalContextMap contextMap) {
            super(contextMap.getAttributeNames());
            this.removeCalled_ = false;
            this.contextMap_ = contextMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            this.currentKey_ = (String)super.next();
            try {
                Object object = this.doNext();
                return object;
            }
            finally {
                this.removeCalled_ = false;
            }
        }

        public void remove() {
            if (this.currentKey_ == null || this.removeCalled_) {
                throw new IllegalStateException();
            }
            this.doRemove();
            this.removeCalled_ = true;
        }

        protected String getCurrentKey() {
            return this.currentKey_;
        }

        protected Object getValueFromMap(String key) {
            return this.contextMap_.get(key);
        }

        protected void removeKeyFromMap(String key) {
            this.contextMap_.remove(key);
        }

        protected void removeValueFromMap(Object value) {
            if (AbstractExternalContextMap.this.containsValue(value)) {
                Iterator itr = AbstractExternalContextMap.this.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry e = (Map.Entry)itr.next();
                    if (!value.equals(e.getValue())) continue;
                    this.contextMap_.remove(e.getKey());
                }
            }
        }

        protected abstract Object doNext();

        protected abstract void doRemove();
    }

    class ValuesCollection
    extends AbstractCollection {
        private AbstractExternalContextMap contextMap_;

        public ValuesCollection(AbstractExternalContextMap contextMap) {
            this.contextMap_ = contextMap;
        }

        public int size() {
            int size = 0;
            Iterator itr = this.iterator();
            while (itr.hasNext()) {
                itr.next();
                ++size;
            }
            return size;
        }

        public Iterator iterator() {
            return new ValuesIterator(this.contextMap_);
        }
    }

    class KeySet
    extends AbstractExternalContextSet {
        private AbstractExternalContextMap contextMap_;

        public KeySet(AbstractExternalContextMap contextMap) {
            this.contextMap_ = contextMap;
        }

        public Iterator iterator() {
            return new KeyIterator(this.contextMap_);
        }

        public boolean remove(Object o) {
            if (!(o instanceof String)) {
                return false;
            }
            String s = (String)o;
            Object returnObj = this.contextMap_.remove(s);
            return returnObj != null;
        }
    }

    class EntrySet
    extends AbstractExternalContextSet {
        private AbstractExternalContextMap contextMap_;

        public EntrySet(AbstractExternalContextMap contextMap) {
            this.contextMap_ = contextMap;
        }

        public Iterator iterator() {
            return new EntryIterator(this.contextMap_);
        }

        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object returnObj = this.contextMap_.remove(entry.getKey());
            return returnObj != null;
        }
    }

    abstract class AbstractExternalContextSet
    extends AbstractSet {
        AbstractExternalContextSet() {
        }

        public int size() {
            int size = 0;
            Iterator itr = this.iterator();
            while (itr.hasNext()) {
                itr.next();
                ++size;
            }
            return size;
        }
    }
}

