/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.Map;
import java.util.Random;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import org.seasar.framework.util.StringUtil;

public abstract class WindowIdUtil {
    public static final String NEWWINDOW = "newwindow";
    public static final String WID = "wid";
    private static final String BLANK = "_blank";
    private static Random random = new Random(System.currentTimeMillis());

    protected WindowIdUtil() {
    }

    public static String setupWindowId(ExternalContext externalContext) throws FacesException {
        String wid = null;
        if (WindowIdUtil.needNewWindow(externalContext.getRequestParameterMap())) {
            wid = WindowIdUtil.createWindowId();
        } else {
            Map paramMap = externalContext.getRequestParameterMap();
            wid = (String)paramMap.get(WID);
        }
        WindowIdUtil.setWindowId(externalContext, wid);
        return wid;
    }

    public static synchronized String createWindowId() {
        return Long.toString(random.nextLong());
    }

    public static String getWindowId(ExternalContext externalContext) throws FacesException {
        Map requestMap = externalContext.getRequestMap();
        return (String)requestMap.get(WID);
    }

    public static void setWindowId(ExternalContext externalContext, String wid) throws FacesException {
        Map requestMap = externalContext.getRequestMap();
        requestMap.put(WID, wid);
    }

    public static boolean isNewWindowTarget(String target) {
        if (StringUtil.isEmpty((String)target)) {
            return false;
        }
        return BLANK.equals(target) || target.charAt(0) != '_';
    }

    public static boolean needNewWindow(Map parameterMap) {
        String newwindow = (String)parameterMap.get(NEWWINDOW);
        return "true".equals(newwindow);
    }
}

