/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.List;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.el.ValueBinding;
import javax.faces.internal.PageContextOutWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.validator.Validator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.jsp.PageContext;

public class WebAppUtil {
    private WebAppUtil() {
    }

    public static UIComponent createComponent(FacesContext context, String binding, String componentType) {
        UIComponent component = null;
        Application application = context.getApplication();
        if (binding != null) {
            ValueBinding vb = application.createValueBinding(binding);
            component = application.createComponent(vb, context, componentType);
            component.setValueBinding("binding", vb);
        } else {
            component = application.createComponent(componentType);
        }
        return component;
    }

    public static List getCreatedComponentIds(UIComponent component) {
        return (List)component.getAttributes().get("javax.faces.webapp.COMPONENT_IDS");
    }

    public static void setCreatedComponentIds(UIComponent component, List createdComponents) {
        component.getAttributes().put("javax.faces.webapp.COMPONENT_IDS", createdComponents);
    }

    public static void removeCreatedComponentIds(UIComponent component) {
        component.getAttributes().remove("javax.faces.webapp.COMPONENT_IDS");
    }

    public static List getCreatedFacetNames(UIComponent component) {
        return (List)component.getAttributes().get("javax.faces.webapp.FACET_NAMES");
    }

    public static void setCreatedFacetNames(UIComponent component, List createdComponents) {
        component.getAttributes().put("javax.faces.webapp.FACET_NAMES", createdComponents);
    }

    public static void removeCreatedFacetNames(UIComponent component) {
        component.getAttributes().remove("javax.faces.webapp.FACET_NAMES");
    }

    public static ResponseWriter buildResponseWriter(FacesContext facesContext, PageContext pageContext) {
        RenderKitFactory factory = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
        RenderKit renderKit = factory.getRenderKit(facesContext, facesContext.getViewRoot().getRenderKitId());
        PageContextOutWriter writer = new PageContextOutWriter(pageContext);
        String encoding = pageContext.getRequest().getCharacterEncoding();
        FacesContext context = FacesContext.getCurrentInstance();
        String acceptContentTypes = WebAppUtil.getAcceptHeader(context);
        return renderKit.createResponseWriter(writer, acceptContentTypes, encoding);
    }

    public static String getAcceptHeader(FacesContext context) {
        return (String)context.getExternalContext().getRequestHeaderMap().get("accept");
    }

    public static Object getValueFromCreatedValueBinding(String buindName) {
        FacesContext context = WebAppUtil.getFacesContext();
        ValueBinding vb = context.getApplication().createValueBinding(buindName);
        return vb.getValue(context);
    }

    public static Converter createConverter(String converterId) {
        FacesContext context = WebAppUtil.getFacesContext();
        return context.getApplication().createConverter(converterId);
    }

    public static Converter createConverter(Class clazz) {
        FacesContext context = WebAppUtil.getFacesContext();
        return context.getApplication().createConverter(clazz);
    }

    public static Validator createValidator(String validatorId) {
        FacesContext context = WebAppUtil.getFacesContext();
        return context.getApplication().createValidator(validatorId);
    }

    public static FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    public static Object getFactory(String factoryName) throws ServletException {
        try {
            return FactoryFinder.getFactory(factoryName);
        }
        catch (FacesException e) {
            Throwable rootCause = e.getCause();
            if (rootCause == null) {
                throw e;
            }
            throw new ServletException(e.getMessage(), rootCause);
        }
    }

    public static String getLifecycleId(ServletConfig config) {
        String lifecycleId = config.getServletContext().getInitParameter("javax.faces.LIFECYCLE_ID");
        if (lifecycleId == null) {
            lifecycleId = "DEFAULT";
        }
        return lifecycleId;
    }
}

