/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.ComponentUtil_;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.faces.internal.ConverterResource;
import javax.faces.internal.FacesMessageUtil;
import javax.faces.internal.UIComponentUtil;
import javax.faces.internal.UIInputUtil;
import javax.faces.internal.ValidatorLookupStrategy;
import javax.faces.internal.ValidatorLookupStrategyUtil;
import javax.faces.internal.ValidatorResource;
import javax.faces.render.Renderer;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.seasar.framework.util.AssertionUtil;

public class UIInput
extends UIOutput
implements EditableValueHolder {
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    public static final String COMPONENT_TYPE = "javax.faces.Input";
    public static final String CONVERSION_MESSAGE_ID = "javax.faces.component.UIInput.CONVERSION";
    public static final String REQUIRED_MESSAGE_ID = "javax.faces.component.UIInput.REQUIRED";
    private Object submittedValue = null;
    private boolean localValueSet = false;
    private boolean required = false;
    private boolean requiredSet = false;
    private boolean valid = false;
    private boolean validSet = false;
    private boolean immediate = false;
    private boolean immediateSet = false;
    private MethodBinding validatorBinding = null;
    private MethodBinding valueChangeMethod = null;
    private List validators = null;
    private static final String DEFAULT_RENDER_TYPE = "javax.faces.Text";
    private static final Validator[] EMPTY_VALIDATOR_ARRAY = new Validator[0];

    public UIInput() {
        this.setRendererType(DEFAULT_RENDER_TYPE);
    }

    public String getFamily() {
        return "javax.faces.Input";
    }

    public Object getSubmittedValue() {
        return this.submittedValue;
    }

    public void setSubmittedValue(Object submittedValue) {
        this.submittedValue = submittedValue;
    }

    public Object getValue() {
        if (this.isLocalValueSet()) {
            return this.getLocalValue();
        }
        return super.getValue();
    }

    public void setValue(Object value) {
        if ("".equals(value)) {
            value = null;
        }
        super.setValue(value);
        this.setLocalValueSet(true);
    }

    public boolean isLocalValueSet() {
        return this.localValueSet;
    }

    public void setLocalValueSet(boolean localValueSet) {
        this.localValueSet = localValueSet;
    }

    public boolean isRequired() {
        if (this.requiredSet) {
            return this.required;
        }
        Boolean value = (Boolean)ComponentUtil_.getValueBindingValue(this, "required");
        return value != null ? Boolean.TRUE.equals(value) : this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
        this.requiredSet = true;
    }

    public boolean isValid() {
        if (this.validSet) {
            return this.valid;
        }
        Boolean value = (Boolean)ComponentUtil_.getValueBindingValue(this, "valid");
        return value != null ? Boolean.TRUE.equals(value) : this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
        this.validSet = true;
    }

    public boolean isImmediate() {
        if (this.immediateSet) {
            return this.immediate;
        }
        Boolean value = (Boolean)ComponentUtil_.getValueBindingValue(this, "immediate");
        return value != null ? Boolean.TRUE.equals(value) : this.immediate;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
        this.immediateSet = true;
    }

    public MethodBinding getValidator() {
        return this.validatorBinding;
    }

    public void setValidator(MethodBinding validatorBinding) {
        this.validatorBinding = validatorBinding;
    }

    public MethodBinding getValueChangeListener() {
        return this.valueChangeMethod;
    }

    public void setValueChangeListener(MethodBinding valueChangeMethod) {
        this.valueChangeMethod = valueChangeMethod;
    }

    public void processDecodes(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (!this.isRendered()) {
            return;
        }
        super.processDecodes(context);
        if (this.isImmediate()) {
            this.executeValidate(context);
        }
    }

    public void processValidators(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (!this.isRendered()) {
            return;
        }
        super.processValidators(context);
        if (!this.isImmediate()) {
            this.executeValidate(context);
        }
    }

    public void processUpdates(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (!this.isRendered()) {
            return;
        }
        try {
            this.updateModel(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        super.processUpdates(context);
        this.renderResponseIfNotValid(context);
    }

    public void decode(FacesContext context) {
        this.setValid(true);
        super.decode(context);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        MethodBinding valueChangeListenerBinding;
        super.broadcast(event);
        if (event instanceof ValueChangeEvent && (valueChangeListenerBinding = this.getValueChangeListener()) != null) {
            try {
                valueChangeListenerBinding.invoke(this.getFacesContext(), new Object[]{event});
            }
            catch (EvaluationException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof AbortProcessingException) {
                    throw (AbortProcessingException)cause;
                }
                throw e;
            }
        }
    }

    public void updateModel(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        ValueBinding valueBinding = this.getValueBinding("value");
        if (valueBinding == null) {
            return;
        }
        try {
            Object localValue = this.getLocalValue();
            valueBinding.setValue(context, localValue);
            this.setValue(null);
            this.setLocalValueSet(false);
        }
        catch (RuntimeException e) {
            Object[] args = new Object[]{UIComponentUtil.getLabel(this)};
            context.getExternalContext().log(e.getMessage(), e);
            FacesMessageUtil.addErrorComponentMessage(context, this, CONVERSION_MESSAGE_ID, args);
            this.setValid(false);
        }
    }

    public void validate(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        Object submittedValue = this.getSubmittedValue();
        if (submittedValue == null) {
            return;
        }
        Object convertedValue = this.getConvertedValue(context, submittedValue);
        if (!this.isValid()) {
            return;
        }
        this.validateValue(context, convertedValue);
        if (!this.isValid()) {
            return;
        }
        if (this.isLocalValueSet() && this.getValue() == null) {
            this.setLocalValueSet(false);
            return;
        }
        Object previous = this.getValue();
        this.setValue(convertedValue);
        this.setSubmittedValue(null);
        if (this.compareValues(previous, convertedValue)) {
            this.queueEvent(new ValueChangeEvent(this, previous, convertedValue));
        }
    }

    protected Object getConvertedValue(FacesContext context, Object submittedValue) throws ConverterException {
        Object value = submittedValue;
        try {
            value = this.convertFromAnnotation(context, submittedValue);
            if (value != null) {
                return value;
            }
            Renderer renderer = this.getRenderer(context);
            value = renderer != null ? this.convertFromRenderer(context, submittedValue, renderer) : this.convertFromType(context, submittedValue);
        }
        catch (ConverterException e) {
            this.handleConverterException(context, e);
        }
        return value;
    }

    protected void handleConverterException(FacesContext context, ConverterException e) {
        this.setValid(false);
        FacesMessage facesMessage = e.getFacesMessage();
        if (facesMessage != null) {
            context.addMessage(this.getClientId(context), facesMessage);
        } else {
            Object[] args = new Object[]{UIComponentUtil.getLabel(this)};
            FacesMessageUtil.addErrorComponentMessage(context, this, CONVERSION_MESSAGE_ID, args);
        }
    }

    protected Object convertFromAnnotation(FacesContext context, Object submittedValue) {
        String expression;
        Converter converter;
        ValueBinding vb = this.getValueBinding("value");
        if (vb != null && (converter = ConverterResource.getConverter(expression = vb.getExpressionString())) != null) {
            return converter.getAsObject(context, this, submittedValue instanceof String ? (String)submittedValue : null);
        }
        return null;
    }

    protected Object convertFromRenderer(FacesContext context, Object submittedValue, Renderer renderer) throws ConverterException {
        return renderer.getConvertedValue(context, this, submittedValue);
    }

    protected Object convertFromType(FacesContext context, Object submittedValue) throws ConverterException {
        Converter converter;
        if (submittedValue instanceof String && (converter = this.getConverterWithType(context)) != null) {
            return converter.getAsObject(context, this, submittedValue instanceof String ? (String)submittedValue : null);
        }
        return submittedValue;
    }

    protected void validateValue(FacesContext context, Object newValue) {
        if (this.isValid() && this.isRequired() && UIInputUtil.isEmpty(newValue)) {
            Object[] args = new Object[]{UIComponentUtil.getLabel(this)};
            FacesMessageUtil.addErrorComponentMessage(context, this, REQUIRED_MESSAGE_ID, args);
            this.setValid(false);
        }
        if (this.isValid() && !UIInputUtil.isEmpty(newValue)) {
            this.validateFromAddedValidator(context, newValue);
            this.validateFromBinding(context, newValue);
        }
        this.validateForExtension(context, newValue);
    }

    protected void validateForExtension(FacesContext context, Object value) {
        Validator validator = null;
        ValidatorLookupStrategy strategy = ValidatorLookupStrategyUtil.getValidatorLookupStrategy();
        if (strategy != null) {
            validator = strategy.findValidator(context, this, value);
        } else {
            ValueBinding vb = this.getValueBinding("value");
            if (vb != null) {
                String expression = vb.getExpressionString();
                validator = ValidatorResource.getValidator(expression);
            }
        }
        if (validator == null) {
            return;
        }
        try {
            validator.validate(context, this, value);
        }
        catch (ValidatorException e) {
            this.handleValidationException(context, e);
        }
    }

    protected boolean compareValues(Object previous, Object value) {
        if (previous == null && value == null) {
            return false;
        }
        if (previous == null || value == null) {
            return true;
        }
        return !previous.equals(value);
    }

    public void addValidator(Validator validator) {
        AssertionUtil.assertNotNull((String)"validator", (Object)validator);
        if (this.validators == null) {
            this.validators = new ArrayList();
        }
        this.validators.add(validator);
    }

    public Validator[] getValidators() {
        if (this.validators == null) {
            return EMPTY_VALIDATOR_ARRAY;
        }
        return this.validators.toArray(new Validator[this.validators.size()]);
    }

    public void removeValidator(Validator validator) {
        if (this.validators != null) {
            this.validators.remove(validator);
        }
    }

    public void addValueChangeListener(ValueChangeListener listener) {
        AssertionUtil.assertNotNull((String)"listener", (Object)listener);
        this.addFacesListener(listener);
    }

    public ValueChangeListener[] getValueChangeListeners() {
        return (ValueChangeListener[])this.getFacesListeners(ValueChangeListener.class);
    }

    public void removeValueChangeListener(ValueChangeListener listener) {
        this.removeFacesListener(listener);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.localValueSet ? Boolean.TRUE : Boolean.FALSE, this.required ? Boolean.TRUE : Boolean.FALSE, this.requiredSet ? Boolean.TRUE : Boolean.FALSE, this.valid ? Boolean.TRUE : Boolean.FALSE, this.immediate ? Boolean.TRUE : Boolean.FALSE, this.immediateSet ? Boolean.TRUE : Boolean.FALSE, UIInput.saveAttachedState(context, this.validators), UIInput.saveAttachedState(context, this.validatorBinding), UIInput.saveAttachedState(context, this.valueChangeMethod)};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.localValueSet = (Boolean)values[1];
        this.required = (Boolean)values[2];
        this.requiredSet = (Boolean)values[3];
        this.valid = (Boolean)values[4];
        this.immediate = (Boolean)values[5];
        this.immediateSet = (Boolean)values[6];
        List restoredValidators = (List)UIInput.restoreAttachedState(context, values[7]);
        if (restoredValidators != null) {
            if (this.validators != null) {
                Iterator itr = restoredValidators.iterator();
                while (itr.hasNext()) {
                    this.validators.add(itr.next());
                }
            } else {
                this.validators = restoredValidators;
            }
        }
        this.validatorBinding = (MethodBinding)UIInput.restoreAttachedState(context, values[8]);
        this.valueChangeMethod = (MethodBinding)UIInput.restoreAttachedState(context, values[9]);
    }

    protected void executeValidate(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        this.renderResponseIfNotValid(context);
    }

    private Converter getConverterWithType(FacesContext context) {
        Converter converter = this.getConverter();
        if (converter != null) {
            return converter;
        }
        Class type = ComponentUtil_.getValueBindingType(this, "value");
        if (ComponentUtil_.isPerformNoConversion(type)) {
            return null;
        }
        try {
            return ComponentUtil_.createConverter(context, type);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    protected void renderResponseIfNotValid(FacesContext context) {
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    protected void validateFromAddedValidator(FacesContext context, Object value) {
        if (this.validators == null) {
            return;
        }
        Iterator itr = this.validators.iterator();
        while (itr.hasNext()) {
            Validator validator = (Validator)itr.next();
            try {
                validator.validate(context, this, value);
            }
            catch (ValidatorException e) {
                this.handleValidationException(context, e);
            }
        }
    }

    protected void validateFromBinding(FacesContext context, Object value) {
        if (this.validatorBinding == null) {
            return;
        }
        try {
            this.validatorBinding.invoke(context, new Object[]{context, this, value});
        }
        catch (EvaluationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ValidatorException) {
                ValidatorException ve = (ValidatorException)e.getCause();
                this.handleValidationException(context, ve);
            }
            throw e;
        }
    }

    protected void handleValidationException(FacesContext context, ValidatorException e) {
        this.setValid(false);
        FacesMessage message = e.getFacesMessage();
        if (message != null) {
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            context.addMessage(this.getClientId(context), message);
        }
    }
}

