/*
 * Decompiled with CFR 0.152.
 */
package javax.faces;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.internal.FactoryFinderUtil;
import org.seasar.framework.util.AssertionUtil;

public final class FactoryFinder {
    public static final String APPLICATION_FACTORY = "javax.faces.application.ApplicationFactory";
    public static final String FACES_CONTEXT_FACTORY = "javax.faces.context.FacesContextFactory";
    public static final String LIFECYCLE_FACTORY = "javax.faces.lifecycle.LifecycleFactory";
    public static final String RENDER_KIT_FACTORY = "javax.faces.render.RenderKitFactory";
    private static final Map factories = new HashMap();
    private static final Map factoryClassNames = new HashMap();

    public static Object getFactory(String factoryName) throws FacesException {
        AssertionUtil.assertNotNull((String)"factoryName", (Object)factoryName);
        if (!factoryClassNames.containsKey(factoryName)) {
            throw new IllegalStateException("no factory " + factoryName + " configured for this application");
        }
        Object factory = factories.get(factoryName);
        if (factory == null) {
            List classNames = (List)factoryClassNames.get(factoryName);
            factory = FactoryFinderUtil.createFactoryInstance(factoryName, classNames);
            factories.put(factoryName, factory);
            return factory;
        }
        return factory;
    }

    public static void setFactory(String factoryName, String implName) {
        AssertionUtil.assertNotNull((String)"factoryName", (Object)factoryName);
        FactoryFinderUtil.checkValidFactoryNames(factoryName);
        ArrayList<String> classNameList = (ArrayList<String>)factoryClassNames.get(factoryName);
        if (classNameList == null) {
            classNameList = new ArrayList<String>();
            factoryClassNames.put(factoryName, classNameList);
        }
        if (classNameList.contains(implName)) {
            return;
        }
        classNameList.add(implName);
    }

    public static void releaseFactories() throws FacesException {
        factories.clear();
        factoryClassNames.clear();
    }
}

