/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.id;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.persistence.SequenceGenerator;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.JdbcContext;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.SqlLogger;
import org.seasar.extension.jdbc.id.AbstractPreAllocateIdGenerator;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.framework.util.PreparedStatementUtil;
import org.seasar.framework.util.ResultSetUtil;
import org.seasar.framework.util.StringUtil;

public class SequenceIdGenerator
extends AbstractPreAllocateIdGenerator {
    protected String sequenceName;

    public SequenceIdGenerator(EntityMeta entityMeta, PropertyMeta propertyMeta, SequenceGenerator sequenceGenerator) {
        super(entityMeta, propertyMeta, sequenceGenerator.allocationSize());
        this.sequenceName = this.getSequenceName(sequenceGenerator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getNewInitialValue(JdbcManagerImplementor jdbcManager, SqlLogger sqlLogger) {
        String sql = jdbcManager.getDialect().getSequenceNextValString(this.sequenceName, (int)this.allocationSize);
        sqlLogger.logSql(sql, new Object[0]);
        JdbcContext jdbcContext = jdbcManager.getJdbcContext();
        try {
            long l;
            PreparedStatement ps = jdbcContext.getPreparedStatement(sql);
            ResultSet rs = PreparedStatementUtil.executeQuery((PreparedStatement)ps);
            try {
                l = this.getGeneratedId(rs);
            }
            catch (Throwable throwable) {
                ResultSetUtil.close((ResultSet)rs);
                throw throwable;
            }
            ResultSetUtil.close((ResultSet)rs);
            return l;
        }
        finally {
            if (!jdbcContext.isTransactional()) {
                jdbcContext.destroy();
            }
        }
    }

    protected String getSequenceName(SequenceGenerator sequenceGenerator) {
        String sequenceName = sequenceGenerator.sequenceName();
        if (!StringUtil.isEmpty((String)sequenceName)) {
            return sequenceName;
        }
        return this.entityMeta.getTableMeta().getName() + "_" + this.propertyMeta.getColumnMeta().getName();
    }
}

