/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.httpsession;

import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.seasar.extension.httpsession.SessionState;
import org.seasar.extension.httpsession.SessionStateManager;

public class S2HttpSession
implements HttpSession {
    private String id;
    private SessionStateManager sessionStateManager;
    private ServletContext servletContext;
    private boolean isNew = false;
    private SessionState sessionState;
    private long creationTime = new Date().getTime();
    private int maxInactiveInterval = Integer.MAX_VALUE;

    public S2HttpSession(String id, SessionStateManager sessionStateManager, ServletContext servletContext, boolean isNew) {
        this.id = id;
        this.sessionStateManager = sessionStateManager;
        this.isNew = isNew;
    }

    public SessionState getSessionState() {
        return this.sessionState;
    }

    public Object getAttribute(String name) {
        this.setupSessionState();
        return this.sessionState.getAttribute(name);
    }

    protected synchronized void setupSessionState() {
        if (this.sessionState == null) {
            this.sessionState = this.sessionStateManager.loadState(this.id);
        }
    }

    public Enumeration getAttributeNames() {
        this.setupSessionState();
        return this.sessionState.getAttributeNames();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        this.setupSessionState();
        return this.sessionState.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        ArrayList list = new ArrayList();
        Enumeration e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        return list.toArray(new String[list.size()]);
    }

    public void invalidate() {
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.setAttribute(name, null);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.setupSessionState();
        this.sessionState.setAttribute(name, value);
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }
}

