/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.validator;

import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.internal.FacesMessageUtil;
import javax.faces.internal.UIComponentUtil;
import javax.faces.internal.UIInputUtil;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.exception.ExtendValidatorException;
import org.seasar.teeda.extension.util.TargetCommandUtil;
import org.seasar.teeda.extension.validator.ValidationTargetSelectable;

public class TRequiredValidator
implements Validator,
StateHolder,
ValidationTargetSelectable {
    public static final String VALIDATOR_ID = "javax.faces.Required";
    public static final String REQUIRED_MESSAGE_ID = "javax.faces.component.UIInput.REQUIRED";
    protected boolean transientValue = false;
    protected String target;
    protected String[] targets;
    protected String messageId;

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)component);
        if (!this.isTargetCommandValidation(context, this.targets)) {
            return;
        }
        if (UIInputUtil.isEmpty((Object)value)) {
            Object[] args = new Object[]{UIComponentUtil.getLabel((UIComponent)component)};
            String msgId = this.getMessageId() != null ? this.getMessageId() : REQUIRED_MESSAGE_ID;
            FacesMessage message = FacesMessageUtil.getMessage((FacesContext)context, (String)msgId, (Object[])args);
            throw new ExtendValidatorException(message, new String[]{msgId});
        }
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
        if (StringUtil.isEmpty((String)target)) {
            return;
        }
        this.targets = StringUtil.split((String)target, (String)", ");
    }

    public String getMessageId() {
        return !StringUtil.isEmpty((String)this.messageId) ? this.messageId : REQUIRED_MESSAGE_ID;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.target, this.messageId};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.setTarget((String)values[0]);
        this.messageId = (String)values[1];
    }

    public boolean isTargetCommandValidation(FacesContext context, String[] targets) {
        return TargetCommandUtil.isTargetCommand(context, targets);
    }

    public String[] getTargets() {
        return this.targets;
    }
}

