/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.annotation.handler;

import java.lang.reflect.Field;
import java.util.Map;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.util.ConstantAnnotationUtil;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.FieldUtil;
import org.seasar.teeda.extension.annotation.handler.AbstractValidatorAnnotationHandler;

public class ConstantValidatorAnnotationHandler
extends AbstractValidatorAnnotationHandler {
    public void registerValidators(String componentName) {
        this.removeValidators(componentName);
        S2Container container = this.getContainer();
        NamingConvention namingConvention = (NamingConvention)container.getComponent((Object)NamingConvention.class);
        ComponentDef componentDef = container.getComponentDef((Object)componentName);
        Class componentClass = componentDef.getComponentClass();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)componentClass);
        Field[] fields = componentClass.getFields();
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc propertyDesc = beanDesc.getPropertyDesc(i);
            this.processProperty(container, componentClass, componentName, namingConvention, propertyDesc, fields);
        }
    }

    protected void processProperty(S2Container container, Class componentClass, String componentName, NamingConvention namingConvention, PropertyDesc propertyDesc, Field[] fields) {
        String propertyName = propertyDesc.getPropertyName();
        String annotationPrefix = propertyName + "_";
        for (int i = 0; i < fields.length; ++i) {
            String validatorName;
            Field annotation = fields[i];
            String annotationName = annotation.getName();
            boolean isConstantAnnotation = ConstantAnnotationUtil.isConstantAnnotation((Field)annotation);
            if (!isConstantAnnotation || !annotationName.startsWith(annotationPrefix) || !annotationName.endsWith(namingConvention.getValidatorSuffix()) || !container.hasComponentDef((Object)(validatorName = annotationName.substring(annotationPrefix.length())))) continue;
            String s = FieldUtil.getString((Field)annotation, null);
            Map properties = ConstantAnnotationUtil.convertExpressionToMap((String)s);
            this.registerValidator(componentName, propertyName, validatorName, properties);
        }
    }
}

