/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.util.Iterator;
import java.util.List;
import org.seasar.framework.log.Logger;
import org.seasar.teeda.core.util.CancelHandler;
import org.seasar.teeda.core.util.DIContainerUtil;

public class CancelUtil {
    private static final Logger logger = Logger.getLogger((Class)CancelUtil.class);
    private static CancelHandler handler = null;

    public static boolean isCancelled(Throwable t) {
        if (t == null) {
            return false;
        }
        if (handler == null && (handler = (CancelHandler)DIContainerUtil.getComponentNoException(CancelHandler.class)) == null) {
            return false;
        }
        List candidates = handler.getCancellableExceptions();
        Iterator itr = candidates.iterator();
        while (itr.hasNext()) {
            Class tc = (Class)itr.next();
            if (t.getClass() != tc) continue;
            logger.log("WTDA0206", new Object[]{t});
            return true;
        }
        List nameCandidates = handler.getCancellableExceptionNames();
        Iterator itr2 = nameCandidates.iterator();
        while (itr2.hasNext()) {
            String name = (String)itr2.next();
            if (!t.getClass().getName().endsWith(name)) continue;
            logger.log("WTDA0206", new Object[]{t});
            return true;
        }
        return false;
    }

    public static void clear() {
        handler = null;
    }
}

