/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.scope.impl;

import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.seasar.teeda.core.scope.impl.DispatchScope;

public class DispatchScopeFactory {
    public static final String DISPATCH_SCOPE_KEY = DispatchScopeFactory.class.getName() + ".DISPATCH_SCOPE_KEY";

    public static void create() {
        Map requestMap = DispatchScopeFactory.getRequestMap();
        requestMap.put(DISPATCH_SCOPE_KEY, new DispatchScope());
    }

    public static DispatchScope getDispatchScope() {
        if (!DispatchScopeFactory.initialized()) {
            DispatchScopeFactory.create();
        }
        return (DispatchScope)DispatchScopeFactory.getRequestMap().get(DISPATCH_SCOPE_KEY);
    }

    private static boolean initialized() {
        Map requestMap = DispatchScopeFactory.getRequestMap();
        if (requestMap == null) {
            return false;
        }
        return requestMap.containsKey(DISPATCH_SCOPE_KEY);
    }

    public static void destroy() {
        Map requestMap = DispatchScopeFactory.getRequestMap();
        if (requestMap == null) {
            return;
        }
        DispatchScopeFactory.getRequestMap().remove(DISPATCH_SCOPE_KEY);
        DispatchScopeFactory.create();
    }

    protected static Map getRequestMap() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            return null;
        }
        ExternalContext externalContext = context.getExternalContext();
        return externalContext.getRequestMap();
    }
}

