/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.internal.IgnoreAttribute;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.core.util.RendererUtil;

public class HtmlCommandButtonRenderer
extends AbstractRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Command";
    public static final String RENDERER_TYPE = "javax.faces.Button";
    private final IgnoreAttribute ignoreComponent = new IgnoreAttribute();

    public HtmlCommandButtonRenderer() {
        this.addIgnoreAttributeName("id");
        this.addIgnoreAttributeName("name");
        this.addIgnoreAttributeName("type");
        this.addIgnoreAttributeName("value");
        this.addIgnoreAttributeName("image");
        this.addIgnoreAttributeName("action");
        this.addIgnoreAttributeName("immediate");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlCommandButtonEnd(context, (HtmlCommandButton)component);
    }

    protected void encodeHtmlCommandButtonEnd(FacesContext context, HtmlCommandButton htmlCommandButton) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", htmlCommandButton);
        String image = this.getImage(context, htmlCommandButton);
        boolean isImageType = StringUtil.isNotBlank((String)image);
        String type = isImageType ? "image" : htmlCommandButton.getType();
        RendererUtil.renderAttribute(writer, "type", (Object)type);
        String id = this.getIdForRender(context, htmlCommandButton);
        RendererUtil.renderIdAttributeIfNecessary(writer, htmlCommandButton, id);
        RendererUtil.renderAttribute(writer, "name", (Object)htmlCommandButton.getClientId(context));
        if (isImageType) {
            RendererUtil.renderAttribute(writer, "src", image, "image");
        } else {
            this.renderValueAttribute(context, htmlCommandButton, writer);
        }
        this.renderRemainAttributes(htmlCommandButton, writer, this.ignoreComponent);
        writer.endElement("input");
    }

    protected String getImage(FacesContext context, HtmlCommandButton htmlCommandButton) {
        return htmlCommandButton.getImage();
    }

    protected void renderValueAttribute(FacesContext context, UICommand command, ResponseWriter writer) throws IOException {
        RendererUtil.renderAttribute(writer, "value", command.getValue());
    }

    public void decode(FacesContext context, UIComponent component) {
        this.assertNotNull(context, component);
        this.decodeHtmlCommandButton(context, (HtmlCommandButton)component);
    }

    protected void decodeHtmlCommandButton(FacesContext context, HtmlCommandButton htmlCommandButton) {
        String clientId;
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        if ((paramMap.containsKey(clientId = htmlCommandButton.getClientId(context)) || paramMap.containsKey(clientId + ".x") || paramMap.containsKey(clientId + ".y")) && !"reset".equalsIgnoreCase(htmlCommandButton.getType())) {
            this.enqueueEvent(htmlCommandButton);
        }
    }

    protected void enqueueEvent(HtmlCommandButton htmlCommandButton) {
        htmlCommandButton.queueEvent(new ActionEvent(htmlCommandButton));
    }

    protected void addIgnoreAttributeName(String attr) {
        this.ignoreComponent.addAttributeName(attr);
    }
}

