/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.internal.FacesMessageUtil;
import javax.faces.internal.UIComponentUtil;
import javax.faces.internal.UIInputUtil;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.DoubleConversionUtil;

public class DoubleRangeValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "javax.faces.DoubleRange";
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.MINIMUM";
    public static final String TYPE_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.TYPE";
    private double maximum = Double.MAX_VALUE;
    private double minimum = Double.MIN_VALUE;
    private boolean transientValue = false;

    public DoubleRangeValidator() {
    }

    public DoubleRangeValidator(double maximum) {
        this.maximum = maximum;
    }

    public DoubleRangeValidator(double maximum, double minimum) {
        this.maximum = maximum;
        this.minimum = minimum;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DoubleRangeValidator)) {
            return false;
        }
        DoubleRangeValidator v = (DoubleRangeValidator)obj;
        return this.maximum == v.maximum && this.minimum == v.minimum;
    }

    public int hashCode() {
        return (int)this.maximum * (int)this.minimum * 17;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] obj = (Object[])state;
        this.maximum = (Double)obj[0];
        this.minimum = (Double)obj[1];
    }

    public Object saveState(FacesContext context) {
        Object[] obj = new Object[]{new Double(this.maximum), new Double(this.minimum)};
        return obj;
    }

    public void setMaximum(double maximum) {
        this.maximum = maximum;
    }

    public void setMinimum(double minimum) {
        this.minimum = minimum;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)component);
        if (UIInputUtil.isEmpty(value)) {
            return;
        }
        try {
            double doubleValue = DoubleConversionUtil.toDouble((Object)value);
            if (this.maximum != Double.MAX_VALUE && this.minimum != Double.MIN_VALUE) {
                if (doubleValue < this.minimum || doubleValue > this.maximum) {
                    Object[] args = new Object[]{new Double(this.minimum), new Double(this.maximum), UIComponentUtil.getLabel(component)};
                    FacesMessage message = FacesMessageUtil.getMessage(context, this.getNotInRangeMessageId(), this.convertArgs(args));
                    throw new ValidatorException(message, this.getNotInRangeMessageId(), args);
                }
            } else if (this.minimum != Double.MIN_VALUE) {
                if (doubleValue < this.minimum) {
                    Object[] args = new Object[]{new Double(this.minimum), UIComponentUtil.getLabel(component)};
                    FacesMessage message = FacesMessageUtil.getMessage(context, this.getMinimumMessageId(), this.convertArgs(args));
                    throw new ValidatorException(message, this.getMinimumMessageId(), args);
                }
            } else if (this.maximum != Double.MAX_VALUE && doubleValue > this.maximum) {
                Object[] args = new Object[]{new Double(this.maximum), UIComponentUtil.getLabel(component)};
                FacesMessage message = FacesMessageUtil.getMessage(context, this.getMaximumMessageId(), this.convertArgs(args));
                throw new ValidatorException(message, this.getMaximumMessageId(), args);
            }
        }
        catch (NumberFormatException e) {
            Object[] args = new Object[]{UIComponentUtil.getLabel(component)};
            FacesMessage message = FacesMessageUtil.getMessage(context, this.getTypeMessageId(), args);
            throw new ValidatorException(message, this.getTypeMessageId(), args);
        }
    }

    protected String getMaximumMessageId() {
        return MAXIMUM_MESSAGE_ID;
    }

    protected String getMinimumMessageId() {
        return MINIMUM_MESSAGE_ID;
    }

    protected String getNotInRangeMessageId() {
        return "javax.faces.validator.NOT_IN_RANGE";
    }

    protected String getTypeMessageId() {
        return TYPE_MESSAGE_ID;
    }

    protected Object[] convertArgs(Object[] args) {
        return args;
    }
}

